/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.item;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.PokemonStats;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import kiwiapollo.cobblemontrainerbattle.item.FilledPokeBallPokemonParser;
import kiwiapollo.cobblemontrainerbattle.item.PokeBallComponent;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class FilledPokeBall
extends class_1792 {
    public FilledPokeBall() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        try {
            Pokemon pokemon = new FilledPokeBallPokemonParser().toPokemon(stack);
            class_5250 name = this.getPokemonSpecies(pokemon).method_27692(class_124.field_1054);
            class_5250 level = class_2561.method_43469((String)"cobblemon.ui.lv.number", (Object[])new Object[]{this.getPokemonLevel(pokemon)});
            tooltip.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)name).method_27693(" ").method_10852((class_2561)level));
            tooltip.add((class_2561)class_2561.method_43471((String)"cobblemon.ui.info.ability").method_27693(" : ").method_10852((class_2561)this.getPokemonAbility(pokemon)));
            tooltip.add((class_2561)class_2561.method_43471((String)"cobblemon.ui.info.nature").method_27693(" : ").method_10852((class_2561)this.getPokemonNature(pokemon)));
            tooltip.add((class_2561)class_2561.method_43471((String)"cobblemon.ui.moves").method_27693(" : ").method_10852((class_2561)this.getPokemonMoveSet(pokemon.getMoveSet())));
            tooltip.add((class_2561)class_2561.method_43471((String)"cobblemon.ui.stats.ivs").method_27693(" : ").method_10852((class_2561)this.getPokemonStats((PokemonStats)pokemon.getIvs())));
            tooltip.add((class_2561)class_2561.method_43471((String)"cobblemon.ui.stats.evs").method_27693(" : ").method_10852((class_2561)this.getPokemonStats((PokemonStats)pokemon.getEvs())));
        }
        catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException | NullPointerException throwable) {
            // empty catch block
        }
    }

    private int getPokemonLevel(Pokemon pokemon) {
        return pokemon.getLevel();
    }

    private class_5250 getPokemonSpecies(Pokemon pokemon) {
        return pokemon.getSpecies().getTranslatedName();
    }

    private class_5250 getPokemonAbility(Pokemon pokemon) {
        return class_2561.method_43471((String)pokemon.getAbility().getDisplayName());
    }

    private class_5250 getPokemonNature(Pokemon pokemon) {
        return class_2561.method_43471((String)pokemon.getNature().getDisplayName());
    }

    private class_5250 getPokemonMoveSet(MoveSet moveSet) {
        class_5250 text = class_2561.method_43470((String)"");
        for (Move move : moveSet.getMoves()) {
            if (text.equals((Object)class_2561.method_43470((String)""))) {
                text.method_10852((class_2561)move.getDisplayName());
                continue;
            }
            text.method_10852((class_2561)class_2561.method_43470((String)" / ")).method_10852((class_2561)move.getDisplayName());
        }
        return text;
    }

    private class_5250 getPokemonStats(PokemonStats stats) {
        return class_2561.method_43470((String)"").method_27693(String.format("HP %d", stats.get((Stat)Stats.HP))).method_27693(" / ").method_27693(String.format("ATK %d", stats.get((Stat)Stats.ATTACK))).method_27693(" / ").method_27693(String.format("DEF %d", stats.get((Stat)Stats.DEFENCE))).method_27693(" / ").method_27693(String.format("SPA %d", stats.get((Stat)Stats.SPECIAL_ATTACK))).method_27693(" / ").method_27693(String.format("SPD %d", stats.get((Stat)Stats.SPECIAL_DEFENCE))).method_27693(" / ").method_27693(String.format("SPE %d", stats.get((Stat)Stats.SPEED)));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (world.method_8608()) {
            return class_1271.method_22430((Object)stack);
        }
        if (this.isPlayerInBattle((class_3222)player)) {
            return class_1271.method_22430((Object)stack);
        }
        if (!this.hasPokemon(world.method_30349(), stack)) {
            return class_1271.method_22430((Object)stack);
        }
        Pokemon pokemon = FilledPokeBall.getPokemon(world.method_30349(), stack);
        Cobblemon.INSTANCE.getStorage().getParty((class_3222)player).add(pokemon);
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        return class_1271.method_22427((Object)stack);
    }

    private boolean isPlayerInBattle(class_3222 player) {
        Cobblemon.INSTANCE.getBattleRegistry();
        return BattleRegistry.getBattleByParticipatingPlayer((class_3222)player) != null;
    }

    private boolean hasPokemon(class_5455 registry, class_1799 stack) {
        try {
            FilledPokeBall.getPokemon(registry, stack);
            return true;
        }
        catch (IllegalStateException | NullPointerException ignored) {
            return false;
        }
    }

    public static Pokemon getPokemon(class_5455 registry, class_1799 stack) {
        if (FilledPokeBall.hasPokemonNbt(stack)) {
            FilledPokeBall.moveNbtToComponent(stack);
        }
        JsonObject json = JsonParser.parseString((String)Objects.requireNonNull((String)stack.method_57824(PokeBallComponent.POKEMON))).getAsJsonObject();
        return FilledPokeBall.toPokemon(registry, json);
    }

    private static Pokemon toPokemon(class_5455 registry, JsonObject json) {
        Pokemon pokemon = new Pokemon().loadFromJSON(registry, json).clone(true, null);
        JsonObject ivs = json.getAsJsonObject("IVs");
        pokemon.setIV((Stat)Stats.HP, ivs.getAsJsonPrimitive("cobblemon:hp").getAsInt());
        pokemon.setIV((Stat)Stats.ATTACK, ivs.getAsJsonPrimitive("cobblemon:attack").getAsInt());
        pokemon.setIV((Stat)Stats.DEFENCE, ivs.getAsJsonPrimitive("cobblemon:defence").getAsInt());
        pokemon.setIV((Stat)Stats.SPECIAL_ATTACK, ivs.getAsJsonPrimitive("cobblemon:special_attack").getAsInt());
        pokemon.setIV((Stat)Stats.SPECIAL_DEFENCE, ivs.getAsJsonPrimitive("cobblemon:special_defence").getAsInt());
        pokemon.setIV((Stat)Stats.SPEED, ivs.getAsJsonPrimitive("cobblemon:speed").getAsInt());
        JsonObject evs = json.getAsJsonObject("EVs");
        pokemon.setEV((Stat)Stats.HP, evs.getAsJsonPrimitive("cobblemon:hp").getAsInt());
        pokemon.setEV((Stat)Stats.ATTACK, evs.getAsJsonPrimitive("cobblemon:attack").getAsInt());
        pokemon.setEV((Stat)Stats.DEFENCE, evs.getAsJsonPrimitive("cobblemon:defence").getAsInt());
        pokemon.setEV((Stat)Stats.SPECIAL_ATTACK, evs.getAsJsonPrimitive("cobblemon:special_attack").getAsInt());
        pokemon.setEV((Stat)Stats.SPECIAL_DEFENCE, evs.getAsJsonPrimitive("cobblemon:special_defence").getAsInt());
        pokemon.setEV((Stat)Stats.SPEED, evs.getAsJsonPrimitive("cobblemon:speed").getAsInt());
        return pokemon;
    }

    private static void moveNbtToComponent(class_1799 stack) {
        String pokemon = ((class_9279)stack.method_57824(class_9334.field_49628)).method_57463().method_10558("Pokemon");
        stack.method_57379(PokeBallComponent.POKEMON, (Object)pokemon);
        ((class_9279)stack.method_57824(class_9334.field_49628)).method_57463().method_10551("Pokemon");
    }

    private static boolean hasPokemonNbt(class_1799 stack) {
        try {
            return !Objects.equals(((class_9279)stack.method_57824(class_9334.field_49628)).method_57463().method_10558("Pokemon"), "");
        }
        catch (NullPointerException e) {
            return false;
        }
    }
}

