/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.noNether;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class NoNetherListener
implements Listener {
    private final Map<UUID, Long> lastWarn = new HashMap<UUID, Long>();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPortal(PlayerPortalEvent e) {
        if (e.getTo() != null && e.getTo().getWorld() != null && e.getTo().getWorld().getEnvironment() == World.Environment.NETHER) {
            e.setCancelled(true);
            this.sendOnce(e.getPlayer(), "&f[&6&lNoNether&f] &cThe Nether is disabled!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        if (e.getTo() != null && e.getTo().getWorld() != null && e.getTo().getWorld().getEnvironment() == World.Environment.NETHER) {
            e.setCancelled(true);
            this.sendOnce(e.getPlayer(), "&f[&6&lNoNether&f] &cThe Nether is disabled!");
        }
    }

    private void sendOnce(Player player, String message) {
        if (player == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Long last = this.lastWarn.get(player.getUniqueId());
        if (last == null || now - last >= 1000L) {
            this.lastWarn.put(player.getUniqueId(), now);
            player.sendMessage(message.replace("&", "\u00a7"));
        }
    }
}

