/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardin.custommusicplus.audio;

import com.hindustani_gamer_fardin.custommusicplus.audio.OggDecoder;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Path;
import java.util.Locale;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CustomMusic+ AudioPlayer");
    private long device = 0L;
    private long context = 0L;
    private int sourceId = 0;
    private int bufferId = 0;
    private boolean initialized = false;

    public boolean play(Path audioPath) {
        try {
            String ext;
            LOGGER.info("Attempting to play: {}", (Object)audioPath);
            this.ensureInit();
            this.stop();
            this.clearBuffer();
            String fileName = audioPath.getFileName().toString().toLowerCase(Locale.ROOT);
            int dot = fileName.lastIndexOf(46);
            String string = ext = dot >= 0 ? fileName.substring(dot + 1) : "";
            if (!"ogg".equals(ext)) {
                LOGGER.warn("Unsupported audio format: {}", (Object)ext);
                return false;
            }
            OggDecoder.OggData data = OggDecoder.decode(audioPath);
            LOGGER.info("Decoded OGG: {} channels, {} Hz, {} samples", new Object[]{data.alFormat == 4353 ? 1 : 2, data.sampleRate, data.pcm.remaining()});
            ShortBuffer pcm = data.pcm;
            int alFormat = data.alFormat;
            int sampleRate = data.sampleRate;
            this.bufferId = AL10.alGenBuffers();
            this.checkALError("alGenBuffers");
            AL10.alBufferData((int)this.bufferId, (int)alFormat, (ShortBuffer)pcm, (int)sampleRate);
            this.checkALError("alBufferData");
            this.sourceId = AL10.alGenSources();
            this.checkALError("alGenSources");
            AL10.alSourcei((int)this.sourceId, (int)514, (int)1);
            AL10.alSource3f((int)this.sourceId, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)this.sourceId, (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSourcei((int)this.sourceId, (int)4105, (int)this.bufferId);
            AL10.alSourcef((int)this.sourceId, (int)4106, (float)1.0f);
            AL10.alSourcef((int)this.sourceId, (int)4099, (float)1.0f);
            this.checkALError("alSource setup");
            AL10.alSourcePlay((int)this.sourceId);
            this.checkALError("alSourcePlay");
            LOGGER.info("Successfully started playback for: {}", (Object)audioPath);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to play '{}': {}", (Object)audioPath, (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void pause() {
        if (!this.initialized || this.sourceId == 0) {
            return;
        }
        AL10.alSourcePause((int)this.sourceId);
    }

    public void resume() {
        if (!this.initialized || this.sourceId == 0) {
            return;
        }
        int state = AL10.alGetSourcei((int)this.sourceId, (int)4112);
        if (state == 4115) {
            AL10.alSourcePlay((int)this.sourceId);
        }
    }

    public void stop() {
        if (!this.initialized || this.sourceId == 0) {
            return;
        }
        AL10.alSourceStop((int)this.sourceId);
        AL10.alDeleteSources((int)this.sourceId);
        this.sourceId = 0;
    }

    public boolean isStopped() {
        if (!this.initialized || this.sourceId == 0) {
            return true;
        }
        int state = AL10.alGetSourcei((int)this.sourceId, (int)4112);
        return state == 4116;
    }

    public void update() {
    }

    public void cleanup() {
        this.stop();
        this.clearBuffer();
        if (this.context != 0L) {
            ALC10.alcMakeContextCurrent((long)0L);
            ALC10.alcDestroyContext((long)this.context);
            this.context = 0L;
        }
        if (this.device != 0L) {
            ALC10.alcCloseDevice((long)this.device);
            this.device = 0L;
        }
        this.initialized = false;
    }

    private void ensureInit() {
        if (this.initialized) {
            return;
        }
        LOGGER.info("Initializing OpenAL...");
        this.device = ALC10.alcOpenDevice((ByteBuffer)null);
        if (this.device == 0L) {
            throw new IllegalStateException("Failed to open default OpenAL device");
        }
        LOGGER.info("OpenAL device opened: {}", (Object)this.device);
        this.context = ALC10.alcCreateContext((long)this.device, (IntBuffer)null);
        if (this.context == 0L) {
            throw new IllegalStateException("Failed to create OpenAL context");
        }
        LOGGER.info("OpenAL context created: {}", (Object)this.context);
        ALC10.alcMakeContextCurrent((long)this.context);
        ALCCapabilities alcCaps = ALC.createCapabilities((long)this.device);
        AL.createCapabilities((ALCCapabilities)alcCaps);
        AL10.alListener3f((int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
        AL10.alListener3f((int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
        AL10.alListenerf((int)4106, (float)1.0f);
        this.initialized = true;
        LOGGER.info("OpenAL initialization complete");
    }

    private void checkALError(String operation) {
        int error = AL10.alGetError();
        if (error != 0) {
            Object errorMsg = switch (error) {
                case 40961 -> "AL_INVALID_NAME";
                case 40962 -> "AL_INVALID_ENUM";
                case 40963 -> "AL_INVALID_VALUE";
                case 40964 -> "AL_INVALID_OPERATION";
                case 40965 -> "AL_OUT_OF_MEMORY";
                default -> "Unknown error: " + error;
            };
            LOGGER.error("OpenAL error during {}: {}", (Object)operation, errorMsg);
        }
    }

    private void clearBuffer() {
        if (this.bufferId != 0) {
            AL10.alDeleteBuffers((int)this.bufferId);
            this.bufferId = 0;
        }
    }
}

