/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardin.custommusicplus.playlist;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CustomMusic+ PlaylistManager");
    private final Path baseDir;
    private final Path playlistsDir;
    private final Map<String, TrackInfo> tracks = new HashMap<String, TrackInfo>();
    private final Map<String, List<String>> playlists = new HashMap<String, List<String>>();

    public PlaylistManager(Path baseDir) {
        this.baseDir = baseDir;
        this.playlistsDir = baseDir.resolve("playlists");
    }

    public void ensureDirectories() {
        try {
            Files.createDirectories(this.baseDir, new FileAttribute[0]);
            Files.createDirectories(this.playlistsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config directories: {}", (Object)e.getMessage());
        }
    }

    public void scan() {
        block19: {
            String fileName;
            DirectoryStream<Path> stream;
            block18: {
                this.tracks.clear();
                this.playlists.clear();
                try {
                    if (!Files.exists(this.baseDir, new LinkOption[0]) || !Files.isDirectory(this.baseDir, new LinkOption[0])) break block18;
                    stream = Files.newDirectoryStream(this.baseDir);
                    try {
                        for (Path p : stream) {
                            String ext;
                            if (Files.isDirectory(p, new LinkOption[0]) || !(ext = PlaylistManager.getExtension(fileName = p.getFileName().toString()).orElse("").toLowerCase(Locale.ROOT)).equals("ogg")) continue;
                            String nameNoExt = fileName.substring(0, fileName.length() - ext.length() - 1);
                            boolean playable = ext.equals("ogg");
                            String key = PlaylistManager.normalizeName(nameNoExt);
                            this.tracks.put(key, new TrackInfo(nameNoExt, p, playable, ext));
                        }
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Error scanning tracks: {}", (Object)e.getMessage());
                }
            }
            try {
                if (!Files.exists(this.playlistsDir, new LinkOption[0]) || !Files.isDirectory(this.playlistsDir, new LinkOption[0])) break block19;
                stream = Files.newDirectoryStream(this.playlistsDir, "*.txt");
                try {
                    for (Path p : stream) {
                        fileName = p.getFileName().toString();
                        String nameNoExt = fileName.substring(0, fileName.length() - 4);
                        String key = PlaylistManager.normalizeName(nameNoExt);
                        List<String> items = this.readPlaylistFile(p);
                        this.playlists.put(key, items);
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error scanning playlists: {}", (Object)e.getMessage());
            }
        }
        LOGGER.info("Scan complete: {} tracks ({} playable), {} playlists", new Object[]{this.tracks.size(), this.tracks.values().stream().filter(t -> t.playable).count(), this.playlists.size()});
    }

    public Map<String, TrackInfo> getTracks() {
        return Collections.unmodifiableMap(this.tracks);
    }

    public Map<String, List<String>> getPlaylists() {
        return Collections.unmodifiableMap(this.playlists);
    }

    public Path getPlayableTrackPath(String nameRaw) {
        String key = PlaylistManager.normalizeName(nameRaw);
        TrackInfo info = this.tracks.get(key);
        if (info != null && info.playable) {
            return info.path;
        }
        return null;
    }

    public boolean isRecognizedButUnsupported(String nameRaw) {
        String key = PlaylistManager.normalizeName(nameRaw);
        TrackInfo info = this.tracks.get(key);
        return info != null && !info.playable;
    }

    private List<String> readPlaylistFile(Path file) {
        try {
            List<String> lines = Files.readAllLines(file);
            return lines.stream().map(String::trim).filter(s -> !s.isEmpty() && !s.startsWith("#")).map(PlaylistManager::normalizeName).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.warn("Failed reading playlist {}: {}", (Object)file.getFileName(), (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public static String normalizeName(String s) {
        return s.toLowerCase(Locale.ROOT).trim();
    }

    private static Optional<String> getExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx >= 0 && idx < fileName.length() - 1) {
            return Optional.of(fileName.substring(idx + 1));
        }
        return Optional.empty();
    }

    public static class TrackInfo {
        public final String displayName;
        public final Path path;
        public final boolean playable;
        public final String extension;

        public TrackInfo(String displayName, Path path, boolean playable, String extension) {
            this.displayName = displayName;
            this.path = path;
            this.playable = playable;
            this.extension = extension;
        }
    }
}

