/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardin.custommusicplus.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBVorbis;

public class OggDecoder {
    public static OggData decode(Path oggPath) throws IOException {
        byte[] bytes = Files.readAllBytes(oggPath);
        ByteBuffer dataBuffer = BufferUtils.createByteBuffer((int)bytes.length);
        dataBuffer.put(bytes);
        dataBuffer.flip();
        IntBuffer channelsBuf = BufferUtils.createIntBuffer((int)1);
        IntBuffer sampleRateBuf = BufferUtils.createIntBuffer((int)1);
        ShortBuffer pcm = STBVorbis.stb_vorbis_decode_memory((ByteBuffer)dataBuffer, (IntBuffer)channelsBuf, (IntBuffer)sampleRateBuf);
        if (pcm == null) {
            throw new IOException("stb_vorbis_decode_memory failed for: " + String.valueOf(oggPath));
        }
        int channels = channelsBuf.get(0);
        int sampleRate = sampleRateBuf.get(0);
        int format = channels == 1 ? 4353 : 4355;
        return new OggData(pcm, format, sampleRate);
    }

    public static class OggData {
        public final ShortBuffer pcm;
        public final int alFormat;
        public final int sampleRate;

        public OggData(ShortBuffer pcm, int alFormat, int sampleRate) {
            this.pcm = pcm;
            this.alFormat = alFormat;
            this.sampleRate = sampleRate;
        }
    }
}

