/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardin.custommusicplus;

import com.hindustani_gamer_fardin.custommusicplus.audio.AudioPlayer;
import com.hindustani_gamer_fardin.custommusicplus.playlist.PlaylistManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMusicPlusClient
implements ClientModInitializer {
    public static final String MOD_ID = "custommusicplus";
    public static final String MOD_NAME = "CustomMusic+";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CustomMusic+");
    private PlaylistManager playlistManager;
    private AudioPlayer audioPlayer;
    private final Deque<String> playbackQueue = new ArrayDeque<String>();
    private boolean initialized = false;

    public void onInitializeClient() {
        LOGGER.info("{} initializing (client)", (Object)MOD_NAME);
        class_310 client = class_310.method_1551();
        Path runDir = client.field_1697.toPath();
        this.playlistManager = new PlaylistManager(runDir.resolve("config").resolve("custommusic"));
        this.playlistManager.ensureDirectories();
        this.playlistManager.scan();
        this.audioPlayer = new AudioPlayer();
        this.registerClientCommands();
        this.registerTickers();
        this.registerShutdownCleanup();
        this.initialized = true;
        LOGGER.info("{} initialized successfully.", (Object)MOD_NAME);
    }

    private void registerClientCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"CustomMusic").then(ClientCommandManager.literal((String)"play").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String name = StringArgumentType.getString((CommandContext)ctx, (String)"name").trim();
                this.doPlay(name);
                return 1;
            })))).then(ClientCommandManager.literal((String)"list").executes(ctx -> {
                this.doList();
                return 1;
            }))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
                this.doHelp();
                return 1;
            }))).then(ClientCommandManager.literal((String)"stop").executes(ctx -> {
                this.doStop();
                return 1;
            }))).then(ClientCommandManager.literal((String)"reload").executes(ctx -> {
                this.doReload();
                return 1;
            }))).then(ClientCommandManager.literal((String)"pause").executes(ctx -> {
                this.doPause();
                return 1;
            }))).then(ClientCommandManager.literal((String)"resume").executes(ctx -> {
                this.doResume();
                return 1;
            }))).then(ClientCommandManager.literal((String)"search").then(ClientCommandManager.argument((String)"keyword", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String keyword = StringArgumentType.getString((CommandContext)ctx, (String)"keyword").trim();
                this.doSearch(keyword);
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"custommusic").redirect(dispatcher.getRoot().getChild("CustomMusic")));
        });
    }

    private void registerTickers() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!this.initialized || this.audioPlayer == null) {
                return;
            }
            this.audioPlayer.update();
            if (this.audioPlayer.isStopped() && !this.playbackQueue.isEmpty()) {
                String nextTrack = this.playbackQueue.pollFirst();
                Path path = this.playlistManager.getPlayableTrackPath(nextTrack);
                if (path != null) {
                    boolean ok = this.audioPlayer.play(path);
                    if (ok) {
                        this.sendChat("\u25b6 Playing: " + nextTrack);
                    } else {
                        this.sendChat("\u2716 Failed to play: " + nextTrack);
                    }
                } else {
                    this.sendChat("\u26a0 Track not found or unsupported: " + nextTrack);
                }
            }
        });
    }

    private void registerShutdownCleanup() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            try {
                if (this.audioPlayer != null) {
                    this.audioPlayer.cleanup();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error during audio cleanup: {}", (Object)e.getMessage());
            }
        });
    }

    private void doPlay(String nameRaw) {
        String name = PlaylistManager.normalizeName(nameRaw);
        if (this.playlistManager.getPlaylists().containsKey(name)) {
            List<String> items = this.playlistManager.getPlaylists().get(name);
            if (items.isEmpty()) {
                this.sendChat("\u26a0 Playlist is empty: " + nameRaw);
                return;
            }
            this.playbackQueue.clear();
            ArrayList<String> queueItems = new ArrayList<String>();
            for (String trackName : items) {
                queueItems.add(trackName);
            }
            this.playbackQueue.addAll(queueItems);
            this.sendChat("\ud83d\udcc2 Playlist queued: " + nameRaw + " (" + queueItems.size() + " tracks)");
            if (!this.playbackQueue.isEmpty()) {
                String first = this.playbackQueue.pollFirst();
                Path path = this.playlistManager.getPlayableTrackPath(first);
                if (path != null) {
                    boolean ok = this.audioPlayer.play(path);
                    if (ok) {
                        this.sendChat("\u25b6 Playing: " + first);
                    } else {
                        this.sendChat("\u2716 Failed to play: " + first);
                    }
                } else {
                    this.sendChat("\u26a0 Track not found or unsupported: " + first);
                }
            }
            return;
        }
        Path path = this.playlistManager.getPlayableTrackPath(name);
        if (path != null) {
            this.playbackQueue.clear();
            boolean ok = this.audioPlayer.play(path);
            if (ok) {
                this.sendChat("\u25b6 Playing: " + nameRaw);
            } else {
                this.sendChat("\u2716 Failed to play: " + nameRaw);
            }
            return;
        }
        if (this.playlistManager.isRecognizedButUnsupported(name)) {
            this.sendChat("\u26a0 Recognized but unsupported format (mp3 currently not playable): " + nameRaw);
            return;
        }
        this.sendChat("\u274c Not found: " + nameRaw + " (no matching track or playlist)");
    }

    private void doList() {
        Map<String, PlaylistManager.TrackInfo> tracks = this.playlistManager.getTracks();
        Map<String, List<String>> playlists = this.playlistManager.getPlaylists();
        StringBuilder sb = new StringBuilder();
        sb.append("\ud83c\udfb5 Available Tracks:\n");
        if (tracks.isEmpty()) {
            sb.append(" - (none)\n");
        } else {
            tracks.values().stream().filter(t -> t.playable).map(t -> " - " + t.displayName).sorted().forEach(line -> sb.append((String)line).append("\n"));
        }
        sb.append("\n\u26a0 Recognized (not playable yet):\n");
        tracks.values().stream().filter(t -> !t.playable).map(t -> " - " + t.displayName + " [" + t.extension + "]").sorted().forEach(line -> sb.append((String)line).append("\n"));
        sb.append("\n\ud83d\udcc2 Available Playlists:\n");
        if (playlists.isEmpty()) {
            sb.append(" - (none)\n");
        } else {
            playlists.keySet().stream().sorted().map(p -> " - " + p).forEach(line -> sb.append((String)line).append("\n"));
        }
        this.sendChat(sb.toString().trim());
    }

    private void doHelp() {
        String help = "\ud83c\udfb6 CustomMusic+ Commands:\n /CustomMusic play <track|playlist>  \u2192 Play a track or playlist\n /CustomMusic pause                  \u2192 Pause current music\n /CustomMusic resume                 \u2192 Resume paused music\n /CustomMusic stop                   \u2192 Stop current music and clear queue\n /CustomMusic list                   \u2192 List all available tracks/playlists\n /CustomMusic search <keyword>       \u2192 Search for tracks containing keyword\n /CustomMusic reload                 \u2192 Reload all tracks and playlists\n /CustomMusic help                   \u2192 Show this help menu\n\nFolder: config/custommusic/\n- .ogg files play natively\n- .mp3 recognized (not yet playable)\n- playlists/*.txt contain track names (one per line)\n";
        this.sendChat(help.trim());
    }

    private void doStop() {
        if (this.audioPlayer != null) {
            this.audioPlayer.stop();
        }
        this.playbackQueue.clear();
        this.sendChat("\u23f9 Stopped and cleared queue.");
    }

    private void doReload() {
        this.playlistManager.scan();
        this.sendChat("\ud83d\udd01 Reloaded tracks and playlists.");
    }

    private void doPause() {
        if (this.audioPlayer != null) {
            this.audioPlayer.pause();
            this.sendChat("\u23f8 Music paused.");
        } else {
            this.sendChat("\u274c No music is currently playing.");
        }
    }

    private void doResume() {
        if (this.audioPlayer != null) {
            this.audioPlayer.resume();
            this.sendChat("\u25b6 Music resumed.");
        } else {
            this.sendChat("\u274c No music to resume.");
        }
    }

    private void doSearch(String keyword) {
        if (this.playlistManager == null) {
            this.sendChat("\u274c Playlist manager not initialized.");
            return;
        }
        Map<String, PlaylistManager.TrackInfo> tracks = this.playlistManager.getTracks();
        Map<String, List<String>> playlists = this.playlistManager.getPlaylists();
        ArrayList<String> matchingTracks = new ArrayList<String>();
        ArrayList<String> matchingPlaylists = new ArrayList<String>();
        String lowerKeyword = keyword.toLowerCase();
        for (String trackName : tracks.keySet()) {
            if (!trackName.toLowerCase().contains(lowerKeyword)) continue;
            matchingTracks.add(trackName);
        }
        for (String playlistName : playlists.keySet()) {
            if (!playlistName.toLowerCase().contains(lowerKeyword)) continue;
            matchingPlaylists.add(playlistName);
        }
        if (matchingTracks.isEmpty() && matchingPlaylists.isEmpty()) {
            this.sendChat("\ud83d\udd0d No tracks or playlists found containing '" + keyword + "'");
            return;
        }
        StringBuilder result = new StringBuilder("\ud83d\udd0d Search results for '" + keyword + "':\n");
        if (!matchingTracks.isEmpty()) {
            result.append("\ud83d\udcc0 Tracks:\n");
            for (String track : matchingTracks) {
                result.append("  \u2022 ").append(track).append("\n");
            }
        }
        if (!matchingPlaylists.isEmpty()) {
            result.append("\ud83d\udccb Playlists:\n");
            for (String playlist : matchingPlaylists) {
                result.append("  \u2022 ").append(playlist).append("\n");
            }
        }
        this.sendChat(result.toString().trim());
    }

    private void sendChat(String message) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353(class_2561.method_30163((String)message), false);
        } else {
            LOGGER.info(message);
        }
    }
}

