/*
 * Decompiled with CFR 0.152.
 */
package net.LunaticPup.LunaticsCreateAdditions.fluid;

import net.LunaticPup.LunaticsCreateAdditions.LunaticsCreateAddtions;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"lunaticscreateadditions");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"lunaticscreateadditions");
    public static final DeferredRegister<Item> BUCKETS = DeferredRegister.createItems((String)"lunaticscreateadditions");
    public static final DeferredRegister<Block> SOURCEBLOCKS = DeferredRegister.createBlocks((String)"lunaticscreateadditions");
    public static final DeferredHolder<FluidType, FluidType> SEED_OIL_TYPE = FLUID_TYPES.register("seed_oil", () -> new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<Fluid, FlowingFluid> SEED_OIL_SOURCE = FLUIDS.register("seed_oil_still", () -> new BaseFlowingFluid.Source(ModFluids.liquidProperties()));
    public static final DeferredHolder<Fluid, FlowingFluid> SEED_OIL_FLOWING = FLUIDS.register("seed_oil_flow", () -> new BaseFlowingFluid.Flowing(ModFluids.liquidProperties()));
    public static final DeferredHolder<Item, BucketItem> SEED_OIL_BUCKET = BUCKETS.register("seed_oil_bucket", () -> new BucketItem((Fluid)SEED_OIL_SOURCE.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final DeferredHolder<Block, LiquidBlock> SEED_OIL_BLOCK = SOURCEBLOCKS.register("seed_oil_block", () -> new LiquidBlock((FlowingFluid)SEED_OIL_SOURCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    private static final IClientFluidTypeExtensions liquidExt = new IClientFluidTypeExtensions(){

        public ResourceLocation getStillTexture() {
            return LunaticsCreateAddtions.rl("block/seed_oil_still");
        }

        public ResourceLocation getFlowingTexture() {
            return LunaticsCreateAddtions.rl("block/seed_oil_flow");
        }

        public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
            return LunaticsCreateAddtions.rl("textures/misc/seed_oil_overlay.png");
        }
    };

    public static void register(IEventBus modbus) {
        FLUID_TYPES.register(modbus);
        FLUIDS.register(modbus);
        BUCKETS.register(modbus);
        SOURCEBLOCKS.register(modbus);
        modbus.addListener(ModFluids::clientExt);
    }

    private static void clientExt(RegisterClientExtensionsEvent event) {
        event.registerFluidType(liquidExt, new FluidType[]{(FluidType)SEED_OIL_TYPE.get()});
    }

    private static BaseFlowingFluid.Properties liquidProperties() {
        return new BaseFlowingFluid.Properties(SEED_OIL_TYPE, SEED_OIL_SOURCE, SEED_OIL_FLOWING).bucket(SEED_OIL_BUCKET).block(SEED_OIL_BLOCK);
    }
}

