package com.herobrinemod.herobrine;

import com.herobrinemod.herobrine.blocks.BlockList;
import com.herobrinemod.herobrine.entities.*;
import com.herobrinemod.herobrine.items.ItemList;
import com.herobrinemod.herobrine.savedata.ConfigHandler;
import com.herobrinemod.herobrine.savedata.SaveDataHandler;
import com.herobrinemod.herobrine.sounds.SoundList;
import com.herobrinemod.herobrine.worldgen.BiomeKeyList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1802;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_6908;
import net.minecraft.class_7706;

import static net.minecraft.class_7923.*;

public class HerobrineMod implements ModInitializer {
    // Public String reference for mod id
    public static final String MODID = "herobrine";

    @Override // "Main" method
    public void onInitialize() {
        ConfigHandler.registerHerobrineConfig("herobrine.json");
        registerCallbacks();
        registerSounds();
        registerBlocks();
        registerItems();
        registerEntityAttributes();
        registerItemGroups();
        registerEntitySpawns();
        registerSurvivorSkins();
    }

    // Register sounds
    private void registerSounds() {
        class_2378.method_10230(field_41172, SoundList.MUSIC_DISC_DOG_IDENTIFIER, SoundList.MUSIC_DISC_DOG);
        class_2378.method_10230(field_41172, SoundList.HEROBRINE_ALTAR_CURSED_IDENTIFIER, SoundList.HEROBRINE_ALTAR_CURSED);
        class_2378.method_10230(field_41172, SoundList.HEROBRINE_ALTAR_PURIFIED_IDENTIFIER, SoundList.HEROBRINE_ALTAR_PURIFIED);

    }

    // Register blocks
    private void registerBlocks() {
        class_2378.method_10230(field_41175, class_2960.method_43902(MODID, "herobrine_altar"), BlockList.HEROBRINE_ALTAR_BLOCK);
        class_2378.method_10230(field_41175, class_2960.method_43902(MODID, "cursed_diamond_block"), BlockList.CURSED_DIAMOND_BLOCK);
        class_2378.method_10230(field_41175, class_2960.method_43902(MODID, "purified_diamond_block"), BlockList.PURIFIED_DIAMOND_BLOCK);
        class_2378.method_10230(field_41175, class_2960.method_43902(MODID, "herobrine_statue"), BlockList.HEROBRINE_STATUE_BLOCK);
    }

    // Register items
    private void registerItems() {
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "herobrine_statue"), ItemList.HEROBRINE_STATUE);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "herobrine_altar"), ItemList.HEROBRINE_ALTAR);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_block"), ItemList.CURSED_DIAMOND_BLOCK);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "purified_diamond_block"), ItemList.PURIFIED_DIAMOND_BLOCK);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "bedrock_sword"), ItemList.BEDROCK_SWORD);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_sword"), ItemList.CURSED_DIAMOND_SWORD);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_shovel"), ItemList.CURSED_DIAMOND_SHOVEL);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_pickaxe"), ItemList.CURSED_DIAMOND_PICKAXE);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_axe"), ItemList.CURSED_DIAMOND_AXE);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_hoe"), ItemList.CURSED_DIAMOND_HOE);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_helmet"), ItemList.CURSED_DIAMOND_HELMET);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_chestplate"), ItemList.CURSED_DIAMOND_CHESTPLATE);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_leggings"), ItemList.CURSED_DIAMOND_LEGGINGS);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond_boots"), ItemList.CURSED_DIAMOND_BOOTS);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "holy_water"), ItemList.HOLY_WATER);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "unholy_water"), ItemList.UNHOLY_WATER);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_dust"), ItemList.CURSED_DUST);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "cursed_diamond"), ItemList.CURSED_DIAMOND);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "purified_diamond"), ItemList.PURIFIED_DIAMOND);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "music_disc_dog"), ItemList.MUSIC_DISC_DOG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "herobrine_warrior_spawn_egg"), ItemList.HEROBRINE_WARRIOR_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "herobrine_spy_spawn_egg"), ItemList.HEROBRINE_SPY_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "herobrine_mage_spawn_egg"), ItemList.HEROBRINE_MAGE_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "herobrine_builder_spawn_egg"), ItemList.HEROBRINE_BUILDER_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "herobrine_stalker_spawn_egg"), ItemList.HEROBRINE_STALKER_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_pig_spawn_egg"), ItemList.INFECTED_PIG_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_cow_spawn_egg"), ItemList.INFECTED_COW_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_villager_spawn_egg"), ItemList.INFECTED_VILLAGER_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_chicken_spawn_egg"), ItemList.INFECTED_CHICKEN_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_sheep_spawn_egg"), ItemList.INFECTED_SHEEP_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_bat_spawn_egg"), ItemList.INFECTED_BAT_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_wolf_spawn_egg"), ItemList.INFECTED_WOLF_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_mooshroom_spawn_egg"), ItemList.INFECTED_MOOSHROOM_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_donkey_spawn_egg"), ItemList.INFECTED_DONKEY_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_horse_spawn_egg"), ItemList.INFECTED_HORSE_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_llama_spawn_egg"), ItemList.INFECTED_LLAMA_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_rabbit_spawn_egg"), ItemList.INFECTED_RABBIT_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "survivor_spawn_egg"), ItemList.SURVIVOR_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_axolotl_spawn_egg"), ItemList.INFECTED_AXOLOTL_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_camel_spawn_egg"), ItemList.INFECTED_CAMEL_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_ocelot_spawn_egg"), ItemList.INFECTED_OCELOT_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_43902(MODID, "infected_fox_spawn_egg"), ItemList.INFECTED_FOX_SPAWN_EGG);
    }

    // Register entity attributes
    private void registerEntityAttributes() {
        FabricDefaultAttributeRegistry.register(EntityTypeList.HEROBRINE_WARRIOR, HerobrineWarriorEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.HEROBRINE_SPY, HerobrineSpyEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.HEROBRINE_MAGE, HerobrineMageEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.FAKE_HEROBRINE_MAGE, FakeHerobrineMageEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.HEROBRINE_BUILDER, HerobrineBuilderEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.HEROBRINE_STALKER, HerobrineStalkerEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_PIG, InfectedPigEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_COW, InfectedCowEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_VILLAGER, InfectedVillagerEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_CHICKEN, InfectedChickenEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_SHEEP, InfectedSheepEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_BAT, InfectedBatEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_WOLF, InfectedWolfEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_MOOSHROOM, InfectedMooshroomEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_DONKEY, InfectedDonkeyEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_HORSE, InfectedHorseEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_LLAMA, InfectedLlamaEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_RABBIT, InfectedRabbitEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.SURVIVOR, SurvivorEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_AXOLOTL, InfectedAxolotlEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_CAMEL, InfectedCamelEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_OCELOT, InfectedOcelotEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.INFECTED_FOX, InfectedFoxEntity.registerAttributes());
    }

    // Register creative tabs and add items to them
    private void registerItemGroups() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(content -> content.addAfter(class_1802.field_8477, ItemList.CURSED_DIAMOND));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(content -> content.addAfter(class_1802.field_8183, ItemList.CURSED_DUST));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(content -> content.addAfter(ItemList.CURSED_DIAMOND, ItemList.PURIFIED_DIAMOND));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(class_1802.field_8285, ItemList.CURSED_DIAMOND_HELMET));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_HELMET, ItemList.CURSED_DIAMOND_CHESTPLATE));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_CHESTPLATE, ItemList.CURSED_DIAMOND_LEGGINGS));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_LEGGINGS, ItemList.CURSED_DIAMOND_BOOTS));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(class_1802.field_22022, ItemList.CURSED_DIAMOND_SWORD));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_SWORD, ItemList.BEDROCK_SWORD));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> content.addAfter(class_1802.field_22026, ItemList.CURSED_DIAMOND_SHOVEL));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(class_1802.field_22025, ItemList.CURSED_DIAMOND_AXE));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_SHOVEL, ItemList.CURSED_DIAMOND_PICKAXE));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_PICKAXE, ItemList.CURSED_DIAMOND_AXE));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_AXE, ItemList.CURSED_DIAMOND_HOE));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> content.addAfter(class_1802.field_8075, ItemList.MUSIC_DISC_DOG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(class_1802.field_8803, ItemList.HOLY_WATER));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> content.addAfter(ItemList.HOLY_WATER, ItemList.UNHOLY_WATER));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register(content -> content.addAfter(class_1802.field_8603, ItemList.CURSED_DIAMOND_BLOCK));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register(content -> content.addAfter(ItemList.CURSED_DIAMOND_BLOCK, ItemList.PURIFIED_DIAMOND_BLOCK));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(content -> content.addAfter(class_1802.field_8657, ItemList.HEROBRINE_ALTAR));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register(content -> content.addAfter(class_1802.field_8525, ItemList.HEROBRINE_STATUE));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(class_1802.field_8093, ItemList.HEROBRINE_WARRIOR_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.HEROBRINE_WARRIOR_SPAWN_EGG, ItemList.HEROBRINE_MAGE_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.HEROBRINE_MAGE_SPAWN_EGG, ItemList.HEROBRINE_BUILDER_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.HEROBRINE_BUILDER_SPAWN_EGG, ItemList.HEROBRINE_STALKER_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.HEROBRINE_STALKER_SPAWN_EGG, ItemList.HEROBRINE_SPY_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.HEROBRINE_SPY_SPAWN_EGG, ItemList.INFECTED_PIG_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_PIG_SPAWN_EGG, ItemList.INFECTED_COW_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_COW_SPAWN_EGG, ItemList.INFECTED_VILLAGER_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_VILLAGER_SPAWN_EGG, ItemList.INFECTED_CHICKEN_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_CHICKEN_SPAWN_EGG, ItemList.INFECTED_SHEEP_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_SHEEP_SPAWN_EGG, ItemList.INFECTED_BAT_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_BAT_SPAWN_EGG, ItemList.INFECTED_WOLF_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_WOLF_SPAWN_EGG, ItemList.INFECTED_MOOSHROOM_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_MOOSHROOM_SPAWN_EGG, ItemList.INFECTED_DONKEY_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_DONKEY_SPAWN_EGG, ItemList.INFECTED_HORSE_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_HORSE_SPAWN_EGG, ItemList.INFECTED_LLAMA_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_LLAMA_SPAWN_EGG, ItemList.INFECTED_RABBIT_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_RABBIT_SPAWN_EGG, ItemList.INFECTED_AXOLOTL_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_AXOLOTL_SPAWN_EGG, ItemList.INFECTED_CAMEL_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_OCELOT_SPAWN_EGG, ItemList.INFECTED_FOX_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.INFECTED_FOX_SPAWN_EGG, ItemList.SURVIVOR_SPAWN_EGG));
    }

    // Register entity spawning
    private void registerEntitySpawns() {
        BiomeModifications.addSpawn(BiomeSelectors.excludeByKey(class_1972.field_9473), class_1311.field_6302, EntityTypeList.HEROBRINE_WARRIOR, ConfigHandler.getHerobrineConfig().readInt("HerobrineWarriorWeight"), 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.includeByKey(BiomeKeyList.CURSED_FOREST), class_1311.field_6302, EntityTypeList.HEROBRINE_WARRIOR, ConfigHandler.getHerobrineConfig().readInt("HerobrineWarriorWeight") * 2, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.excludeByKey(class_1972.field_9473), class_1311.field_6302, EntityTypeList.HEROBRINE_BUILDER, ConfigHandler.getHerobrineConfig().readInt("HerobrineBuilderWeight"), 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.includeByKey(BiomeKeyList.CURSED_FOREST), class_1311.field_6302, EntityTypeList.HEROBRINE_BUILDER, ConfigHandler.getHerobrineConfig().readInt("HerobrineBuilderWeight") * 2, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.excludeByKey(class_1972.field_9473), class_1311.field_6302, EntityTypeList.HEROBRINE_MAGE, ConfigHandler.getHerobrineConfig().readInt("HerobrineMageWeight"), 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.includeByKey(BiomeKeyList.CURSED_FOREST), class_1311.field_6302, EntityTypeList.HEROBRINE_MAGE, ConfigHandler.getHerobrineConfig().readInt("HerobrineMageWeight") * 2, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.excludeByKey(class_1972.field_9473), class_1311.field_6302, EntityTypeList.HEROBRINE_SPY, ConfigHandler.getHerobrineConfig().readInt("HerobrineSpyWeight"), 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.includeByKey(BiomeKeyList.CURSED_FOREST), class_1311.field_6302, EntityTypeList.HEROBRINE_SPY, ConfigHandler.getHerobrineConfig().readInt("HerobrineSpyWeight") * 2, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.excludeByKey(class_1972.field_9473), class_1311.field_6302, EntityTypeList.HEROBRINE_STALKER, ConfigHandler.getHerobrineConfig().readInt("HerobrineStalkerWeight"), 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.includeByKey(BiomeKeyList.CURSED_FOREST), class_1311.field_6302, EntityTypeList.HEROBRINE_STALKER, ConfigHandler.getHerobrineConfig().readInt("HerobrineStalkerWeight") * 2, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6093), class_1311.field_6302, EntityTypeList.INFECTED_PIG, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 3, 6);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6085), class_1311.field_6302, EntityTypeList.INFECTED_COW, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 2, 4);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36496).or(BiomeSelectors.tag(class_6908.field_36497)).or(BiomeSelectors.tag(class_6908.field_36499)).or(BiomeSelectors.tag(class_6908.field_36498)).or(BiomeSelectors.tag(class_6908.field_36500)), class_1311.field_6302, EntityTypeList.INFECTED_VILLAGER, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6132), class_1311.field_6302, EntityTypeList.INFECTED_CHICKEN, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 4, 8);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6115), class_1311.field_6302, EntityTypeList.INFECTED_SHEEP, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 3, 6);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6108), class_1311.field_6302, EntityTypeList.INFECTED_BAT, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight") * 3, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6055), class_1311.field_6302, EntityTypeList.INFECTED_WOLF, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 4, 4);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6143), class_1311.field_6302, EntityTypeList.INFECTED_MOOSHROOM, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 4, 8);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6067), class_1311.field_6302, EntityTypeList.INFECTED_DONKEY, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 1, 3);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6139), class_1311.field_6302, EntityTypeList.INFECTED_HORSE, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 2, 6);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6074), class_1311.field_6302, EntityTypeList.INFECTED_LLAMA, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 4, 6);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6140), class_1311.field_6302, EntityTypeList.INFECTED_RABBIT, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 2, 3);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_28315), class_1311.field_6302, EntityTypeList.INFECTED_AXOLOTL, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 1, 3);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_6081), class_1311.field_6302, EntityTypeList.INFECTED_OCELOT, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 1, 3);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36496), class_1311.field_6302, EntityTypeList.INFECTED_CAMEL, ConfigHandler.getHerobrineConfig().readInt("InfectedCamelWeight"), 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.spawnsOneOf(class_1299.field_17943), class_1311.field_6302, EntityTypeList.INFECTED_FOX, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 2, 4);
        if(ConfigHandler.getHerobrineConfig().readInt("HerobrineEndSpawnType") > 0) {
            BiomeModifications.addSpawn(BiomeSelectors.foundInTheEnd(), class_1311.field_6302, EntityTypeList.HEROBRINE_SPY, ConfigHandler.getHerobrineConfig().readInt("HerobrineSpyWeight"), 1, 1);
            BiomeModifications.addSpawn(BiomeSelectors.foundInTheEnd(), class_1311.field_6302, EntityTypeList.HEROBRINE_STALKER, ConfigHandler.getHerobrineConfig().readInt("HerobrineStalkerWeight"), 1, 1);
            if(ConfigHandler.getHerobrineConfig().readInt("HerobrineEndSpawnType") == 2) {
                BiomeModifications.addSpawn(BiomeSelectors.foundInTheEnd(), class_1311.field_6302, EntityTypeList.HEROBRINE_WARRIOR, ConfigHandler.getHerobrineConfig().readInt("HerobrineWarriorWeight"), 1, 1);
                BiomeModifications.addSpawn(BiomeSelectors.foundInTheEnd(), class_1311.field_6302, EntityTypeList.HEROBRINE_MAGE, ConfigHandler.getHerobrineConfig().readInt("HerobrineMageWeight"), 1, 1);
                BiomeModifications.addSpawn(BiomeSelectors.foundInTheEnd(), class_1311.field_6302, EntityTypeList.HEROBRINE_BUILDER, ConfigHandler.getHerobrineConfig().readInt("HerobrineBuilderWeight"), 1, 1);
            }
        }
        class_1317.method_20637(EntityTypeList.HEROBRINE_WARRIOR, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, HerobrineEntity::canSpawnStage3);
        class_1317.method_20637(EntityTypeList.HEROBRINE_BUILDER, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, HerobrineEntity::canSpawnStage2);
        class_1317.method_20637(EntityTypeList.HEROBRINE_MAGE, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, HerobrineEntity::canSpawnStage3);
        class_1317.method_20637(EntityTypeList.HEROBRINE_SPY, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, HerobrineEntity::canSpawnPeacefulMode);
        class_1317.method_20637(EntityTypeList.HEROBRINE_STALKER, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, HerobrineEntity::canSpawnPeacefulModeStage1);
        class_1317.method_20637(EntityTypeList.INFECTED_PIG, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_COW, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_VILLAGER, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedVillagerEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_CHICKEN, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_SHEEP, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_BAT, class_1317.class_1319.field_19350, class_2902.class_2903.field_13203, InfectedBatEntity::canBatSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_WOLF, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_MOOSHROOM, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedMooshroomEntity::canMooshroomSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_DONKEY, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_HORSE, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_LLAMA, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_RABBIT, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_AXOLOTL, class_1317.class_1319.field_6318, class_2902.class_2903.field_13200, InfectedAxolotlEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_CAMEL, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedCamelEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_OCELOT, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.INFECTED_FOX, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
    }

    private void registerSurvivorSkins() {
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft", "textures/entity/player/wide/alex.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/ari.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/efe.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/kai.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/makena.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/noor.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/steve.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/sunny.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902("minecraft","textures/entity/player/wide/zuri.png"));
        SurvivorSkinRegistry.addSkin(class_2960.method_43902(MODID, "textures/entity/survivor/amaclean04.png"));
    }

    // Register callbacks. Used to properly load and unload each instance of WorldSaveData
    private void registerCallbacks() {
        ServerLifecycleEvents.SERVER_STARTED.register(SaveDataHandler::handleServerStart);
        ServerLifecycleEvents.SERVER_STOPPED.register(SaveDataHandler::handleServerStop);
    }
}