package com.herobrinemod.herobrine.blocks;

import com.herobrinemod.herobrine.items.ItemList;
import com.herobrinemod.herobrine.items.ItemTagList;
import com.herobrinemod.herobrine.savedata.ConfigHandler;
import com.herobrinemod.herobrine.savedata.SaveDataHandler;
import com.herobrinemod.herobrine.sounds.SoundList;
import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HerobrineAltarBlock extends class_2248 implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 TYPE = class_2758.method_11867("type", 0, 2);
    public static final class_265 SHAPE = class_259.method_17786(class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 8.0D, 16.0D), class_2248.method_9541(0.0D, 9.0D, 0.0D, 1.0D, 15.0D, 1.0D), class_2248.method_9541(15.0D, 9.0D, 0.0D, 16.0D, 15.0D, 1.0D), class_2248.method_9541(15.0D, 9.0D, 15.0D, 16.0D, 15.0D, 16.0D), class_2248.method_9541(0.0D, 9.0D, 15.0D, 1.0D, 15.0D, 16.0D), class_2248.method_9541(0.0D, 15.0D, 0.0D, 2.0D, 16.0D, 2.0D), class_2248.method_9541(14.0D, 15.0D, 0.0D, 16.0D, 16.0D, 2.0D), class_2248.method_9541(14.0D, 15.0D, 14.0D, 16.0D, 16.0D, 16.0D), class_2248.method_9541(0.0D, 15.0D, 14.0D, 2.0D, 16.0D, 16.0D), class_2248.method_9541(0.0D, 8.0D, 0.0D, 2.0D, 9.0D, 2.0D), class_2248.method_9541(14.0D, 8.0D, 0.0D, 16.0D, 9.0D, 2.0D), class_2248.method_9541(14.0D, 8.0D, 14.0D, 16.0D, 9.0D, 16.0D), class_2248.method_9541(0.0D, 8.0D, 14.0D, 2.0D, 9.0D, 16.0D));

    public HerobrineAltarBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(WATERLOGGED, false).method_11657(TYPE, 0));
    }

    @Override
    protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> builder) {
        builder.method_11667(WATERLOGGED);
        builder.method_11667(TYPE);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public void method_9496(@NotNull class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        switch (state.method_11654(TYPE)) {
            case 1 -> {
                world.method_8406(class_2398.field_11214, pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 0.2, pos.method_10264() + 0.25, pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 0.2, 0.0, 0.0, 0.0);
                world.method_8486(pos.method_10263(), pos.method_10264(), pos.method_10260(), SoundList.HEROBRINE_ALTAR_CURSED, class_3419.field_15245, 1.0f, random.method_43057() * 0.6f + 0.6f, false);
            }
            case 2 -> world.method_8486(pos.method_10263(), pos.method_10264(), pos.method_10260(), SoundList.HEROBRINE_ALTAR_PURIFIED, class_3419.field_15245, 1.0f, 1.25f, false);
        }
    }

    @Override
    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    @Override
    public class_3610 method_9545(@NotNull class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean method_10311(class_1936 world, class_2338 pos, @NotNull class_2680 state, class_3610 fluidState) {
        return class_3737.super.method_10311(world, pos, state, fluidState);
    }

    public boolean method_10310(class_1922 world, class_2338 pos, @NotNull class_2680 state, class_3611 fluid) {
        return class_3737.super.method_10310(world, pos, state, fluid);
    }

    @Override
    public class_2680 method_9559(@NotNull class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private boolean canActivate(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return state.method_11654(TYPE) == 0 && (!ConfigHandler.getHerobrineConfig().readBoolean("AltarRequiresShrine") || world.method_8320(new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260())) == class_2246.field_10515.method_9564() && world.method_8320(new class_2338(pos.method_10263() - 1, pos.method_10264() - 1, pos.method_10260())) == class_2246.field_10205.method_9564() && world.method_8320(new class_2338(pos.method_10263() + 1, pos.method_10264() - 1, pos.method_10260())) == class_2246.field_10205.method_9564() && world.method_8320(new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260() - 1)) == class_2246.field_10205.method_9564() && world.method_8320(new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260() + 1)) == class_2246.field_10205.method_9564() && world.method_8320(new class_2338(pos.method_10263() - 1, pos.method_10264(), pos.method_10260())) == class_2246.field_10523.method_9564() && world.method_8320(new class_2338(pos.method_10263() + 1, pos.method_10264(), pos.method_10260())) == class_2246.field_10523.method_9564() && world.method_8320(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260() + 1)) == class_2246.field_10523.method_9564() && world.method_8320(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260() - 1)) == class_2246.field_10523.method_9564() && world.method_8320(new class_2338(pos.method_10263() - 1, pos.method_10264() - 1, pos.method_10260() - 1)) == class_2246.field_10164.method_9564() && world.method_8320(new class_2338(pos.method_10263() + 1, pos.method_10264() - 1, pos.method_10260() - 1)) == class_2246.field_10164.method_9564() && world.method_8320(new class_2338(pos.method_10263() - 1, pos.method_10264() - 1, pos.method_10260() + 1)) == class_2246.field_10164.method_9564() && world.method_8320(new class_2338(pos.method_10263() + 1, pos.method_10264() - 1, pos.method_10260() + 1)) == class_2246.field_10164.method_9564());
    }

    @Nullable
    @Override
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_2680 blockState = ctx.method_8045().method_8320(blockPos);
        return this.method_9564().method_11657(WATERLOGGED, blockState.method_26227().method_15772() == class_3612.field_15910);
    }

    static int getLightValue(@NotNull class_2680 state) {
        return switch (state.method_11654(TYPE)) {
            case 1 -> 8;
            case 2 -> 15;
            default -> 0;
        };
    }

    @Override
    public class_1269 method_9534(@NotNull class_2680 state, class_1937 world, class_2338 pos, @NotNull class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(ItemTagList.ACTIVATES_HEROBRINE_ALTAR) && canActivate(world, pos, state)) {
            if(itemStack.method_31574(ItemList.CURSED_DIAMOND)) {
                world.method_8501(pos, this.method_9564().method_11657(TYPE, 1));
                if(!world.field_9236) {
                    if(!SaveDataHandler.getHerobrineSaveData().readBoolean("herobrineSummoned")) {
                        if(ConfigHandler.getHerobrineConfig().readBoolean("GlobalHerobrineMessages")) {
                            for(class_1657 p: world.method_18456()) {
                                p.method_7353(class_2561.method_43471("herobrine.summon"), false);
                            }
                        } else {
                            player.method_7353(class_2561.method_43471("herobrine.summon"), false);
                        }
                        class_1538 lightningentity = class_1299.field_6112.method_5883(world);
                        assert lightningentity != null;
                        lightningentity.method_23327(pos.method_10263(), pos.method_10264(), pos.method_10260());
                        world.method_8649(lightningentity);
                        SaveDataHandler.getHerobrineSaveData().writeBoolean("herobrineSummoned", true);
                    }
                }

            } else {
                world.method_8501(pos, this.method_9564().method_11657(TYPE, 2));
                if(!world.field_9236) {
                    if(SaveDataHandler.getHerobrineSaveData().readBoolean("herobrineSummoned")) {
                        if(ConfigHandler.getHerobrineConfig().readBoolean("GlobalHerobrineMessages")) {
                            for(class_1657 p: world.method_18456()) {
                                p.method_7353(class_2561.method_43471("herobrine.unsummon"), false);
                            }
                        } else {
                            player.method_7353(class_2561.method_43471("herobrine.unsummon"), false);
                        }
                        class_1538 lightningentity = class_1299.field_6112.method_5883(world);
                        assert lightningentity != null;
                        lightningentity.method_23327(pos.method_10263(), pos.method_10264(), pos.method_10260());
                        world.method_8649(lightningentity);
                        SaveDataHandler.getHerobrineSaveData().writeBoolean("herobrineSummoned", false);
                        SaveDataHandler.getHerobrineSaveData().writeInt("stage", 0);
                        SaveDataHandler.getHerobrineSaveData().writeInt("stageTime", 0);
                    }
                }
            }

            world.method_8486(pos.method_10263(), pos.method_10264(), pos.method_10260(), class_3417.field_19197, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.4f + 0.5f, false);
            if(!player.method_7337()) {
                itemStack.method_7934(1);
            }

            if (state.method_11654(WATERLOGGED)) {
                world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
            }
            return class_1269.method_29236(world.field_9236);
        } else {
            switch (state.method_11654(TYPE)) {
                case 1 -> {
                    world.method_8501(pos, this.method_9564().method_11657(TYPE, 0));
                    class_1799 stack = new class_1799(ItemList.CURSED_DIAMOND);
                    if (!player.method_31548().method_7394(stack) || !stack.method_7960()) {
                        class_1542 itemEntity = player.method_7328(stack, false);
                        assert itemEntity != null;
                        itemEntity.method_6975();
                        itemEntity.method_48349(player.method_5667());
                    }
                    return class_1269.method_29236(world.field_9236);
                }
                case 2 -> {
                    world.method_8501(pos, this.method_9564().method_11657(TYPE, 0));
                    class_1799 stack = new class_1799(ItemList.PURIFIED_DIAMOND);
                    if (!player.method_31548().method_7394(stack) || !stack.method_7960()) {
                        class_1542 itemEntity = player.method_7328(stack, false);
                        assert itemEntity != null;
                        itemEntity.method_6975();
                        itemEntity.method_48349(player.method_5667());
                    }
                    return class_1269.method_29236(world.field_9236);
                }
            }
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }
}