package com.herobrinemod.herobrine.blocks;

import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HerobrineStatueBlock extends class_2248 implements class_3737{
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_265 NORTH_SOUTH_TOP = class_259.method_1084(class_2248.method_9541(0, 0, 6, 16, 8, 10), class_2248.method_9541(4, 8, 4, 12, 16, 12));
    public static final class_265 EAST_WEST_TOP = class_259.method_1084(class_2248.method_9541(6, 0, 0, 10, 8, 16), class_2248.method_9541(4, 8, 4, 12, 16, 12));
    public static final class_265 NORTH_SOUTH_BOTTOM = class_259.method_1084(class_2248.method_9541(4, 0, 6, 12, 12, 10), class_2248.method_9541(0, 12, 6, 16, 16, 10));
    public static final class_265 EAST_WEST_BOTTOM = class_259.method_1084(class_2248.method_9541(6, 0, 4, 10, 12, 12), class_2248.method_9541(6, 12, 0, 10, 16, 16));

    public HerobrineStatueBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(WATERLOGGED, false).method_11657(FACING, class_2350.field_11043).method_11657(HALF, class_2756.field_12607));
    }

    @Override
    protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> builder) {
        builder.method_11667(WATERLOGGED);
        builder.method_11667(FACING);
        builder.method_11667(HALF);
    }

    @NotNull
    @Override
    public class_265 method_9530(@NotNull class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if(state.method_11654(HALF) == class_2756.field_12607) {
            if(state.method_11654(FACING) == class_2350.field_11043 || state.method_11654(FACING) == class_2350.field_11035) {
                return NORTH_SOUTH_BOTTOM;
            }

            return EAST_WEST_BOTTOM;
        }
        if(state.method_11654(FACING) == class_2350.field_11043 || state.method_11654(FACING) == class_2350.field_11035) {
            return NORTH_SOUTH_TOP;
        }

        return EAST_WEST_TOP;
    }


    @Override
    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    @Override
    public class_3610 method_9545(@NotNull class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean method_10311(class_1936 world, class_2338 pos, @NotNull class_2680 state, class_3610 fluidState) {
        return class_3737.super.method_10311(world, pos, state, fluidState);
    }

    public boolean method_10310(class_1922 world, class_2338 pos, @NotNull class_2680 state, class_3611 fluid) {
        return class_3737.super.method_10310(world, pos, state, fluid);
    }

    @Nullable
    @Override
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        if (ctx.method_8037().method_10264() < ctx.method_8045().method_31600() - 1 && ctx.method_8045().method_8320(ctx.method_8037().method_10084()).method_26166(ctx)) {
            return this.method_9564().method_11657(WATERLOGGED, ctx.method_8045().method_8320(ctx.method_8037()).method_26227().method_15772() == class_3612.field_15910).method_11657(FACING, ctx.method_8042().method_10153());
        }

        return null;
    }

    @Override
    public class_2680 method_9559(@NotNull class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        if (!(direction.method_10166() != class_2350.class_2351.field_11052 || state.method_11654(HALF) == class_2756.field_12607 != (direction == class_2350.field_11036) || neighborState.method_27852(this) && neighborState.method_11654(HALF) != state.method_11654(HALF))) {
            return class_2246.field_10124.method_9564();
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void method_9567(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2338 blockPos = pos.method_10084();
        world.method_8652(blockPos, withWaterloggedState(world, blockPos, this.method_9564().method_11657(HALF, class_2756.field_12609).method_11657(FACING, state.method_11654(FACING))), class_2248.field_31036);
    }

    @Override
    public boolean method_9558(@NotNull class_2680 state, class_4538 world, class_2338 pos) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            class_2680 blockState = world.method_8320(pos.method_10074());
            return blockState.method_27852(this) && blockState.method_11654(HALF) == class_2756.field_12607;
        }

        return super.method_9558(state, world, pos);
    }

    public static class_2680 withWaterloggedState(class_4538 world, class_2338 pos, @NotNull class_2680 state) {
        if (state.method_28498(class_2741.field_12508)) {
            return state.method_11657(class_2741.field_12508, world.method_22351(pos));
        }

        return state;
    }

    @Override
    public void method_9576(@NotNull class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236 && player.method_7337() || !player.method_6047().method_7951(state)) {
            class_2320.method_30036(world, pos, state, player);
        }
        super.method_9576(world, pos, state, player);
    }
}