package com.herobrinemod.herobrine.client.entities.models;

import com.google.common.collect.ImmutableList;
import com.herobrinemod.herobrine.entities.InfectedFoxEntity;
import net.minecraft.class_3532;
import net.minecraft.class_4592;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_6230;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import org.jetbrains.annotations.NotNull;

public class InfectedFoxEntityModel extends class_4592<InfectedFoxEntity> {

    public final class_630 head;
    private final class_630 body;
    private final class_630 rightHindLeg;
    private final class_630 leftHindLeg;
    private final class_630 rightFrontLeg;
    private final class_630 leftFrontLeg;
    private final class_630 tail;
    private float legPitchModifier;

    public InfectedFoxEntityModel(class_630 root) {
        super(true, 8.0F, 3.35F);
        this.head = root.method_32086(class_6230.field_32606);
        this.body = root.method_32086(class_6230.field_32608);
        this.rightHindLeg = root.method_32086(class_6230.field_32634);
        this.leftHindLeg = root.method_32086(class_6230.field_32633);
        this.rightFrontLeg = root.method_32086(class_6230.field_32636);
        this.leftFrontLeg = root.method_32086(class_6230.field_32635);
        this.tail = this.body.method_32086(class_6230.field_32599);
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData2 = modelPartData.method_32117(
                class_6230.field_32606, class_5606.method_32108().method_32101(1, 5).method_32097(-3.0F, -2.0F, -5.0F, 8.0F, 6.0F, 6.0F), class_5603.method_32090(-1.0F, 16.5F, -3.0F)
        );
        modelPartData2.method_32117(class_6230.field_32630, class_5606.method_32108().method_32101(8, 1).method_32097(-3.0F, -4.0F, -4.0F, 2.0F, 2.0F, 1.0F), class_5603.field_27701);
        modelPartData2.method_32117(class_6230.field_32629, class_5606.method_32108().method_32101(15, 1).method_32097(3.0F, -4.0F, -4.0F, 2.0F, 2.0F, 1.0F), class_5603.field_27701);
        modelPartData2.method_32117(class_6230.field_32597, class_5606.method_32108().method_32101(6, 18).method_32097(-1.0F, 2.01F, -8.0F, 4.0F, 2.0F, 3.0F), class_5603.field_27701);
        class_5610 modelPartData3 = modelPartData.method_32117(
                class_6230.field_32608,
                class_5606.method_32108().method_32101(24, 15).method_32097(-3.0F, 3.999F, -3.5F, 6.0F, 11.0F, 6.0F),
                class_5603.method_32091(0.0F, 16.0F, -6.0F, (float) (Math.PI / 2), 0.0F, 0.0F)
        );
        class_5605 dilation = new class_5605(0.001F);
        class_5606 modelPartBuilder = class_5606.method_32108().method_32101(4, 24).method_32098(2.0F, 0.5F, -1.0F, 2.0F, 6.0F, 2.0F, dilation);
        class_5606 modelPartBuilder2 = class_5606.method_32108().method_32101(13, 24).method_32098(2.0F, 0.5F, -1.0F, 2.0F, 6.0F, 2.0F, dilation);
        modelPartData.method_32117(class_6230.field_32634, modelPartBuilder2, class_5603.method_32090(-5.0F, 17.5F, 7.0F));
        modelPartData.method_32117(class_6230.field_32633, modelPartBuilder, class_5603.method_32090(-1.0F, 17.5F, 7.0F));
        modelPartData.method_32117(class_6230.field_32636, modelPartBuilder2, class_5603.method_32090(-5.0F, 17.5F, 0.0F));
        modelPartData.method_32117(class_6230.field_32635, modelPartBuilder, class_5603.method_32090(-1.0F, 17.5F, 0.0F));
        modelPartData3.method_32117(
                class_6230.field_32599,
                class_5606.method_32108().method_32101(30, 0).method_32097(2.0F, 0.0F, -1.0F, 4.0F, 9.0F, 5.0F),
                class_5603.method_32091(-4.0F, 15.0F, -1.0F, -0.05235988F, 0.0F, 0.0F)
        );
        return class_5607.method_32110(modelData, 48, 32);
    }

    public void animateModel(InfectedFoxEntity entity, float f, float g, float h) {
        this.body.field_3654 = (float) (Math.PI / 2);
        this.tail.field_3654 = -0.05235988F;
        this.rightHindLeg.field_3654 = class_3532.method_15362(f * 0.6662F) * 1.4F * g;
        this.leftHindLeg.field_3654 = class_3532.method_15362(f * 0.6662F + (float) Math.PI) * 1.4F * g;
        this.rightFrontLeg.field_3654 = class_3532.method_15362(f * 0.6662F + (float) Math.PI) * 1.4F * g;
        this.leftFrontLeg.field_3654 = class_3532.method_15362(f * 0.6662F) * 1.4F * g;
        this.head.method_2851(-1.0F, 16.5F, -3.0F);
        this.head.field_3675 = 0.0F;
        this.head.field_3674 = entity.getHeadRoll(h);
        this.rightHindLeg.field_3665 = true;
        this.leftHindLeg.field_3665 = true;
        this.rightFrontLeg.field_3665 = true;
        this.leftFrontLeg.field_3665 = true;
        this.body.method_2851(0.0F, 16.0F, -6.0F);
        this.body.field_3674 = 0.0F;
        this.rightHindLeg.method_2851(-5.0F, 17.5F, 7.0F);
        this.leftHindLeg.method_2851(-1.0F, 17.5F, 7.0F);

        if (entity.method_6113()) {
            this.body.field_3674 = (float) (-Math.PI / 2);
            this.body.method_2851(0.0F, 21.0F, -6.0F);
            this.tail.field_3654 = (float) (-Math.PI * 5.0 / 6.0);
            if (this.field_3448) {
                this.tail.field_3654 = -2.1816616F;
                this.body.method_2851(0.0F, 21.0F, -2.0F);
            }

            this.head.method_2851(1.0F, 19.49F, -3.0F);
            this.head.field_3654 = 0.0F;
            this.head.field_3675 = (float) (-Math.PI * 2.0 / 3.0);
            this.head.field_3674 = 0.0F;
            this.rightHindLeg.field_3665 = false;
            this.leftHindLeg.field_3665 = false;
            this.rightFrontLeg.field_3665 = false;
            this.leftFrontLeg.field_3665 = false;
        }
    }

    @Override
    protected Iterable<class_630> method_22946() {
        return ImmutableList.of(this.head);
    }

    @Override
    protected Iterable<class_630> method_22948() {
        return ImmutableList.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg);
    }

    @Override
    public void setAngles(@NotNull InfectedFoxEntity entity, float f, float g, float h, float i, float j) {
        if (!entity.method_6113() && !entity.isWalking() && !entity.method_18276()) {
            this.head.field_3654 = j * (float) (Math.PI / 180.0);
            this.head.field_3675 = i * (float) (Math.PI / 180.0);
        }

        if (entity.method_6113()) {
            this.head.field_3654 = 0.0F;
            this.head.field_3675 = (float) (-Math.PI * 2.0 / 3.0);
            this.head.field_3674 = class_3532.method_15362(h * 0.027F) / 22.0F;
        }

        if (entity.method_18276()) {
            float k = class_3532.method_15362(h) * 0.01F;
            this.body.field_3675 = k;
            this.rightHindLeg.field_3674 = k;
            this.leftHindLeg.field_3674 = k;
            this.rightFrontLeg.field_3674 = k / 2.0F;
            this.leftFrontLeg.field_3674 = k / 2.0F;
        }

        if (entity.isWalking()) {
            this.legPitchModifier += 0.67F;
            this.rightHindLeg.field_3654 = class_3532.method_15362(this.legPitchModifier * 0.4662F) * 0.1F;
            this.leftHindLeg.field_3654 = class_3532.method_15362(this.legPitchModifier * 0.4662F + (float) Math.PI) * 0.1F;
            this.rightFrontLeg.field_3654 = class_3532.method_15362(this.legPitchModifier * 0.4662F + (float) Math.PI) * 0.1F;
            this.leftFrontLeg.field_3654 = class_3532.method_15362(this.legPitchModifier * 0.4662F) * 0.1F;
        }
    }
}
