package com.herobrinemod.herobrine.client.entities.models;

import com.google.common.collect.ImmutableList;
import com.herobrinemod.herobrine.entities.InfectedRabbitEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_6230;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import org.jetbrains.annotations.NotNull;

@Environment(EnvType.CLIENT)
public class InfectedRabbitEntityModel extends class_583<InfectedRabbitEntity> {
    private static final String LEFT_HAUNCH = "left_haunch";
    private static final String RIGHT_HAUNCH = "right_haunch";
    private final class_630 leftHindLeg;
    private final class_630 rightHindLeg;
    private final class_630 leftHaunch;
    private final class_630 rightHaunch;
    private final class_630 body;
    private final class_630 leftFrontLeg;
    private final class_630 rightFrontLeg;
    private final class_630 head;
    private final class_630 rightEar;
    private final class_630 leftEar;
    private final class_630 tail;
    private final class_630 nose;
    private float jumpProgress;

    public InfectedRabbitEntityModel(@NotNull class_630 root) {
        this.leftHindLeg = root.method_32086(class_6230.field_32637);
        this.rightHindLeg = root.method_32086(class_6230.field_32638);
        this.leftHaunch = root.method_32086(LEFT_HAUNCH);
        this.rightHaunch = root.method_32086(RIGHT_HAUNCH);
        this.body = root.method_32086(class_6230.field_32608);
        this.leftFrontLeg = root.method_32086(class_6230.field_32635);
        this.rightFrontLeg = root.method_32086(class_6230.field_32636);
        this.head = root.method_32086(class_6230.field_32606);
        this.rightEar = root.method_32086(class_6230.field_32630);
        this.leftEar = root.method_32086(class_6230.field_32629);
        this.tail = root.method_32086(class_6230.field_32599);
        this.nose = root.method_32086(class_6230.field_32597);
    }

    public static @NotNull class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117(class_6230.field_32637, class_5606.method_32108().method_32101(26, 24).method_32097(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), class_5603.method_32090(3.0f, 17.5f, 3.7f));
        modelPartData.method_32117(class_6230.field_32638, class_5606.method_32108().method_32101(8, 24).method_32097(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), class_5603.method_32090(-3.0f, 17.5f, 3.7f));
        modelPartData.method_32117(LEFT_HAUNCH, class_5606.method_32108().method_32101(30, 15).method_32097(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), class_5603.method_32091(3.0f, 17.5f, 3.7f, -0.34906584f, 0.0f, 0.0f));
        modelPartData.method_32117(RIGHT_HAUNCH, class_5606.method_32108().method_32101(16, 15).method_32097(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), class_5603.method_32091(-3.0f, 17.5f, 3.7f, -0.34906584f, 0.0f, 0.0f));
        modelPartData.method_32117(class_6230.field_32608, class_5606.method_32108().method_32101(0, 0).method_32097(-3.0f, -2.0f, -10.0f, 6.0f, 5.0f, 10.0f), class_5603.method_32091(0.0f, 19.0f, 8.0f, -0.34906584f, 0.0f, 0.0f));
        modelPartData.method_32117(class_6230.field_32635, class_5606.method_32108().method_32101(8, 15).method_32097(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), class_5603.method_32091(3.0f, 17.0f, -1.0f, -0.17453292f, 0.0f, 0.0f));
        modelPartData.method_32117(class_6230.field_32636, class_5606.method_32108().method_32101(0, 15).method_32097(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), class_5603.method_32091(-3.0f, 17.0f, -1.0f, -0.17453292f, 0.0f, 0.0f));
        modelPartData.method_32117(class_6230.field_32606, class_5606.method_32108().method_32101(32, 0).method_32097(-2.5f, -4.0f, -5.0f, 5.0f, 4.0f, 5.0f), class_5603.method_32090(0.0f, 16.0f, -1.0f));
        modelPartData.method_32117(class_6230.field_32630, class_5606.method_32108().method_32101(52, 0).method_32097(-2.5f, -9.0f, -1.0f, 2.0f, 5.0f, 1.0f), class_5603.method_32091(0.0f, 16.0f, -1.0f, 0.0f, -0.2617994f, 0.0f));
        modelPartData.method_32117(class_6230.field_32629, class_5606.method_32108().method_32101(58, 0).method_32097(0.5f, -9.0f, -1.0f, 2.0f, 5.0f, 1.0f), class_5603.method_32091(0.0f, 16.0f, -1.0f, 0.0f, 0.2617994f, 0.0f));
        modelPartData.method_32117(class_6230.field_32599, class_5606.method_32108().method_32101(52, 6).method_32097(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f), class_5603.method_32091(0.0f, 20.0f, 7.0f, -0.3490659f, 0.0f, 0.0f));
        modelPartData.method_32117(class_6230.field_32597, class_5606.method_32108().method_32101(32, 9).method_32097(-0.5f, -2.5f, -5.5f, 1.0f, 1.0f, 1.0f), class_5603.method_32090(0.0f, 16.0f, -1.0f));
        return class_5607.method_32110(modelData, 64, 32);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.field_3448) {
            matrices.method_22903();
            matrices.method_22905(0.56666666f, 0.56666666f, 0.56666666f);
            matrices.method_46416(0.0f, 1.375f, 0.125f);
            ImmutableList.of(this.head, this.leftEar, this.rightEar, this.nose).forEach(part -> part.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha));
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22905(0.4f, 0.4f, 0.4f);
            matrices.method_46416(0.0f, 2.25f, 0.0f);
            ImmutableList.of(this.leftHindLeg, this.rightHindLeg, this.leftHaunch, this.rightHaunch, this.body, this.leftFrontLeg, this.rightFrontLeg, this.tail).forEach(part -> part.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha));
            matrices.method_22909();
        } else {
            matrices.method_22903();
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            matrices.method_46416(0.0f, 1.0f, 0.0f);
            ImmutableList.of(this.leftHindLeg, this.rightHindLeg, this.leftHaunch, this.rightHaunch, this.body, this.leftFrontLeg, this.rightFrontLeg, this.head, this.rightEar, this.leftEar, this.tail, this.nose, new class_630[0]).forEach(part -> part.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha));
            matrices.method_22909();
        }
    }

    @Override
    public void setAngles(InfectedRabbitEntity entity, float f, float g, float h, float i, float j) {
        float k = h - (float)entity.field_6012;
        this.nose.field_3654 = j * ((float)Math.PI / 180);
        this.head.field_3654 = j * ((float)Math.PI / 180);
        this.rightEar.field_3654 = j * ((float)Math.PI / 180);
        this.leftEar.field_3654 = j * ((float)Math.PI / 180);
        this.nose.field_3675 = i * ((float)Math.PI / 180);
        this.head.field_3675 = i * ((float)Math.PI / 180);
        this.rightEar.field_3675 = this.nose.field_3675 - 0.2617994f;
        this.leftEar.field_3675 = this.nose.field_3675 + 0.2617994f;
        this.jumpProgress = class_3532.method_15374(entity.getJumpProgress(k) * (float)Math.PI);
        this.leftHaunch.field_3654 = (this.jumpProgress * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rightHaunch.field_3654 = (this.jumpProgress * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.leftHindLeg.field_3654 = this.jumpProgress * 50.0f * ((float)Math.PI / 180);
        this.rightHindLeg.field_3654 = this.jumpProgress * 50.0f * ((float)Math.PI / 180);
        this.leftFrontLeg.field_3654 = (this.jumpProgress * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rightFrontLeg.field_3654 = (this.jumpProgress * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    @Override
    public void animateModel(InfectedRabbitEntity entity, float f, float g, float h) {
        super.method_2816(entity, f, g, h);
        this.jumpProgress = class_3532.method_15374(entity.getJumpProgress(h) * (float)Math.PI);
    }
}