package com.herobrinemod.herobrine.client.entities.models;

import com.google.common.collect.ImmutableList;
import com.herobrinemod.herobrine.entities.InfectedWolfEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4593;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_6230;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import org.jetbrains.annotations.NotNull;

@Environment(EnvType.CLIENT)
public class InfectedWolfEntityModel extends class_4593<InfectedWolfEntity> {
    private final class_630 head;
    private final class_630 torso;
    private final class_630 rightHindLeg;
    private final class_630 leftHindLeg;
    private final class_630 rightFrontLeg;
    private final class_630 leftFrontLeg;
    private final class_630 tail;
    private final class_630 realTail;
    private final class_630 neck;

    public InfectedWolfEntityModel(@NotNull class_630 root) {
        this.head = root.method_32086(class_6230.field_32606);
        this.torso = root.method_32086(class_6230.field_32608);
        this.neck = root.method_32086("upper_body");
        this.rightHindLeg = root.method_32086(class_6230.field_32634);
        this.leftHindLeg = root.method_32086(class_6230.field_32633);
        this.rightFrontLeg = root.method_32086(class_6230.field_32636);
        this.leftFrontLeg = root.method_32086(class_6230.field_32635);
        this.tail = root.method_32086(class_6230.field_32599);
        this.realTail = this.tail.method_32086("real_tail");
    }

    public static class_5607 getTexturedModelData() {
        return class_5607.method_32110(getModelData(class_5605.field_27715), 64, 32);
    }

    public static @NotNull class_5609 getModelData(class_5605 dilation) {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData2 = modelPartData.method_32117(class_6230.field_32606, class_5606.method_32108(), class_5603.method_32090(-1.0F, 13.5F, -7.0F));
        modelPartData2.method_32117(
                "real_head",
                class_5606.method_32108()
                        .method_32101(0, 0)
                        .method_32098(-2.0F, -3.0F, -2.0F, 6.0F, 6.0F, 4.0F, dilation)
                        .method_32101(16, 14)
                        .method_32098(-2.0F, -5.0F, 0.0F, 2.0F, 2.0F, 1.0F, dilation)
                        .method_32101(16, 14)
                        .method_32098(2.0F, -5.0F, 0.0F, 2.0F, 2.0F, 1.0F, dilation)
                        .method_32101(0, 10)
                        .method_32098(-0.5F, -0.001F, -5.0F, 3.0F, 3.0F, 4.0F, dilation),
                class_5603.field_27701
        );
        modelPartData.method_32117(
                class_6230.field_32608,
                class_5606.method_32108().method_32101(18, 14).method_32098(-3.0F, -2.0F, -3.0F, 6.0F, 9.0F, 6.0F, dilation),
                class_5603.method_32091(0.0F, 14.0F, 2.0F, (float) (Math.PI / 2), 0.0F, 0.0F)
        );
        modelPartData.method_32117(
                "upper_body",
                class_5606.method_32108().method_32101(21, 0).method_32098(-3.0F, -3.0F, -3.0F, 8.0F, 6.0F, 7.0F, dilation),
                class_5603.method_32091(-1.0F, 14.0F, -3.0F, (float) (Math.PI / 2), 0.0F, 0.0F)
        );
        class_5606 modelPartBuilder = class_5606.method_32108().method_32101(0, 18).method_32098(0.0F, 0.0F, -1.0F, 2.0F, 8.0F, 2.0F, dilation);
        modelPartData.method_32117(class_6230.field_32634, modelPartBuilder, class_5603.method_32090(-2.5F, 16.0F, 7.0F));
        modelPartData.method_32117(class_6230.field_32633, modelPartBuilder, class_5603.method_32090(0.5F, 16.0F, 7.0F));
        modelPartData.method_32117(class_6230.field_32636, modelPartBuilder, class_5603.method_32090(-2.5F, 16.0F, -4.0F));
        modelPartData.method_32117(class_6230.field_32635, modelPartBuilder, class_5603.method_32090(0.5F, 16.0F, -4.0F));
        class_5610 modelPartData3 = modelPartData.method_32117(
                class_6230.field_32599, class_5606.method_32108(), class_5603.method_32091(-1.0F, 12.0F, 8.0F, (float) (Math.PI / 5), 0.0F, 0.0F)
        );
        modelPartData3.method_32117("real_tail", class_5606.method_32108().method_32101(9, 18).method_32098(0.0F, 0.0F, -1.0F, 2.0F, 8.0F, 2.0F, dilation), class_5603.field_27701);
        return modelData;
    }

    @Override
    protected Iterable<class_630> method_22946() {
        return ImmutableList.of(this.head);
    }

    @Override
    protected Iterable<class_630> method_22948() {
        return ImmutableList.of(this.torso, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg, this.tail, this.neck);
    }

    @Override
    public void animateModel(@NotNull InfectedWolfEntity entity, float f, float g, float h) {
        this.tail.field_3675 = class_3532.method_15362(f * 0.6662F) * 1.4F * g;
        this.torso.method_2851(0.0F, 14.0F, 2.0F);
        this.torso.field_3654 = (float) (Math.PI / 2);
        this.neck.method_2851(-1.0F, 14.0F, -3.0F);
        this.neck.field_3654 = this.torso.field_3654;
        this.tail.method_2851(-1.0F, 12.0F, 8.0F);
        this.rightHindLeg.method_2851(-2.5F, 16.0F, 7.0F);
        this.leftHindLeg.method_2851(0.5F, 16.0F, 7.0F);
        this.rightFrontLeg.method_2851(-2.5F, 16.0F, -4.0F);
        this.leftFrontLeg.method_2851(0.5F, 16.0F, -4.0F);
        this.rightHindLeg.field_3654 = class_3532.method_15362(f * 0.6662F) * 1.4F * g;
        this.leftHindLeg.field_3654 = class_3532.method_15362(f * 0.6662F + (float) Math.PI) * 1.4F * g;
        this.rightFrontLeg.field_3654 = class_3532.method_15362(f * 0.6662F + (float) Math.PI) * 1.4F * g;
        this.leftFrontLeg.field_3654 = class_3532.method_15362(f * 0.6662F) * 1.4F * g;
        this.neck.field_3674 = entity.getShakeAnimationProgress(h, -0.08F);
        this.torso.field_3674 = entity.getShakeAnimationProgress(h, -0.16F);
        this.realTail.field_3674 = entity.getShakeAnimationProgress(h, -0.2F);
    }

    @Override
    public void setAngles(InfectedWolfEntity entity, float f, float g, float h, float i, float j) {
        this.head.field_3654 = j * (float) (Math.PI / 180.0);
        this.head.field_3675 = i * (float) (Math.PI / 180.0);
        this.tail.field_3654 = h;
    }
}
