package com.herobrinemod.herobrine.client.entities.renderers;

import com.google.common.collect.Maps;
import com.herobrinemod.herobrine.HerobrineMod;
import com.herobrinemod.herobrine.client.entities.models.HerobrineModelLayers;
import com.herobrinemod.herobrine.client.entities.models.InfectedAxolotlEntityModel;
import com.herobrinemod.herobrine.entities.InfectedAxolotlEntity;
import org.jetbrains.annotations.NotNull;

import java.util.Locale;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_5617;
import net.minecraft.class_5762;
import net.minecraft.class_927;

public class InfectedAxolotlEntityRenderer extends class_927<InfectedAxolotlEntity, InfectedAxolotlEntityModel> {
    private static final Map<class_5762.class_5767, class_2960> TEXTURES = class_156.method_654(Maps.newHashMap(), variants -> {
        for (class_5762.class_5767 variant : class_5762.class_5767.values()) {
            variants.put(variant, new class_2960(String.format(Locale.ROOT, HerobrineMod.MODID + ":textures/entity/infected_axolotl/axolotl_%s.png", variant.method_33238())));
        }
    });

    public InfectedAxolotlEntityRenderer(class_5617.class_5618 context) {
        super(context, new InfectedAxolotlEntityModel(context.method_32167(HerobrineModelLayers.INFECTED_AXOLOTL_MODEL_LAYER)), 0.5f);
        this.method_4046(new InfectedAxolotlEyesFeatureRenderer(this));
    }

    @Override
    public class_2960 getTexture(@NotNull InfectedAxolotlEntity axolotlEntity) {
        return TEXTURES.get(axolotlEntity.method_47827());
    }
}