package com.herobrinemod.herobrine.client.entities.renderers;

import com.google.common.collect.Maps;
import com.herobrinemod.herobrine.HerobrineMod;
import com.herobrinemod.herobrine.client.entities.models.HerobrineModelLayers;
import com.herobrinemod.herobrine.client.entities.models.InfectedHorseEntityModel;
import com.herobrinemod.herobrine.entities.InfectedHorseEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5149;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

@Environment(EnvType.CLIENT)
public class InfectedHorseEntityRenderer extends class_927<InfectedHorseEntity, InfectedHorseEntityModel> {
    private static final Map<class_5149, class_2960> TEXTURES = class_156.method_654(Maps.newEnumMap(class_5149.class), map -> {
        map.put(class_5149.field_23816, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_horse/horse_white.png"));
        map.put(class_5149.field_23817, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_horse/horse_creamy.png"));
        map.put(class_5149.field_23818, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_horse/horse_chestnut.png"));
        map.put(class_5149.field_23819, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_horse/horse_brown.png"));
        map.put(class_5149.field_23820, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_horse/horse_black.png"));
        map.put(class_5149.field_23821, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_horse/horse_gray.png"));
        map.put(class_5149.field_23822, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_horse/horse_darkbrown.png"));
    });
    public InfectedHorseEntityRenderer(class_5617.class_5618 context) {
        super(context, new InfectedHorseEntityModel(context.method_32167(HerobrineModelLayers.INFECTED_HORSE_MODEL_LAYER)), 0.75f);
        this.method_4046(new InfectedHorseMarkingFeatureRenderer(this));
        this.method_4046(new InfectedHorseEyesFeatureRenderer(this));
    }

    @Override
    protected void scale(InfectedHorseEntity entity, @NotNull class_4587 matrixStack, float f) {
        matrixStack.method_22905(1.1f, 1.1f, 1.1f);
    }

    @Override
    public class_2960 getTexture(@NotNull InfectedHorseEntity entity) {
        return TEXTURES.get(entity.getVariant());
    }
}
