package com.herobrinemod.herobrine.client.entities.renderers;

import com.google.common.collect.Maps;
import com.herobrinemod.herobrine.client.entities.models.InfectedHorseEntityModel;
import com.herobrinemod.herobrine.entities.InfectedHorseEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5148;
import net.minecraft.class_922;
import java.util.Map;

@Environment(EnvType.CLIENT)
public class InfectedHorseMarkingFeatureRenderer extends class_3887<InfectedHorseEntity, InfectedHorseEntityModel> {
    private static final Map<class_5148, class_2960> TEXTURES = class_156.method_654(Maps.newEnumMap(class_5148.class), textures -> {
        textures.put(class_5148.field_23808, null);
        textures.put(class_5148.field_23809, new class_2960("textures/entity/horse/horse_markings_white.png"));
        textures.put(class_5148.field_23810, new class_2960("textures/entity/horse/horse_markings_whitefield.png"));
        textures.put(class_5148.field_23811, new class_2960("textures/entity/horse/horse_markings_whitedots.png"));
        textures.put(class_5148.field_23812, new class_2960("textures/entity/horse/horse_markings_blackdots.png"));
    });

    public InfectedHorseMarkingFeatureRenderer(class_3883<InfectedHorseEntity, InfectedHorseEntityModel> featureRendererContext) {
        super(featureRendererContext);
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, InfectedHorseEntity entity, float f, float g, float h, float j, float k, float l) {
        class_2960 identifier = TEXTURES.get(entity.getMarking());
        if (identifier == null || entity.method_5767()) {
            return;
        }
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23580(identifier));
        (this.method_17165()).method_2828(matrixStack, vertexConsumer, i, class_922.method_23622(entity, 0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
    }
}