package com.herobrinemod.herobrine.client.entities.renderers;

import com.herobrinemod.herobrine.HerobrineMod;
import com.herobrinemod.herobrine.client.entities.models.HerobrineModelLayers;
import com.herobrinemod.herobrine.client.entities.models.InfectedLlamaEntityModel;
import com.herobrinemod.herobrine.entities.InfectedLlamaEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;

@Environment(EnvType.CLIENT)
public class InfectedLlamaEntityRenderer extends class_927<InfectedLlamaEntity, InfectedLlamaEntityModel> {
    private static final class_2960 CREAMY_TEXTURE = class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_llama/creamy.png");
    private static final class_2960 WHITE_TEXTURE = class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_llama/white.png");
    private static final class_2960 BROWN_TEXTURE = class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_llama/brown.png");
    private static final class_2960 GRAY_TEXTURE = class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_llama/gray.png");

    public InfectedLlamaEntityRenderer(class_5617.class_5618 context) {
        super(context, new InfectedLlamaEntityModel(context.method_32167(HerobrineModelLayers.INFECTED_LLAMA_MODEL_LAYER)), 0.7f);
        this.method_4046(new InfectedLlamaEyesFeatureRenderer(this));
    }

    @Override
    public class_2960 getTexture(@NotNull InfectedLlamaEntity entity) {
        return switch (entity.getVariant()) {
            case CREAMY -> CREAMY_TEXTURE;
            case WHITE -> WHITE_TEXTURE;
            case BROWN -> BROWN_TEXTURE;
            case GRAY -> GRAY_TEXTURE;
        };
    }
}