package com.herobrinemod.herobrine.client.entities.renderers;

import com.google.common.collect.Maps;
import com.herobrinemod.herobrine.HerobrineMod;
import com.herobrinemod.herobrine.client.entities.models.HerobrineModelLayers;
import com.herobrinemod.herobrine.client.entities.models.InfectedCowEntityModel;
import com.herobrinemod.herobrine.entities.InfectedMooshroomEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

@Environment(EnvType.CLIENT)
public class InfectedMooshroomEntityRenderer extends class_927<InfectedMooshroomEntity, InfectedCowEntityModel<InfectedMooshroomEntity>> {
    private static final Map<InfectedMooshroomEntity.Type, class_2960> TEXTURES = class_156.method_654(Maps.newHashMap(), map -> {
        map.put(InfectedMooshroomEntity.Type.BROWN, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_brown_mooshroom.png"));
        map.put(InfectedMooshroomEntity.Type.RED, class_2960.method_43902(HerobrineMod.MODID, "textures/entity/infected_red_mooshroom.png"));
    });
    public InfectedMooshroomEntityRenderer(class_5617.class_5618 context) {
        super(context, new InfectedCowEntityModel<>(context.method_32167(HerobrineModelLayers.INFECTED_COW_MODEL_LAYER)), 0.7f);
        this.method_4046(new InfectedMooshroomEyesFeatureRenderer(this));
        this.method_4046(new InfectedMooshroomMushroomFeatureRenderer(this, context.method_43337()));
    }

    @Override
    public class_2960 getTexture(@NotNull InfectedMooshroomEntity entity) {
        return TEXTURES.get(entity.getVariant());
    }
}
