package com.herobrinemod.herobrine.client.entities.renderers;

import com.herobrinemod.herobrine.client.entities.models.InfectedSheepEntityModel;
import com.herobrinemod.herobrine.client.entities.models.InfectedSheepWoolEntityModel;
import com.herobrinemod.herobrine.entities.InfectedSheepEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_922;
import net.minecraft.class_994;
import org.jetbrains.annotations.NotNull;

@Environment(EnvType.CLIENT)
public class InfectedSheepWoolFeatureRenderer extends class_3887<InfectedSheepEntity, InfectedSheepEntityModel> {
    private static final class_2960 SKIN = new class_2960("textures/entity/sheep/sheep_fur.png");
    private final InfectedSheepWoolEntityModel model;
    public InfectedSheepWoolFeatureRenderer(class_3883<InfectedSheepEntity, InfectedSheepEntityModel> context, @NotNull class_5599 loader) {
        super(context);
        this.model = new InfectedSheepWoolEntityModel(loader.method_32072(class_5602.field_27594));
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, @NotNull InfectedSheepEntity entity, float f, float g, float h, float j, float k, float l) {
        float u;
        float t;
        float s;
        if (entity.isSheared()) {
            return;
        }

        if (entity.method_5767()) {
            class_310 minecraftClient = class_310.method_1551();
            boolean bl = minecraftClient.method_27022(entity);
            if (bl) {
                this.method_17165().method_17081(this.model);
                this.model.animateModel(entity, f, g, h);
                this.model.setAngles(entity, f, g, j, k, l);
                class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23287(SKIN));
                this.model.method_2828(matrixStack, vertexConsumer, i, class_922.method_23622(entity, 0.0f), 0.0f, 0.0f, 0.0f, 1.0f);
            }
            return;
        }

        if (entity.method_16914() && "jeb_".equals(entity.method_5477().getString())) {
            int n = entity.field_6012 / 25 + entity.method_5628();
            int o = class_1767.values().length;
            int p = n % o;
            int q = (n + 1) % o;
            float r = ((float)(entity.field_6012 % 25) + h) / 25.0f;
            float[] fs = InfectedSheepEntity.getRgbColor(class_1767.method_7791(p));
            float[] gs = InfectedSheepEntity.getRgbColor(class_1767.method_7791(q));
            s = fs[0] * (1.0f - r) + gs[0] * r;
            t = fs[1] * (1.0f - r) + gs[1] * r;
            u = fs[2] * (1.0f - r) + gs[2] * r;
        } else {
            float[] hs = InfectedSheepEntity.getRgbColor(entity.getColor());
            s = hs[0];
            t = hs[1];
            u = hs[2];
        }

        class_994.method_23196(this.method_17165(), this.model, SKIN, matrixStack, vertexConsumerProvider, i, entity, f, g, j, k, l, h, s, t, u);
    }
}