package com.herobrinemod.herobrine.client.entities.renderers;

import com.herobrinemod.herobrine.HerobrineMod;
import com.herobrinemod.herobrine.client.entities.models.HerobrineModelLayers;
import com.herobrinemod.herobrine.client.entities.models.InfectedWolfEntityModel;
import com.herobrinemod.herobrine.entities.InfectedWolfEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;

@Environment(EnvType.CLIENT)
public class InfectedWolfEntityRenderer extends class_927<InfectedWolfEntity, InfectedWolfEntityModel> {
    public InfectedWolfEntityRenderer(class_5617.class_5618 context) {
        super(context, new InfectedWolfEntityModel(context.method_32167(HerobrineModelLayers.INFECTED_WOLF_MODEL_LAYER)), 0.5f);
        this.method_4046(new InfectedWolfEyesFeatureRenderer(this));
    }

    @Override
    protected float getAnimationProgress(@NotNull InfectedWolfEntity entity, float f) {
        return (float) Math.PI / 5.0f;
    }

    @Override
    public void render(@NotNull InfectedWolfEntity entity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        if (entity.isFurWet()) {
            float h = entity.getFurWetBrightnessMultiplier(g);
            (this.field_4737).method_22955(h, h, h);
        }
        super.method_4072(entity, f, g, matrixStack, vertexConsumerProvider, i);
        if (entity.isFurWet()) {
            (this.field_4737).method_22955(1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public class_2960 getTexture(InfectedWolfEntity entity) {
        return new class_2960(HerobrineMod.MODID, "textures/entity/infected_wolf.png");
    }
}