package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.HerobrineMod;
import com.herobrinemod.herobrine.savedata.ConfigHandler;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3492;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7134;
import net.minecraft.entity.ai.goal.*;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class HerobrineBuilderEntity extends HerobrineEntity {
    private int lifeTimer;
    private int buildTimer;

    public HerobrineBuilderEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.lifeTimer = 5100;
        this.buildTimer = this.method_6051().method_39332(800, 1200);
        this.field_6194 = 5;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 0.6 ,false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(5, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(6, new class_1394(this, 0.4));
        this.field_6201.method_6277(7, new class_1361(this, class_1543.class, 32.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 32.0f));
        this.field_6201.method_6277(9, new class_1361(this, SurvivorEntity.class, 32.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1427.class, 32.0f));
        this.field_6201.method_6277(11, new class_1376(this));

    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 20.0)
                .method_26868(class_5134.field_23721, 5.0)
                .method_26868(class_5134.field_23718, 1.0)
                .method_26868(class_5134.field_23724, 0.0)
                .method_26868(class_5134.field_23725, 0.0)
                .method_26868(class_5134.field_23717, 32.0)
                .method_26868(class_5134.field_23719, 0.55);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("LifeTimer", this.lifeTimer);
        nbt.method_10569("BuildingInterval", this.buildTimer);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.lifeTimer = nbt.method_10550("LifeTimer");
        this.buildTimer = nbt.method_10550("BuildingInterval");
    }

    @Override
    public void method_5958() {
        if(this.lifeTimer < 1) {
            this.method_37908().method_8421(this, (byte) 4);
            this.method_5650(class_5529.field_26999);
        }
        this.lifeTimer --;
        super.method_5958();

        if(this.buildTimer < 1 && ConfigHandler.getHerobrineConfig().readBoolean("BuilderBuilds")) {
            this.buildTimer = field_5974.method_39332(800, 1200);
            if (method_37908().method_8503() != null) {
                int x = 0;
                int z = 0;

                switch (this.method_5735()) {
                    case field_11043 -> z = z - 2;
                    case field_11034 -> x = x + 2;
                    case field_11035 -> z = z + 2;
                    case field_11039 ->  x = x - 2;
                }

                class_2680 state = method_37908().method_8320(new class_2338(this.method_31477() + x, this.method_31478() - 1, this.method_31479() + z));
                class_5425 serverWorldAccess = (class_3218) method_37908();

                if(field_5974.method_43048(5) > 0) {
                    if(this.method_23318() < method_37908().method_8615()) {
                        if (method_37908().method_27983().method_29177().equals(class_7134.field_37670) && state.method_26164(class_3481.field_25806) && field_5974.method_43048(3) == 0) {
                            Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "ominous_mineshaft")).method_15172(serverWorldAccess, this.method_24515(), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            this.method_6104(class_1268.field_5808);
                            this.method_37908().method_8421(this, (byte) 5);
                            return;
                        }
                    } else if(state == class_2246.field_10102.method_9564()) {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "sand_structure")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492(), field_5974, class_2248.field_31036);
                        this.method_6104(class_1268.field_5808);
                        this.method_37908().method_8421(this, (byte) 5);
                        return;
                    } else if(state == class_2246.field_10534.method_9564()) {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "red_sand_structure")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492(), field_5974, class_2248.field_31036);
                        this.method_6104(class_1268.field_5808);
                        this.method_37908().method_8421(this, (byte) 5);
                        return;
                    } else if(state == class_2246.field_10515.method_9564() || state == class_2246.field_10266.method_9564() || state == class_2246.field_10364.method_9564() || state == class_2246.field_10390.method_9564() || state == class_2246.field_10159.method_9564() || state == class_2246.field_10127.method_9564() || state == class_2246.field_22113.method_9564() || state == class_2246.field_22120.method_9564() || state == class_2246.field_10541.method_9564() || state == class_2246.field_22115.method_9564() || state == class_2246.field_9974.method_9564() || state == class_2246.field_22116.method_9564() || state == class_2246.field_22125.method_9564() || state == class_2246.field_23078.method_9564() || state == class_2246.field_22123.method_9564() || state == class_2246.field_22121.method_9564() || state == class_2246.field_22114.method_9564() || state == class_2246.field_22503.method_9564() || state == class_2246.field_22505.method_9564() || state == class_2246.field_10114.method_9564() || state == class_2246.field_22090.method_9564()) {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "netherrack_structure")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492(), field_5974, class_2248.field_31036);
                        this.method_6104(class_1268.field_5808);
                        this.method_37908().method_8421(this, (byte) 5);
                        return;
                    } else if(state == class_2246.field_10471.method_9564() || state == class_2246.field_10462.method_9564() || state == class_2246.field_10064.method_9564() || state == class_2246.field_10012.method_9564() || state == class_2246.field_10001.method_9564() || state == class_2246.field_10286.method_9564() || state == class_2246.field_10505.method_9564() || state == class_2246.field_10175.method_9564() || state == class_2246.field_9992.method_9564() || state == class_2246.field_10021.method_9564() || state == class_2246.field_10528.method_9564() || state == class_2246.field_10455.method_9564()) {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "end_stone_structure")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492(), field_5974, class_2248.field_31036);
                        this.method_6104(class_1268.field_5808);
                        this.method_37908().method_8421(this, (byte) 5);
                        return;
                    } else if(state == class_2246.field_10415.method_9564()) {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "terracotta_structure")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492(), field_5974, class_2248.field_31036);
                        this.method_6104(class_1268.field_5808);
                        this.method_37908().method_8421(this, (byte) 5);
                        return;
                    } else if(state.method_26164(class_3481.field_25806)) {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "stone_structure")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + x), this.method_24515(), new class_3492(), field_5974, class_2248.field_31036);
                        this.method_6104(class_1268.field_5808);
                        this.method_37908().method_8421(this, (byte) 5);
                        return;
                    } else {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "dirt_structure")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492(), field_5974, class_2248.field_31036);
                        this.method_6104(class_1268.field_5808);
                        this.method_37908().method_8421(this, (byte) 5);
                        return;
                    }
                } else {
                    if(field_5974.method_43056() && this.method_31478() > this.method_37908().method_8615()) {
                        Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "glowstone_pillar")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                    } else {
                        int type = field_5974.method_43048(8);
                        switch (type) {
                            case 0 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/normal1")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 1 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/normal2")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 2 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/normal3")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 3 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/lore1")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 4 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/lore2")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 5 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/lore3")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 6 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/lore4")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 7 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/lore5")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                            case 8 -> Objects.requireNonNull(method_37908().method_8503()).method_27727().method_15091(class_2960.method_43902(HerobrineMod.MODID, "signs/lore6")).method_15172(serverWorldAccess, new class_2338(this.method_31477() + x, this.method_31478(), this.method_31479() + z), this.method_24515(), new class_3492().method_15123(class_2470.method_16548(field_5974)), field_5974, class_2248.field_31036);
                        }
                    }
                    this.method_6104(class_1268.field_5808);
                    this.method_37908().method_8421(this, (byte) 5);
                    return;
                }
            }
        }
        this.buildTimer --;
    }

    @Override
    public void method_5711(byte status) {
        super.method_5711(status);
        switch (status) {
            case 5 -> {
                if (this.method_37908().field_9236 && !this.method_5701()) {
                    this.method_37908().method_8486(this.method_23317(), this.method_23320(), this.method_23321(), class_3417.field_14564.comp_349(), this.method_5634(), 1.0f, (field_5974.method_43057() - field_5974.method_43057()) * 0.2f + 1.0f, false);
                }
            }

            case 4 -> {
                if (this.method_37908().field_9236) {
                    if (!this.method_5701()) {
                        this.method_37908().method_8486(this.method_23317(), this.method_23320(), this.method_23321(), class_3417.field_15013, this.method_5634(), 1.0f, (field_5974.method_43057() - field_5974.method_43057()) * 0.2f + 1.0f, false);
                    }

                    for (int i = 0; i < 20; i++) {
                        this.method_37908().method_8406(class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), field_5974.method_43059() * 0.02, field_5974.method_43059() * 0.02, field_5974.method_43059() * 0.02);
                    }
                }
            }
        }
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, class_2487 entityNbt) {
        this.method_5971();
        this.method_5673(class_1304.field_6173, new class_1799(class_1802.field_8335));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }
}