package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.savedata.ConfigHandler;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class HerobrineSpyEntity extends HerobrineEntity {
    private int lifeTimer;

    public HerobrineSpyEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.lifeTimer = 6000;
        this.field_6194 = 5;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1361(this, class_1543.class, 1024.0f));
        this.field_6201.method_6277(2, new class_1361(this, class_1657.class, 1024.0f));
        this.field_6201.method_6277(3, new class_1361(this, SurvivorEntity.class, 1024.0f));
        this.field_6201.method_6277(3, new class_1338<>(this, class_1543.class, ConfigHandler.getHerobrineConfig().readInt("HerobrineSpyObservationDistance"), 0.7, 1.0));
        this.field_6201.method_6277(4, new class_1338<>(this, class_1657.class, ConfigHandler.getHerobrineConfig().readInt("HerobrineSpyObservationDistance"), 0.7, 1.0));
        this.field_6201.method_6277(5, new class_1338<>(this, SurvivorEntity.class, 32.0f, 0.7, 1.0));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 20.0)
                .method_26868(class_5134.field_23721, 0.0)
                .method_26868(class_5134.field_23718, 1.0)
                .method_26868(class_5134.field_23724, 0.0)
                .method_26868(class_5134.field_23725, 0.0)
                .method_26868(class_5134.field_23717, 128.0)
                .method_26868(class_5134.field_23719, 0.6);
    }

    @Override
    protected boolean method_23734() {
        return false;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("LifeTimer", this.lifeTimer);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.lifeTimer = nbt.method_10550("LifeTimer");
    }

    @Override
    public void method_5958() {
        if(this.lifeTimer < 1) {
            this.method_37908().method_8421(this, (byte) 4);
            this.method_5650(class_5529.field_26999);
        }
        this.lifeTimer --;

        class_238 effectBox = method_5829().method_1009(8.0, 0.0, 8.0);
        List<class_1309> affectedEntities = this.method_37908().method_8390(class_1309.class, effectBox, class_1301.field_6157);
        if(!affectedEntities.isEmpty()) {
            for(class_1309 entity : affectedEntities) {
                if((entity instanceof class_1657 && !((class_1657) entity).method_7337()) || entity instanceof SurvivorEntity) {
                    this.method_37908().method_8421(this, (byte) 4);
                    this.method_5650(class_5529.field_26999);
                }
            }
        }
        super.method_5958();
    }

    @Override
    public void method_5711(byte status) {
        super.method_5711(status);
        if(status == 4) {
            if(this.method_37908().field_9236) {
                if (!this.method_5701()) {
                    this.method_37908().method_8486(this.method_23317(), this.method_23320(), this.method_23321(), class_3417.field_15013, this.method_5634(), 1.0f, (field_5974.method_43057() - field_5974.method_43057()) * 0.2f + 1.0f, false);
                }

                for (int i = 0; i < 20; i ++) {
                    this.method_37908().method_8406(class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), field_5974.method_43059() * 0.02, field_5974.method_43059() * 0.02, field_5974.method_43059() * 0.02);
                }
            }
        }
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, class_2487 entityNbt) {
        this.method_5971();
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }
}
