package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.items.ItemList;
import com.herobrinemod.herobrine.savedata.ConfigHandler;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.entity.ai.goal.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class HerobrineWarriorEntity extends HerobrineEntity {
    private int destroyCooldown;

    public HerobrineWarriorEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.destroyCooldown = this.method_6051().method_39332(200, 600);
        this.field_6194 = 5;

    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 0.6, false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(5, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(6, new class_1394(this, 0.4));
        this.field_6201.method_6277(7, new class_1361(this, class_1543.class, 64.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 64.0f));
        this.field_6201.method_6277(9, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1427.class, 64.0f));
        this.field_6201.method_6277(11, new class_1376(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 50.0)
                .method_26868(class_5134.field_23721, 5.0)
                .method_26868(class_5134.field_23718, 1.0)
                .method_26868(class_5134.field_23724, 2.0)
                .method_26868(class_5134.field_23725, 2.0)
                .method_26868(class_5134.field_23717, 64.0)
                .method_26868(class_5134.field_23719, 0.6);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("DestroyCooldown", this.destroyCooldown);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.destroyCooldown = nbt.method_10550("DestroyCooldown");
    }

    public boolean canDestroy(@NotNull class_2680 state) {
        return !state.method_26164(class_3481.field_21952)  && !state.method_26215() && !state.method_26164(class_3481.field_17754) && !state.method_26164(class_3481.field_17753) && !state.method_26164(class_3481.field_16443) && !state.method_26164(class_3481.field_20341) && !state.method_26164(class_3481.field_15479) && !state.method_26164(class_3481.field_15493) && !state.method_26164(class_3481.field_15499) && !state.method_26164(class_3481.field_15470) && !state.method_26164(class_3481.field_21780) && !state.method_26164(class_3481.field_15463) && !state.method_26164(class_3481.field_15462) && !state.method_26164(class_3481.field_15480) && !state.method_26164(class_3481.field_20339) && !state.method_26164(class_3481.field_15500) && !state.method_26164(class_3481.field_15472) && !state.method_26164(class_3481.field_15496) && !state.method_26164(class_3481.field_15476) && !state.method_26164(class_3481.field_15483) && !state.method_26164(class_3481.field_15492) && !state.method_26164(class_3481.field_20338) && !state.method_26164(class_3481.field_15477) && !state.method_26164(class_3481.field_24076);
    }

    @Override
    public void method_5958() {
        super.method_5958();
        if(this.destroyCooldown < 1 && ConfigHandler.getHerobrineConfig().readBoolean("WarriorBreaksBlocks") && this.unableToAttackTarget() && this.method_5968() instanceof class_1657 && method_37908().method_8450().method_8355(class_1928.field_19388)) {
            this.destroyCooldown = field_5974.method_39332(200, 600);
            for (int y = 0; y <= 1; y ++) {
                class_2338 blockPos = getBlockPos(y);
                class_2680 blockState = this.method_37908().method_8320(blockPos);
                if (this.canDestroy(blockState)) {
                    this.method_37908().method_8651(blockPos, true, this);
                    this.method_6104(class_1268.field_5808);
                }
            }
        }
        this.destroyCooldown --;
    }

    private @NotNull class_2338 getBlockPos(int y) {
        int x = 0;
        int z = 0;

        if(class_3532.method_15382(this.method_31477() - Objects.requireNonNull(method_5968()).method_31477()) > class_3532.method_15382(this.method_31479() - method_5968().method_31479())) {
            if(this.method_31477() > this.method_5968().method_31477()) {
                x --;
            } else {
                x ++;
            }
        } else {
            if(this.method_31479() > this.method_5968().method_31479()) {
                z --;
            } else {
                z ++;
            }
        }

        return new class_2338(this.method_31477() + x, class_3532.method_15357(this.method_23318()) + y, this.method_31479() + z);
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, class_2487 entityNbt) {
        this.method_5673(class_1304.field_6173, new class_1799(ItemList.BEDROCK_SWORD));
        if(!ConfigHandler.getHerobrineConfig().readBoolean("BedrockSwordDrops")) {
            this.field_6187[class_1304.field_6173.method_5927()] = 0.0f;
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }
}