package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.items.ItemList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_3417;
import net.minecraft.class_3857;

public class HolyWaterEntity extends class_3857 {

    public HolyWaterEntity(class_1299<? extends class_3857> entityType, class_1309 livingEntity, class_1937 world) {
        super(entityType, livingEntity, world);
    }

    public HolyWaterEntity(class_1937 world) {
        super((class_1299<? extends class_3857>) EntityTypeList.HOLY_WATER, world);
    }

    @Override
    protected class_1792 method_16942() {
        return ItemList.HOLY_WATER;
    }

    @Override
    public void method_5711(byte status) {
        if (status == 3) {
            for (int i = 0; i < 8; ++i) {
                this.method_37908().method_8406(new class_2392(class_2398.field_11218, new class_1799(method_16942())), this.method_23317(), this.method_23318() + 0.1, this.method_23321(), 0.0, 0.01, 0.0);
            }
        }
    }

    @Override
    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (!this.method_37908().field_9236) {
            class_238 effectBox = method_5829().method_1009(1.0, 1.0, 1.0);
            List<class_1309> affectedEntities = this.method_37908().method_8390(class_1309.class, effectBox, class_1301.field_6157);
            if(!affectedEntities.isEmpty()) {
                for(class_1309 entity : affectedEntities) {
                    entity.method_33572(false);
                    entity.method_6012();
                    if (entity.method_5864().method_20210(EntityTypeTagList.IS_INFECTED_BY_HEROBRINE)) {
                        ((InfectedEntity) entity).convert();
                        break;
                    }

                    if(!(entity.method_5864().method_20210(EntityTypeTagList.IS_HEROBRINE))) {
                        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
                        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
                    } else {
                        if (entity instanceof FakeHerobrineMageEntity) {
                            entity.method_5650(class_5529.field_26999);
                            break;
                        }
                        entity.method_5643(this.method_48923().method_48811(this, method_24921()), 10.0f);
                    }
                }
            }
            this.method_5783(class_3417.field_15081, 0.8f, 0.9f / (field_5974.method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8421(this, (byte) 3);
            this.method_5650(class_5529.field_26999);
        }
    }
}
