package com.herobrinemod.herobrine.entities;

import com.google.common.collect.Maps;
import com.herobrinemod.herobrine.items.ItemList;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1393;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1427;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_5762;
import net.minecraft.class_5766;
import net.minecraft.class_5819;
import net.minecraft.class_6375;
import net.minecraft.class_7;
import net.minecraft.class_7988;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import net.minecraft.world.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.Map;

public class InfectedAxolotlEntity extends InfectedEntity implements class_6375, class_7988<class_5762.class_5767> {
    private final Map<String, Vector3f> modelAngles = Maps.newHashMap();
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(InfectedAxolotlEntity.class, class_2943.field_13327);

    public InfectedAxolotlEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0F);
        this.field_6207 = new class_5757(this, 85, 10, 0.1f, 0.15f, false);
        this.field_6206 = new class_1332(this, 20);
        this.method_49477(1.0F);
        this.field_6194 = 3;
        this.setConversionEntity(class_1299.field_28315);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1366(this, 1.0, false));
        this.field_6201.method_6277(1, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(5, new class_1393(this));
        this.field_6201.method_6277(6, new class_1378(this, 1.0, 10));
        this.field_6201.method_6277(7, new class_1361(this, class_1543.class, 8.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1427.class, 8.0f));
        this.field_6201.method_6277(11, new class_1376(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 14.0)
                .method_26868(class_5134.field_23721, 2.0)
                .method_26868(class_5134.field_23717, 16.0)
                .method_26868(class_5134.field_23719, 0.5);
    }

    @Override
    public void convert() {
        this.method_37908().method_8421(this, (byte) 16);
        this.method_5706(ItemList.CURSED_DUST);
        class_1308 entity = this.method_29243(this.getConversionEntity(), false);
        assert entity != null;
        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
        entity.method_5943((class_5425) this.method_37908(), method_37908().method_8404(this.method_24515()), class_3730.field_16468, null, null);
        ((class_5762) entity).method_33219(this.method_47827());
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, 0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.method_47827().method_33233());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(class_5762.class_5767.method_47928(nbt.method_10550("Variant")));
    }

    @Override
    public Map<String, Vector3f> method_36976() {
        return this.modelAngles;
    }

    @Override
    public float method_6144(class_2338 pos, class_4538 world) {
        return 0.0f;
    }

    @Override
    public boolean method_6121(@NotNull class_1297 target) {
        boolean bl = super.method_6121(target);
        if (bl) {
            this.method_5783(class_3417.field_28287, 1.0F, 1.0F);
        }

        return bl;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_28289;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_28288;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_5799() ? class_3417.field_28291 : class_3417.field_28290;
    }

    @Override
    protected class_3414 method_5625() {
        return class_3417.field_28292;
    }

    @Override
    protected class_3414 method_5737() {
        return class_3417.field_28293;
    }

    @Override
    public void method_6091(class_243 movementInput) {
        if (this.method_5787() && this.method_5799()) {
            this.method_5724(this.method_6029(), movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(movementInput);
        }
    }

    @Override
    public void method_5670() {
        int i = this.method_5669();
        super.method_5670();
        if (!this.method_5987()) {
            this.tickAir(i);
        }

    }

    protected void tickAir(int air) {
        if (this.method_5805() && !this.method_5637()) {
            this.method_5855(air - 1);
            if (this.method_5669() == -20) {
                this.method_5855(0);
                this.method_5643(this.method_48923().method_48834(), 2.0F);
            }
        } else {
            this.method_5855(this.method_5748());
        }

    }

    public void hydrateFromPotion() {
        int i = this.method_5669() + 1800;
        this.method_5855(Math.min(i, this.method_5748()));
    }

    @Override
    public int method_5748() {
        return 6000;
    }

    @Override
    public boolean method_6094() {
        return true;
    }

    @Override
    public boolean method_5675() {
        return false;
    }

    @Override
    protected float method_18394(class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.655F;
    }

    @Override
    public int method_5978() {
        return 1;
    }

    @Override
    public int method_5986() {
        return 1;
    }

    @Override
    protected class_1408 method_5965(class_1937 world) {
        return new class_5766(this, world);
    }

    @Override
    public class_1315 method_5943(@NotNull class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_5819 random = world.method_8409();
        entityData = new class_5762.class_5763(class_5762.class_5767.method_33235(random), class_5762.class_5767.method_33235(random));
        this.setVariant(((class_5762.class_5763)entityData).method_33232(random));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean method_5957(@NotNull class_4538 world) {
        return world.method_8606(this);
    }

    public static boolean canSpawn(class_1299<? extends InfectedEntity> type, @NotNull class_5425 world, class_3730 spawnReason, @NotNull class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && world.method_8320(pos.method_10074()).method_26164(class_3481.field_35568) && world.method_22339(pos) < 11 && method_20636(type, world, spawnReason, pos, random) && HerobrineSpawnHelper.canHerobrineSpawn() && HerobrineSpawnHelper.getStage() > 1;
    }

    public class_5762.class_5767 method_47827() {
        return class_5762.class_5767.method_47928(this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(class_5762.@NotNull class_5767 variant) {
        this.field_6011.method_12778(VARIANT, variant.method_33233());
    }
}