package com.herobrinemod.herobrine.entities;

import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6088;
import net.minecraft.entity.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedBatEntity extends InfectedEntity{
    public static final int wingFlap = class_3532.method_15386(2.4166098f);
    private static final class_2940<Byte> BAT_FLAGS = class_2945.method_12791(InfectedBatEntity.class, class_2943.field_13319);
    private static final class_4051 CLOSE_PLAYER_PREDICATE = class_4051.method_36626().method_18418(4.0);
    @Nullable
    private class_2338 hangingPosition;

    public InfectedBatEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.setConversionEntity(class_1299.field_6108);
        if (!world.field_9236) {
            this.setRoosting(true);
        }
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1366(this, 1.0, false));
        this.field_6201.method_6277(1, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(5, new class_1361(this, class_1543.class, 8.0f));
        this.field_6201.method_6277(6, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1427.class, 8.0f));
        this.field_6201.method_6277(9, new class_1376(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 6.0)
                .method_26868(class_5134.field_23721, 1.0)
                .method_26868(class_5134.field_23717, 16.0);
    }

    @Override
    protected float method_18394(class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 / 2.0f;
    }

    @Override
    public boolean method_5776() {
        return !this.isRoosting() && this.field_6012 % wingFlap == 0;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BAT_FLAGS, (byte)0);
    }

    @Override
    protected float method_6107() {
        return 0.1f;
    }

    @Override
    public float method_6017() {
        return super.method_6017() * 0.95f;
    }

    @Override
    @Nullable
    public class_3414 method_5994() {
        if (this.isRoosting() && this.field_5974.method_43048(4) != 0) {
            return null;
        }
        return class_3417.field_15009;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14746;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_14911;
    }

    @Override
    public boolean method_5810() {
        return false;
    }

    @Override
    protected void method_6087(class_1297 entity) {
    }

    @Override
    protected void method_6070() {
    }

    public boolean isRoosting() {
        return (this.field_6011.method_12789(BAT_FLAGS) & 1) != 0;
    }

    public void setRoosting(boolean roosting) {
        byte b = this.field_6011.method_12789(BAT_FLAGS);
        if (roosting) {
            this.field_6011.method_12778(BAT_FLAGS, (byte)(b | 1));
        } else {
            this.field_6011.method_12778(BAT_FLAGS, (byte)(b & 0xFFFFFFFE));
        }
    }

    public static boolean canBatSpawn(class_1299<? extends InfectedBatEntity> type, @NotNull class_5425 world, class_3730 spawnReason, @NotNull class_2338 pos, class_5819 random) {
        if(world.method_23753(pos).method_40226(class_1972.field_9462.method_29177()) && random.method_43048(20) > 1) {
            return false;
        }
        return pos.method_10264() < world.method_8615() && world.method_8407() != class_1267.field_5801 && method_20679(world, pos, random) && method_20636(type, world, spawnReason, pos, random) && HerobrineSpawnHelper.canHerobrineSpawn() && HerobrineSpawnHelper.getStage() > 1;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.isRoosting()) {
            this.method_18799(class_243.field_1353);
            this.method_23327(this.method_23317(), (double)class_3532.method_15357(this.method_23318()) + 1.0 - (double)this.method_17682(), this.method_23321());
        } else {
            this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
        }
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        class_2338 blockPos = this.method_24515();
        class_2338 blockPos2 = blockPos.method_10084();
        if (this.isRoosting()) {
            boolean bl = this.method_5701();
            if (this.method_37908().method_8320(blockPos2).method_26212(this.method_37908(), blockPos)) {
                if (this.field_5974.method_43048(200) == 0) {
                    this.field_6241 = this.field_5974.method_43048(360);
                }
                if (this.method_37908().method_18462(CLOSE_PLAYER_PREDICATE, this) != null) {
                    this.setRoosting(false);
                    if (!bl) {
                        this.method_37908().method_8444(null, class_6088.field_31183, blockPos, 0);
                    }
                }
            } else {
                this.setRoosting(false);
                if (!bl) {
                    this.method_37908().method_8444(null, class_6088.field_31183, blockPos, 0);
                }
            }
        } else {
            if (!(this.hangingPosition == null || this.method_37908().method_22347(this.hangingPosition) && this.hangingPosition.method_10264() > this.method_37908().method_31607())) {
                this.hangingPosition = null;
            }
            if (this.hangingPosition == null || this.field_5974.method_43048(30) == 0 || this.hangingPosition.method_19769(this.method_19538(), 2.0)) {
                this.hangingPosition = class_2338.method_49637(this.method_23317() + (double)this.field_5974.method_43048(7) - (double)this.field_5974.method_43048(7), this.method_23318() + (double)this.field_5974.method_43048(6) - 2.0, this.method_23321() + (double)this.field_5974.method_43048(7) - (double)this.field_5974.method_43048(7));
            }
            double d = (double)this.hangingPosition.method_10263() + 0.5 - this.method_23317();
            assert this.hangingPosition != null;
            double e = (double)this.hangingPosition.method_10264() + 0.1 - this.method_23318();
            assert this.hangingPosition != null;
            double f = (double)this.hangingPosition.method_10260() + 0.5 - this.method_23321();
            class_243 vec3d = this.method_18798();
            class_243 vec3d2 = vec3d.method_1031((Math.signum(d) * 0.5 - vec3d.field_1352) * (double)0.1f, (Math.signum(e) * (double)0.7f - vec3d.field_1351) * (double)0.1f, (Math.signum(f) * 0.5 - vec3d.field_1350) * (double)0.1f);
            this.method_18799(vec3d2);
            float g = (float)(class_3532.method_15349(vec3d2.field_1350, vec3d2.field_1352) * 57.2957763671875) - 90.0f;
            float h = class_3532.method_15393(g - this.method_36454());
            if (this.method_5968() != null) {
                this.moveToEntity(this.method_5968());
            } else {
                this.field_6250 = 0.5f;
            }
            this.method_36456(this.method_36454() + h);
            if (this.field_5974.method_43048(100) == 0 && this.method_37908().method_8320(blockPos2).method_26212(this.method_37908(), blockPos2)) {
                this.setRoosting(true);
            }
        }
    }

    public void moveToEntity(@NotNull class_1297 entity) {
        this.setRoosting(false);
        double x = entity.method_23317() - this.method_23317();
        double y = (entity.method_23318() + 1) - this.method_23318();
        double z = entity.method_23321() - this.method_23321();
        class_243 motion = new class_243(x - (x * 0.9), y - (y * 0.9), z - (z * 0.9));
        this.method_18799(motion);
    }

    @Override
    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    @Override
    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    @Override
    public boolean method_5696() {
        return true;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236 && this.isRoosting()) {
            this.setRoosting(false);
        }
        return super.method_5643(source, amount);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(BAT_FLAGS, nbt.method_10571("BatFlags"));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("BatFlags", this.field_6011.method_12789(BAT_FLAGS));
    }
}