package com.herobrinemod.herobrine.entities;

import com.google.common.annotations.VisibleForTesting;
import com.herobrinemod.herobrine.entities.goals.InfectedCamelSitOrStandGoal;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1427;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7094;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedCamelEntity extends InfectedEntity {
    private static final class_4048 SITTING_DIMENSIONS = class_4048.method_18384(EntityTypeList.INFECTED_CAMEL.method_17685(), EntityTypeList.INFECTED_CAMEL.method_17686() - 1.43f);
    public final class_7094 sittingTransitionAnimationState = new class_7094();
    public final class_7094 sittingAnimationState = new class_7094();
    public final class_7094 standingTransitionAnimationState = new class_7094();
    public final class_7094 idlingAnimationState = new class_7094();
    private int idleAnimationCooldown = 0;
    public static final class_2940<Long> LAST_POSE_TICK = class_2945.method_12791(InfectedCamelEntity.class, class_2943.field_39965);
    private final class_1394 wanderAroundFarGoal = new class_1394(this, 2.0);


    public InfectedCamelEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.5f);
        this.field_6194 = 3;
        this.field_6207 = new InfectedCamelMoveControl();
        class_1409 mobNavigation = (class_1409)this.method_5942();
        mobNavigation.method_6354(true);
        mobNavigation.method_46645(true);
        this.setConversionEntity(class_1299.field_40116);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 3.0, false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(5, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(7, new class_1361(this, class_1543.class, 8.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1427.class, 8.0f));
        this.field_6201.method_6277(11, new class_1376(this));
        this.field_6201.method_6277(12, new InfectedCamelSitOrStandGoal(this, 20));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 32.0)
                .method_26868(class_5134.field_23721, 4.0)
                .method_26868(class_5134.field_23717, 16.0)
                .method_26868(class_5134.field_23719, 0.09);
    }

    @Override
    public class_4048 method_18377(class_4050 pose) {
        return pose == class_4050.field_40118 ? SITTING_DIMENSIONS.method_18383(this.method_17825()) : super.method_18377(pose);
    }

    @Override
    protected float method_18394(class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 - 0.1f * this.method_17825();
    }

    private void updateAnimations() {
        if (this.idleAnimationCooldown <= 0) {
            this.idleAnimationCooldown = this.field_5974.method_43048(40) + 80;
            this.idlingAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationCooldown;
        }
        if (this.shouldUpdateSittingAnimations()) {
            this.standingTransitionAnimationState.method_41325();
            if (this.shouldPlaySittingTransitionAnimation()) {
                this.sittingTransitionAnimationState.method_41324(this.field_6012);
                this.sittingAnimationState.method_41325();
            } else {
                this.sittingTransitionAnimationState.method_41325();
                this.sittingAnimationState.method_41324(this.field_6012);
            }
        } else {
            this.sittingTransitionAnimationState.method_41325();
            this.sittingAnimationState.method_41325();
            this.standingTransitionAnimationState.method_45317(this.isChangingPose() && this.getLastPoseTickDelta() >= 0L, this.field_6012);
        }
    }

    @Override
    public float method_6029() {
        return this.isStationary() ? 0.0f : super.method_6029();
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10544("LastPoseTick", this.field_6011.method_12789(LAST_POSE_TICK));
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        long l = nbt.method_10537("LastPoseTick");
        if (l < 0L) {
            this.method_18380(class_4050.field_40118);
        }
        this.setLastPoseTick(l);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LAST_POSE_TICK, 0L);
    }

    @Override
    public class_1315 method_5943(@NotNull class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.initLastPoseTick(world.method_8410().method_8510());
        this.field_6201.method_6277(6, wanderAroundFarGoal);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.updateAnimations();
        }
        if(this.isSitting()) {
            if(this.method_5968() != null) {
                this.startStanding();
            }
            this.field_6201.method_6280(wanderAroundFarGoal);
        } else {
            this.field_6201.method_6277(6, wanderAroundFarGoal);
        }
        if (this.isStationary()) {
            this.clampHeadYaw(this);
        }
        if (this.isSitting() && this.method_5799()) {
            this.setStanding();
        }
    }

    @Override
    protected class_3414 method_5994() {
        return class_3417.field_40072;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_40077;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_40075;
    }

    public boolean canChangePose() {
        return this.method_20233(this.isSitting() ? class_4050.field_18076 : class_4050.field_40118);
    }

    @Override
    protected void method_6074(class_1282 source, float amount) {
        this.setStanding();
        super.method_6074(source, amount);
    }

    private double getPassengerAttachmentY(float tickDelta, @NotNull class_4048 dimensions, float scaleFactor) {
        double d = dimensions.field_18068 - 0.375f * scaleFactor;
        float f = scaleFactor * 1.43f;
        float g = f - scaleFactor * 0.2f;
        float h = f - g;
        boolean bl = this.isChangingPose();
        boolean bl2 = this.isSitting();
        if (bl) {
            float k;
            int j;
            int i;
            i = bl2 ? 40 : 52;
            if (bl2) {
                j = 28;
                k = 0.5f;
            } else {
                j = 24;
                k = 0.6f;
            }
            float l = class_3532.method_15363((float)this.getLastPoseTickDelta() + tickDelta, 0.0f, (float)i);
            boolean bl3 = l < (float)j;
            float m = bl3 ? l / (float)j : (l - (float)j) / (float)(i - j);
            float n2 = f - k * g;
            d += bl2 ? (double)class_3532.method_16439(m, bl3 ? f : n2, bl3 ? n2 : h) : (double)class_3532.method_16439(m, bl3 ? h - f : h - n2, bl3 ? h - n2 : 0.0f);
        }
        if (bl2 && !bl) {
            d += h;
        }
        return d;
    }

    @Override
    public class_243 method_45321(float tickDelta) {
        class_4048 entityDimensions = this.method_18377(this.method_18376());
        float f = this.method_17825();
        return new class_243(0.0, this.getPassengerAttachmentY(tickDelta, entityDimensions, f) - (double)(0.2f * f), entityDimensions.field_18067 * 0.56f);
    }

    private void clampHeadYaw(@NotNull class_1297 entity) {
        float f = entity.method_5791();
        float g = class_3532.method_15393(this.field_6283 - f);
        float h = class_3532.method_15363(class_3532.method_15393(this.field_6283 - f), -(float) 30.0, (float) 30.0);
        float i = f + g - h;
        entity.method_5847(i);
    }

    @Override
    public int method_5986() {
        return 30;
    }

    public boolean isSitting() {
        return this.field_6011.method_12789(LAST_POSE_TICK) < 0L;
    }

    public boolean shouldUpdateSittingAnimations() {
        return this.getLastPoseTickDelta() < 0L != this.isSitting();
    }

    public boolean isChangingPose() {
        long l = this.getLastPoseTickDelta();
        return l < (long)(this.isSitting() ? 40 : 52);
    }

    private boolean shouldPlaySittingTransitionAnimation() {
        return this.isSitting() && this.getLastPoseTickDelta() < 40L && this.getLastPoseTickDelta() >= 0L;
    }

    public void startSitting() {
        if (!this.isSitting()) {
            this.method_5783(class_3417.field_40079, 1.0F, this.method_6017());
            this.method_18380(class_4050.field_40118);
            this.setLastPoseTick(-this.method_37908().method_8510());
        }
    }

    public void startStanding() {
        if (this.isSitting()) {
            this.method_5783(class_3417.field_40080, 1.0F, this.method_6017());
            this.method_18380(class_4050.field_18076);
            this.setLastPoseTick(this.method_37908().method_8510());
        }
    }

    public void setStanding() {
        this.method_18380(class_4050.field_18076);
        this.initLastPoseTick(this.method_37908().method_8510());
    }

    @VisibleForTesting
    public void setLastPoseTick(long lastPoseTick) {
        this.field_6011.method_12778(LAST_POSE_TICK, lastPoseTick);
    }

    private void initLastPoseTick(long time) {
        this.setLastPoseTick(Math.max(0L, time - 52L - 1L));
    }

    public long getLastPoseTickDelta() {
        return this.method_37908().method_8510() - Math.abs(this.field_6011.method_12789(LAST_POSE_TICK));
    }

    @Override
    protected class_1330 method_5963() {
        return new InfectedCamelBodyControl(this);
    }

    @Override
    protected void method_6142(float leashLength) {
        if (leashLength > 6.0f && this.isSitting() && !this.isChangingPose() && this.canChangePose()) {
            this.startStanding();
        }
    }

    public boolean isStationary() {
        return this.isSitting() || this.isChangingPose();
    }

    @Override
    protected void method_48565(float posDelta) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(posDelta * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    @Override
    protected void method_5712(class_2338 pos, @NotNull class_2680 state) {
        if (state.method_26231() == class_2498.field_11526) {
            this.method_5783(class_3417.field_40082, 1.0F, 1.0F);
        } else {
            this.method_5783(class_3417.field_40081, 1.0F, 1.0F);
        }
    }

    public static boolean canSpawn(class_1299<? extends InfectedEntity> type, @NotNull class_5425 world, class_3730 spawnReason, class_2338 pos, net.minecraft.class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && world.method_8320(pos.method_10074()).method_26164(class_3481.field_15466) && method_20679(world, pos, random) && method_20636(type, world, spawnReason, pos, random) && HerobrineSpawnHelper.canHerobrineSpawn() && HerobrineSpawnHelper.getStage() > 1;
    }

    class InfectedCamelMoveControl extends class_1335 {
        public InfectedCamelMoveControl() {
            super(InfectedCamelEntity.this);
        }

        @Override
        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378 && !InfectedCamelEntity.this.method_5934() && InfectedCamelEntity.this.isSitting() && !InfectedCamelEntity.this.isChangingPose() && InfectedCamelEntity.this.canChangePose()) {
                InfectedCamelEntity.this.startStanding();
            }
            super.method_6240();
        }
    }

    class InfectedCamelBodyControl extends class_1330 {
        public InfectedCamelBodyControl(InfectedCamelEntity camel) {
            super(camel);
        }

        @Override
        public void method_6224() {
            if (!InfectedCamelEntity.this.isStationary()) {
                super.method_6224();
            }
        }
    }
}