package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.items.ItemList;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public abstract class InfectedEntity extends class_1588 {
    private class_1299 conversionEntity;
    public InfectedEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public void method_5711(byte status) {
        super.method_5711(status);
        if (status == 16) {
            if (!this.method_5701()) {
                this.method_37908().method_8486(this.method_23317(), this.method_23320(), this.method_23321(), class_3417.field_15168, this.method_5634(), 1.0f + this.field_5974.method_43057(), this.field_5974.method_43057() * 0.7f + 0.3f, false);
            }
        }

    }

    public static boolean canSpawn(class_1299<? extends InfectedEntity> type, @NotNull class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && world.method_8320(pos.method_10074()).method_26164(class_3481.field_35567) && method_20679(world, pos, random) && method_20636(type, world, spawnReason, pos, random) && HerobrineSpawnHelper.canHerobrineSpawn() && HerobrineSpawnHelper.getStage() > 1;
    }

    public void convert() {
        this.method_37908().method_8421(this, (byte) 16);
        this.method_5706(ItemList.CURSED_DUST);
        class_1308 entity = this.method_29243(conversionEntity, false);
        assert entity != null;
        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
        entity.method_5943((class_5425) method_37908(), method_37908().method_8404(this.method_24515()), class_3730.field_16468, null, null);
    }

    @Override
    public void method_5773() {
        if(this.method_37908() instanceof class_3218) {
            if(!HerobrineSpawnHelper.canHerobrineSpawn()) {
                this.method_5650(class_5529.field_26999);
            }
        }
        super.method_5773();
    }

    @Override
    public boolean method_6121(class_1297 target) {
        boolean bl = super.method_6121(target);
        if (bl) {
            float f = this.method_37908().method_8404(this.method_24515()).method_5457();
            if (this.method_5809() && this.field_5974.method_43057() < f * 0.3f) {
                target.method_5639(2 * (int)f);
            }
        }
        return bl;
    }
    
    public class_1299 getConversionEntity() {
        return this.conversionEntity;
    }
    
    public void setConversionEntity(class_1299 entity) {
        this.conversionEntity = entity;
    }

    @Override
    public class_2960 method_5991() {
        return conversionEntity.method_16351();
    }

    @Override
    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        if (field_5974.method_43048(100) <= 20 * (lootingMultiplier + 1) && allowDrops) {
            this.method_5706(ItemList.CURSED_DUST);
        }
    }
}