package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.items.ItemList;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1422;
import net.minecraft.class_1425;
import net.minecraft.class_1427;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_1481;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4019;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6088;
import net.minecraft.class_6880;
import net.minecraft.class_7988;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import net.minecraft.entity.passive.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class InfectedFoxEntity extends InfectedEntity implements class_7988<class_4019.class_4039> {
    private static final class_2940<Integer> TYPE = class_2945.method_12791(InfectedFoxEntity.class, class_2943.field_13327);
    private static final class_2940<Byte> FOX_FLAGS = class_2945.method_12791(InfectedFoxEntity.class, class_2943.field_13319);
    private static final int WALKING_FLAG = 64;
    public static final int ROLLING_HEAD_FLAG = 8;
    private float headRollProgress;
    private float lastHeadRollProgress;
    float extraRollingHeight;
    float lastExtraRollingHeight;
    public InfectedFoxEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.setConversionEntity(class_1299.field_17943);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 1.0, false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1429.class, 10, false, false, entity -> entity instanceof class_1428 || entity instanceof class_1463));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1422.class, 20, false, false, entity -> entity instanceof class_1425));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1481.class, 10, false, false, class_1481.field_6921));
        this.field_6201.method_6277(3, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(5, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(6, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(7, new class_1394(this, 1.0));
        this.field_6201.method_6277(8, new class_1361(this, class_1543.class, 8.0f));
        this.field_6201.method_6277(9, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(11, new class_1361(this, class_1427.class, 8.0f));
        this.field_6201.method_6277(12, new class_1376(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 10.0)
                .method_26868(class_5134.field_23721, 2.0)
                .method_26868(class_5134.field_23717, 32.0)
                .method_26868(class_5134.field_23719, 0.3);
    }

    @Nullable
    @Override
    public class_1315 method_5943(@NotNull class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, class_2487 entityNbt) {
        class_6880<class_1959> registryEntry = world.method_23753(this.method_24515());
        class_4019.class_4039 type = class_4019.class_4039.method_18313(registryEntry);
        if (entityData instanceof class_4019.class_4027 foxData) {
            type = foxData.field_17977;
        } else {
            entityData = new class_4019.class_4027(type);
        }

        this.setVariant(type);

        this.method_5964(world.method_8409(), difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void convert() {
        this.method_37908().method_8421(this, (byte) 16);
        this.method_5706(ItemList.CURSED_DUST);
        class_1308 entity = this.method_29243(this.getConversionEntity(), false);
        assert entity != null;
        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
        entity.method_5943((class_5425) method_37908(), method_37908().method_8404(this.method_24515()), class_3730.field_16468, null, null);
        entity.method_6122(class_1268.field_5808, class_1799.field_8037);
        ((class_4019) entity).method_47844(this.method_47827());
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TYPE, 0);
        this.field_6011.method_12784(FOX_FLAGS, (byte)0);
    }

    @Override
    public void method_6007() {
        if (!this.method_37908().field_9236 && this.method_5805() && this.method_6034()) {
            class_1309 livingEntity = this.method_5968();
            if (livingEntity == null || !livingEntity.method_5805()) {
                this.setRollingHead(false);
            }
        }

        super.method_6007();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_6034()) {
            if (this.isWalking() && this.method_37908().field_9229.method_43057() < 0.2f) {
                class_2338 blockPos = this.method_24515();
                class_2680 blockState = this.method_37908().method_8320(blockPos);
                this.method_37908().method_20290(class_6088.field_31144, blockPos, class_2248.method_9507(blockState));
            }
        }

        this.lastHeadRollProgress = this.headRollProgress;
        if (this.isRollingHead()) {
            this.headRollProgress = this.headRollProgress + (1.0F - this.headRollProgress) * 0.4f;
        } else {
            this.headRollProgress = this.headRollProgress + (0.0F - this.headRollProgress) * 0.4f;
        }

        this.lastExtraRollingHeight = this.extraRollingHeight;
        if (this.method_18276()) {
            this.extraRollingHeight += 0.2f;
            if (this.extraRollingHeight > 3.0f) {
                this.extraRollingHeight = 3.0f;
            }
        } else {
            this.extraRollingHeight = 0.0f;
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Type", this.method_47827().method_15434());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(class_4019.class_4039.method_18314(nbt.method_10558("Type")));
    }

    public void setRollingHead(boolean rollingHead) {
        this.setFoxFlag(rollingHead);
    }

    public boolean isRollingHead() {
        return this.getFoxFlag(ROLLING_HEAD_FLAG);
    }

    public boolean isWalking() {
        return this.getFoxFlag(WALKING_FLAG);
    }

    private void setFoxFlag(boolean value) {
        if (value) {
            this.field_6011.method_12778(FOX_FLAGS, (byte)(this.field_6011.method_12789(FOX_FLAGS) | InfectedFoxEntity.ROLLING_HEAD_FLAG));
        } else {
            this.field_6011.method_12778(FOX_FLAGS, (byte)(this.field_6011.method_12789(FOX_FLAGS) & ~InfectedFoxEntity.ROLLING_HEAD_FLAG));
        }
    }

    private boolean getFoxFlag(int bitmask) {
        return (this.field_6011.method_12789(FOX_FLAGS) & bitmask) != 0;
    }

    public float getHeadRoll(float tickDelta) {
        return class_3532.method_16439(tickDelta, this.lastHeadRollProgress, this.headRollProgress) * 0.11F * (float) Math.PI;
    }

    @Override
    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent == class_3417.field_18265) {
            this.method_5783(soundEvent, 2.0F, this.method_6017());
        } else {
            super.method_5966();
        }
    }

    @Nullable
    @Override
    protected class_3414 method_5994() {
        if (!this.method_37908().method_8530() && this.field_5974.method_43057() < 0.1F) {
            List<class_1657> list = this.method_37908().method_8390(class_1657.class, this.method_5829().method_1009(16.0, 16.0, 16.0), class_1301.field_6155);
            if (list.isEmpty()) {
                return class_3417.field_18265;
            }
        }
        return class_3417.field_18056;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_18061;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_18059;
    }

    public class_4019.class_4039 method_47827() {
        return class_4019.class_4039.method_18311(this.field_6011.method_12789(TYPE));
    }

    public void setVariant(class_4019.@NotNull class_4039 type) {
        this.field_6011.method_12778(TYPE, type.method_18317());
    }
}
