package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.items.ItemList;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1501;
import net.minecraft.class_1543;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.IntFunction;

public class InfectedLlamaEntity extends InfectedEntity implements class_1603 {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(InfectedLlamaEntity.class, class_2943.field_13327);
    boolean spit;

    public InfectedLlamaEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.setConversionEntity(class_1299.field_6074);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1381(this, 1.25, 40, 20.0f));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(5, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(6, new class_1394(this, 0.45));
        this.field_6201.method_6277(7, new class_1361(this, class_1543.class, 8.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1427.class, 8.0f));
        this.field_6201.method_6277(11, new class_1376(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 25.0)
                .method_26868(class_5134.field_23717, 16.0)
                .method_26868(class_5134.field_23719, 0.3);
    }

    @Override
    public void convert() {
        this.method_37908().method_8421(this, (byte) 16);
        this.method_5706(ItemList.CURSED_DUST);
        class_1308 entity = this.method_29243(this.getConversionEntity(), false);
        assert entity != null;
        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
        entity.method_5943((class_5425) this.method_37908(), this.method_37908().method_8404(this.method_24515()), class_3730.field_16468, null, null);
        ((class_1501) entity).method_47874(class_1501.class_7993.method_47876(this.getVariant().id));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, 0);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().id);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(InfectedLlamaEntity.Variant.byId(nbt.method_10550("Variant")));
    }

    @Override
    protected float method_18394(class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.95f;
    }

    @Nullable
    @Override
    public class_1315 method_5943(@NotNull class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_5819 random = world.method_8409();
        InfectedLlamaEntity.Variant variant;
        if (entityData instanceof InfectedLlamaEntity.LlamaData) {
            variant = ((InfectedLlamaEntity.LlamaData)entityData).variant;
        } else {
            variant = class_156.method_27173(Variant.values(), random);
            entityData = new InfectedLlamaEntity.LlamaData(variant);
        }

        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public InfectedLlamaEntity.Variant getVariant() {
        return InfectedLlamaEntity.Variant.byId(this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(InfectedLlamaEntity.@NotNull Variant variant) {
        this.field_6011.method_12778(VARIANT, variant.id);
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        this.spitAt(target);
    }

    private void spitAt(@NotNull class_1309 target) {
        InfectedLlamaSpitEntity llamaSpitEntity = new InfectedLlamaSpitEntity(this.method_37908(), this);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - llamaSpitEntity.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = Math.sqrt(d * d + f * f) * (double)0.2f;
        llamaSpitEntity.method_7485(d, e + g, f, 1.5f, 10.0f);
        if (!this.method_5701()) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14789, this.method_5634(), 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        this.method_37908().method_8649(llamaSpitEntity);
        this.spit = true;
    }

    @Override
    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        int i = this.method_23329(fallDistance, damageMultiplier);
        if (i <= 0) {
            return false;
        }
        if (fallDistance >= 6.0f) {
            this.method_5643(damageSource, i);
        }
        this.method_23328();
        return true;
    }

    public enum Variant implements class_3542 {
        CREAMY(0, "creamy"),
        WHITE(1, "white"),
        BROWN(2, "brown"),
        GRAY(3, "gray");
        private static final IntFunction<InfectedLlamaEntity.Variant> BY_ID = class_7995.method_47914(InfectedLlamaEntity.Variant::getIndex, values(), class_7995.class_7996.field_41666);
        final int id;
        private final String name;

        Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getIndex() {
            return this.id;
        }

        public static InfectedLlamaEntity.Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }
    }

    @Override
    protected class_3414 method_5994() {
        return class_3417.field_14682;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15031;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_15189;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14795, 0.15f, 1.0f);
    }

    static class LlamaData extends class_1296.class_4697 {
        public final InfectedLlamaEntity.Variant variant;
        LlamaData(InfectedLlamaEntity.Variant variant) {
            super(false);
            this.variant = variant;
        }
    }
}