package com.herobrinemod.herobrine.entities;

import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6024;
import net.minecraft.entity.ai.goal.*;
import org.jetbrains.annotations.NotNull;

public class InfectedWolfEntity extends InfectedEntity {
    private boolean furWet;
    private boolean canShakeWaterOff;
    private float shakeProgress;
    private float lastShakeProgress;
    public InfectedWolfEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.setConversionEntity(class_1299.field_6055);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 1.0, false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(5, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(6, new class_1394(this, 1.0));
        this.field_6201.method_6277(7, new class_1361(this, class_1543.class, 8.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1427.class, 8.0f));
        this.field_6201.method_6277(11, new class_1376(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 8.0)
                .method_26868(class_5134.field_23721, 4.0)
                .method_26868(class_5134.field_23717, 16.0)
                .method_26868(class_5134.field_23719, 0.3);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.furWet && !this.canShakeWaterOff && !this.method_6150() && this.method_24828()) {
            this.canShakeWaterOff = true;
            this.shakeProgress = 0.0f;
            this.lastShakeProgress = 0.0f;
            this.method_37908().method_8421(this, class_6024.field_30033);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_5805()) {
            return;
        }

        if (this.method_5637()) {
            this.furWet = true;
            if (this.canShakeWaterOff && !this.method_37908().field_9236) {
                this.method_37908().method_8421(this, class_6024.field_30025);
                this.resetShake();
            }
        } else if ((this.furWet) && this.canShakeWaterOff) {
            if (this.shakeProgress == 0.0f) {
                this.method_5783(class_3417.field_15042, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                this.method_32876(class_5712.field_28180);
            }

            this.lastShakeProgress = this.shakeProgress;
            this.shakeProgress += 0.05f;

            if (this.lastShakeProgress >= 2.0f) {
                this.furWet = false;
                this.canShakeWaterOff = false;
                this.lastShakeProgress = 0.0f;
                this.shakeProgress = 0.0f;
            }

            if (this.shakeProgress > 0.4f) {
                float f = (float)this.method_23318();
                int i = (int)(class_3532.method_15374((this.shakeProgress - 0.4f) * (float)Math.PI) * 7.0f);
                class_243 vec3d = this.method_18798();
                for (int j = 0; j < i; ++j) {
                    float g = (this.field_5974.method_43057() * 2.0f - 1.0f) * this.method_17681() * 0.5f;
                    float h = (this.field_5974.method_43057() * 2.0f - 1.0f) * this.method_17681() * 0.5f;
                    this.method_37908().method_8406(class_2398.field_11202, this.method_23317() + (double)g, f + 0.8f, this.method_23321() + (double)h, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                }
            }
        }
    }

    private void resetShake() {
        this.canShakeWaterOff = false;
        this.shakeProgress = 0.0f;
        this.lastShakeProgress = 0.0f;
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        this.furWet = false;
        this.canShakeWaterOff = false;
        this.lastShakeProgress = 0.0f;
        this.shakeProgress = 0.0f;
        super.method_6078(damageSource);
    }

    public boolean isFurWet() {
        return this.furWet;
    }

    public float getFurWetBrightnessMultiplier(float tickDelta) {
        return Math.min(0.5f + class_3532.method_16439(tickDelta, this.lastShakeProgress, this.shakeProgress) / 2.0f * 0.5f, 1.0f);
    }

    public float getShakeAnimationProgress(float tickDelta, float f) {
        float g = (class_3532.method_16439(tickDelta, this.lastShakeProgress, this.shakeProgress) + f) / 1.8f;
        if (g < 0.0f) {
            g = 0.0f;
        } else if (g > 1.0f) {
            g = 1.0f;
        }

        return class_3532.method_15374(g * (float)Math.PI) * class_3532.method_15374(g * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    @Override
    public void method_5711(byte status) {
        if (status == class_6024.field_30033) {
            this.canShakeWaterOff = true;
            this.shakeProgress = 0.0f;
            this.lastShakeProgress = 0.0f;
        } else if (status == class_6024.field_30025) {
            this.resetShake();
        } else {
            super.method_5711(status);
        }
    }

    @Override
    protected class_3414 method_5994() {
        return class_3417.field_14724;
    }

    @Override
    protected float method_18394(class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.8f;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15218;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_14659;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14772, 0.15f, 1.0f);
    }
}