package com.herobrinemod.herobrine.mixin;

import com.herobrinemod.herobrine.items.ItemList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3859;
import net.minecraft.class_3956;

@Mixin(class_2248.class)
public abstract class BlockMixin {
    @Inject(method = "getDroppedStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Ljava/util/List;", at = @At("RETURN"), cancellable = true)
    private static void cursedDiamondToolLootTableFunctions(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, @Nullable class_1297 entity, @NotNull class_1799 stack, @NotNull CallbackInfoReturnable<List<class_1799>> cir) {
        if (stack.method_7909() == ItemList.CURSED_DIAMOND_PICKAXE && stack.method_7909().method_7856(state)) {
            List<class_1799> returnValue = cir.getReturnValue();
            for (class_1799 itemStack : returnValue) {
                Optional<class_3859> recipe = world.method_8433().method_8132(class_3956.field_17547, new class_1277(itemStack), world);
                if (recipe.isPresent()) {
                    List<class_1799> drops = new ArrayList<>();
                    class_1799 smeltedStack = recipe.get().method_8110(world.method_30349());
                    smeltedStack.method_7939(itemStack.method_7947());
                    drops.add(smeltedStack);
                    cir.setReturnValue(drops);
                }
            }
        }

        if (stack.method_7909() == ItemList.CURSED_DIAMOND_SHOVEL && stack.method_7909().method_7856(state)) {
            List<class_1799> drops = new ArrayList<>();
            class_1799 newStack = state.method_26204().method_8389().method_7854();
            drops.add(newStack);
            cir.setReturnValue(drops);
        }
    }
}