package com.herobrinemod.herobrine.mixin;

import com.herobrinemod.herobrine.savedata.SaveDataHandler;
import net.minecraft.class_128;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_128.class)
public class CrashReportMixin {
    @Inject(method = "create", at = @At("HEAD"))
    private static void saveDataOnCrash(Throwable cause, String title, CallbackInfoReturnable<class_128> cir) {
        if(SaveDataHandler.getHerobrineSaveData() != null) {
            if(SaveDataHandler.getHerobrineSaveData().isDirty()) {
                SaveDataHandler.getHerobrineSaveData().saveFile();
            }
        }
    }
}
