package com.herobrinemod.herobrine.mixin;

import com.herobrinemod.herobrine.savedata.ConfigHandler;
import com.herobrinemod.herobrine.worldgen.BiomeKeyList;
import com.mojang.datafixers.util.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;

@Mixin(class_6554.class)
public abstract class VanillaBiomeParametersMixin {
    @Shadow
    protected abstract void writeBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome);

    @Inject(method = "writeLandBiomes", at = @At("TAIL"))
    private void writeCursedForest(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, CallbackInfo ci) {
        writeBiomeParameters(parameters, class_6544.class_6546.method_38121(-0.45f, 0.55f), class_6544.class_6546.method_38121(-0.1f, 0.1f), class_6544.class_6546.method_38121(-0.19f, 1.0f), class_6544.class_6546.method_38121(-0.7799f, 0.55f), class_6544.class_6546.method_38121(ConfigHandler.getHerobrineConfig().readFloat("CursedForestWeirdnessMin"), ConfigHandler.getHerobrineConfig().readFloat("CursedForestWeirdnessMax")), 0.0f, BiomeKeyList.CURSED_FOREST);
    }
}