/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api;

import de.z0rdak.yawp.core.flag.FlagTag;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public final class FlagTagRegister {
    private static final Map<ResourceLocation, FlagTag> REGISTRY = new ConcurrentHashMap<ResourceLocation, FlagTag>();
    public static final FlagTag PLAYER = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"player"), "Flags that evaluate per-player context or directly affect player actions. Examples: BREAK_BLOCKS, PLACE_BLOCKS, USE_ITEM, etc."));
    public static final FlagTag BENEFICIAL = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"beneficial"), "Flags granting advantages or permissions to players. Denying these feels wrong from a player perspective. Usually combined with PLAYER. Examples: INVINCIBLE, KEEP_INV, KEEP_XP."));
    public static final FlagTag PLAYER_PREVENTION = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"prevention"), "Flags that actively block or prevent a player\u2019s attempted action. Always implies PLAYER. Examples: BREAK_BLOCKS, PLACE_BLOCKS, USE_ITEM."));
    public static final FlagTag BLOCK = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"block"), "Flags concerning block-based events or world state. Examples: FIRE_SPREAD, TNT_EXPLODE, BLOCK_BREAK."));
    public static final FlagTag ITEM = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"item"), "Flags tied to item actions or mechanics. Examples: USE_ITEM, DROP_ITEM, PICKUP_ITEM. Often combined with PLAYER."));
    public static final FlagTag ENTITY = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"entity"), "Flags involving entities as targets or sources. Examples: INTERACT_ENTITY."));
    public static final FlagTag ENVIRONMENT = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"environment"), "Flags controlling world-level effects or non-entity mechanics. Examples: FIRE_TICK, LEAF_DECAY, FLUID_FLOW, ICE_MELT."));
    public static final FlagTag HIGH_FREQUENCY = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"high-frequency"), "Flags checked repeatedly per n-ticks, usually for movement or environment updates. Examples: MOVE, FIRE_TICK, FLUID_FLOW."));
    public static final FlagTag PROTECTION = FlagTagRegister.register(new FlagTag(ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)"protection"), "Flags defining preventive or defensive behavior rather than granting permissions. Examples: BLOCK_EXPLODE, griefing."));

    public static FlagTag register(FlagTag tag) {
        REGISTRY.put(tag.tagRl(), tag);
        return tag;
    }

    public static FlagTag from(ResourceLocation rl) throws IllegalArgumentException {
        FlagTag tag = REGISTRY.get(rl);
        if (tag == null) {
            throw new IllegalArgumentException("Invalid flag tag: " + String.valueOf(rl));
        }
        return tag;
    }

    public static Collection<FlagTag> getAll() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }
}

