/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.flag.FlagEvent;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.flag.IFlagArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.FlagType;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.MojangApiHelper;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.pagination.ChildRegionPagination;
import de.z0rdak.yawp.util.text.messages.pagination.GroupMemberPagination;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.RegionFlagPagination;
import de.z0rdak.yawp.util.text.messages.pagination.ResponsibleFlagPagination;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;
import org.apache.commons.lang3.StringUtils;

public class CommandUtil {
    public static LiteralArgumentBuilder<CommandSourceStack> buildClearSubCommand(Function<CommandContext<CommandSourceStack>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.CLEAR).then(ArgumentUtil.literal(CommandConstants.FLAGS).executes(ctx -> CommandUtil.clearFlags((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.PLAYERS).executes(ctx -> CommandUtil.clearPlayers((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx)))).then(Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.clearPlayers((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.TEAMS).executes(ctx -> CommandUtil.clearTeams((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx)))).then(Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.clearTeams((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.GROUP).then(Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.clearGroups((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> buildRemoveSubCommand(Function<CommandContext<CommandSourceStack>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.REMOVE).then(ArgumentUtil.literal(CommandConstants.PLAYER).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(Commands.argument((String)CommandConstants.PLAYER.toString(), (ArgumentType)EntityArgument.players()).executes(ctx -> CommandUtil.removePlayers((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getPlayersArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx))))).then(ArgumentUtil.literal(CommandConstants.BY_UUID).then(Commands.argument((String)CommandConstants.PLAYER_UUID.toString(), (ArgumentType)UuidArgument.uuid()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((Iterable)((IProtectedRegion)regionSupplier.apply(ctx)).getGroup(ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)).getPlayers().keySet().stream().map(UUID::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.removePlayerByUUID((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getPlayerUUIDArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.BY_NAME).then(Commands.argument((String)CommandConstants.PLAYER_NAMES.toString(), (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(((IProtectedRegion)regionSupplier.apply(ctx)).getGroup(ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)).getPlayers().values(), (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.removePlayersByName((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getPlayerNamesArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.TEAM).then(Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(Commands.argument((String)CommandConstants.TEAM.toString(), (ArgumentType)TeamArgument.team()).executes(ctx -> CommandUtil.removeTeam((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getTeamArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.FLAG).then(Commands.argument((String)CommandConstants.FLAG.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.removeRegionFlag((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.FLAGS).then(Commands.argument((String)CommandConstants.FLAGS.toString(), (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.removeFlags((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArguments((CommandContext<CommandSourceStack>)ctx)))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> buildAddSubCommand(Function<CommandContext<CommandSourceStack>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ADD).then(ArgumentUtil.literal(CommandConstants.PLAYER).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(Commands.argument((String)CommandConstants.PLAYER.toString(), (ArgumentType)EntityArgument.players()).executes(ctx -> CommandUtil.addPlayers((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getPlayersArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx))))).then(ArgumentUtil.literal(CommandConstants.BY_UUID).then(Commands.argument((String)CommandConstants.PLAYER_UUID.toString(), (ArgumentType)UuidArgument.uuid()).executes(ctx -> CommandUtil.addPlayerByUuid((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getPlayerUUIDArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.BY_NAME).then(Commands.argument((String)CommandConstants.PLAYER_NAMES.toString(), (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandUtil.addPlayersByName((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getPlayerNamesArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.TEAM).then(Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(Commands.argument((String)CommandConstants.TEAM.toString(), (ArgumentType)TeamArgument.team()).executes(ctx -> CommandUtil.addTeam((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getTeamArgument((CommandContext<CommandSourceStack>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.FLAG).then(((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.FLAG.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.addFlag((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArgument((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)CommandConstants.STATE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(FlagState.ValidFlagStates(), (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.addFlag((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getFlagStateArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.FLAGS).then(Commands.argument((String)CommandConstants.FLAGS.toString(), (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.addFlags((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArguments((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.ALL_FLAGS).executes(ctx -> CommandUtil.addAllFlags((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> buildListSubCommand(Function<CommandContext<CommandSourceStack>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.LIST).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.CHILDREN).executes(ctx -> CommandUtil.promptRegionChildren((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), 0))).then(Commands.argument((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptRegionChildren((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getPageNoArgument((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.FLAG).executes(ctx -> CommandUtil.promptFlagList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), 0))).then(Commands.argument((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptFlagList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getPageNoArgument((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.REGION_FLAG).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), 0))).then(Commands.argument((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getPageNoArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.GROUP).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.promptGroupLinks((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.TEAM).executes(ctx -> CommandUtil.promptGroupList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx), GroupType.TEAM, 0))).then(Commands.argument((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptGroupList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx), GroupType.TEAM, ArgumentUtil.getPageNoArgument((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.PLAYER).executes(ctx -> CommandUtil.promptGroupList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx), GroupType.PLAYER, 0))).then(Commands.argument((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptGroupList((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx), GroupType.PLAYER, ArgumentUtil.getPageNoArgument((CommandContext<CommandSourceStack>)ctx)))))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> buildCopySubCommand(Function<CommandContext<CommandSourceStack>, IProtectedRegion> srcSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.COPY).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.FLAGS).then(ArgumentUtil.literal(CommandConstants.TO_LOCAL).then(Commands.argument((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)CommandConstants.TARGET_REGION.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listRegionsInTargetDim(ctx, builder)).executes(ctx -> CommandUtil.copyRegionFlags((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetLocalRegionArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.TO_DIM).then(Commands.argument((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)DimensionArgument.dimension()).executes(ctx -> CommandUtil.copyRegionFlags((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetDimRegionArgument((CommandContext<CommandSourceStack>)ctx).getDim())))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.PLAYERS).then(ArgumentUtil.literal(CommandConstants.TO_LOCAL).then(Commands.argument((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)CommandConstants.TARGET_REGION.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listRegionsInTargetDim(ctx, builder)).then(Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.copyRegionPlayers((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetLocalRegionArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.TO_DIM).then(Commands.argument((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.copyRegionPlayers((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetDimRegionArgument((CommandContext<CommandSourceStack>)ctx).getDim(), ArgumentUtil.getGroupArgument((CommandContext<CommandSourceStack>)ctx)))))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.STATE).then(ArgumentUtil.literal(CommandConstants.TO_LOCAL).then(Commands.argument((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)CommandConstants.TARGET_REGION.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listRegionsInTargetDim(ctx, builder)).executes(ctx -> CommandUtil.copyRegionState((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetLocalRegionArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.TO_DIM).then(Commands.argument((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)DimensionArgument.dimension()).executes(ctx -> CommandUtil.copyRegionState((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetDimRegionArgument((CommandContext<CommandSourceStack>)ctx).getDim())))));
    }

    public static int promptRegionInfo(CommandContext<CommandSourceStack> ctx, IProtectedRegion region) {
        MultiLineMessage.send((CommandSourceStack)ctx.getSource(), MultiLineMessage.regionInfo(region));
        return 0;
    }

    public static int promptRegionState(CommandContext<CommandSourceStack> ctx, IProtectedRegion region) {
        MultiLineMessage.send((CommandSourceStack)ctx.getSource(), MultiLineMessage.regionState(region));
        return 0;
    }

    public static int promptGroupLinks(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.region.info.group.invalid", (String)"cli.msg.region.info.group.invalid", (Object[])new Object[]{group}).withStyle(ChatFormatting.RED));
            return -1;
        }
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), ChatComponentBuilder.buildGroupListHeader(region, group));
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), ChatLinkBuilder.buildGroupPlayerListLink(region, group));
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), ChatLinkBuilder.buildGroupTeamListLink(region, group));
        return 0;
    }

    public static int promptFlagList(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, int pageNo) {
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            ResponsibleFlagPagination flagPagination = new ResponsibleFlagPagination(region, pageNo, paginationSize);
            MultiLineMessage.send((CommandSourceStack)ctx.getSource(), flagPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int promptRegionFlagList(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, int pageNo) {
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            RegionFlagPagination flagPagination = new RegionFlagPagination(region, pageNo, paginationSize);
            MultiLineMessage.send((CommandSourceStack)ctx.getSource(), flagPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int promptRegionChildren(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, int pageNo) {
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            ChildRegionPagination childRegionPagination = new ChildRegionPagination(region, region.getChildren().values().stream().toList(), pageNo, paginationSize);
            MultiLineMessage.send((CommandSourceStack)ctx.getSource(), childRegionPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int promptGroupList(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, String group, GroupType groupType, int pageNo) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        List<String> groupNames = ChatComponentBuilder.getGroupList(region, group, groupType);
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            GroupMemberPagination childRegionPagination = new GroupMemberPagination(region, group, groupType, groupNames, pageNo, paginationSize);
            MultiLineMessage.send((CommandSourceStack)ctx.getSource(), childRegionPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int setActiveState(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, boolean activate) {
        region.setIsActive(activate);
        RegionManager.get().save();
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!activate), String.valueOf(activate));
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.state.enable.set.value", (String)"Region state of %s is now: %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), region.isActive() ? "active" : "inactive"});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
        return 0;
    }

    public static int setAlertState(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, boolean showAlert) {
        region.setIsMuted(!showAlert);
        RegionManager.get().save();
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!showAlert), String.valueOf(showAlert));
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.state.alert.set.value", (String)"Flag messages of %s are now: %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), region.isMuted() ? "muted" : "active"});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
        return 0;
    }

    private static MutableComponent buildInvalidGroupMsg(String group) {
        return Component.translatableWithFallback((String)"cli.msg.region.info.group.invalid", (String)"Group '%s' is not defined!", (Object[])new Object[]{group});
    }

    public static int removeTeam(CommandContext<CommandSourceStack> ctx, Team team, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.REMOVE, CommandConstants.ADD);
        MutableComponent teamInfo = ChatComponentBuilder.buildGroupInfo(region, team.getName(), GroupType.TEAM);
        if (region.getGroup(group).hasTeam(team.getName())) {
            region.removeTeam(team.getName(), group);
            RegionManager.get().save();
            MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.team.removed", (String)"Removed team '%s' (group '%s') from %s", (Object[])new Object[]{teamInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.team.not-present", (String)"Team '%s' (group '%s') is not present in %s", (Object[])new Object[]{teamInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        return 1;
    }

    private static int removePlayersByName(CommandContext<CommandSourceStack> ctx, Collection<String> playerNames, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        playerNames.forEach(playerName -> CommandUtil.removePlayer(ctx, playerName, region, group));
        return 0;
    }

    private static void removePlayer(CommandContext<CommandSourceStack> ctx, String playerName, IProtectedRegion region, String group) {
        region.getGroup(group).getPlayers().entrySet().stream().filter(e -> ((String)e.getValue()).equals(playerName)).findFirst().ifPresent(e -> CommandUtil.removePlayer(ctx, (UUID)e.getKey(), playerName, region, group));
    }

    private static int removePlayerByUUID(CommandContext<CommandSourceStack> ctx, UUID playerUuid, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        if (region.getGroup(group).hasPlayer(playerUuid)) {
            String playerName = region.getGroup(group).getPlayers().get(playerUuid);
            return CommandUtil.removePlayer(ctx, playerUuid, playerName, region, group);
        }
        return 1;
    }

    private static int removePlayers(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, IProtectedRegion region, String group) {
        players.forEach(player -> CommandUtil.removePlayer(ctx, (Player)player, region, group));
        return 0;
    }

    private static int removePlayer(CommandContext<CommandSourceStack> ctx, Player player, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        if (region.getGroup(group).hasPlayer(player.getUUID())) {
            String playerName = region.getGroup(group).getPlayers().get(player.getUUID());
            return CommandUtil.removePlayer(ctx, player.getUUID(), playerName, region, group);
        }
        return 1;
    }

    public static int removePlayer(CommandContext<CommandSourceStack> ctx, UUID playerUuid, String playerName, IProtectedRegion region, String group) {
        MutableComponent playerInfo = ChatComponentBuilder.buildGroupInfo(region, playerName, GroupType.PLAYER);
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.REMOVE, CommandConstants.ADD);
        if (region.getGroup(group).hasPlayer(playerUuid)) {
            region.removePlayer(playerUuid, group);
            MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.player.removed", (String)"Removed player '%s' (group '%s') from %s", (Object[])new Object[]{playerInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            RegionManager.get().save();
            return 0;
        }
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.player.not-present", (String)"Player '%s' (group '%s') is not present in %s", (Object[])new Object[]{playerInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        return 1;
    }

    private static int addPlayerByUuid(CommandContext<CommandSourceStack> ctx, UUID playerUuid, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        Optional<GameProfile> cachedProfile = MojangApiHelper.lookupGameProfileInCache(ctx, playerUuid);
        if (cachedProfile.isPresent()) {
            boolean isComplete;
            GameProfile profile = cachedProfile.get();
            boolean bl = isComplete = profile.id() != null && StringUtils.isNotBlank((CharSequence)profile.name());
            if (isComplete) {
                MutableComponent cacheSuccess = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.cache.success", (String)"Found entry for '%s' in the cache", (Object[])new Object[]{playerUuid.toString()});
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), cacheSuccess);
                return CommandUtil.addPlayer(ctx, profile.id(), profile.name(), region, group);
            }
            return -1;
        }
        MutableComponent cacheMiss = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.pending", (String)"No cache entry existing for '%s'. Looking up %s at Mojang...", (Object[])new Object[]{playerUuid.toString(), "uuid"});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), cacheMiss);
        CompletableFuture.runAsync(() -> MojangApiHelper.getGameProfileInfo(playerUuid, gameProfile -> {
            if (gameProfile != null) {
                MutableComponent lookupSuccess = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.api.success", (String)"Successfully retrieved game profile info for '%s' from Mojang", (Object[])new Object[]{playerUuid.toString()});
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), lookupSuccess);
                CommandUtil.addPlayer(ctx, gameProfile.id(), gameProfile.name(), region, group);
            } else {
                MutableComponent lookupFailed = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.api.failed", (String)"Unable to retrieve game profile info for '%s' from Mojang", (Object[])new Object[]{playerUuid.toString()});
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), lookupFailed);
            }
        }));
        return 0;
    }

    public static int addPlayersByName(CommandContext<CommandSourceStack> ctx, List<String> playerNames, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        playerNames.forEach(name -> CommandUtil.addPlayerByName(ctx, name, region, group));
        return 0;
    }

    private static int addPlayerByName(CommandContext<CommandSourceStack> ctx, String playerName, IProtectedRegion region, String group) {
        Optional<GameProfile> cachedProfile = MojangApiHelper.lookupGameProfileInCache(ctx, playerName);
        if (cachedProfile.isPresent()) {
            boolean isComplete;
            GameProfile profile = cachedProfile.get();
            boolean bl = isComplete = profile.id() != null && StringUtils.isNotBlank((CharSequence)profile.name());
            if (isComplete) {
                MutableComponent cacheSuccess = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.cache.success", (String)"Found entry for '%s' in the cache", (Object[])new Object[]{playerName});
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), cacheSuccess);
                return CommandUtil.addPlayer(ctx, profile.id(), profile.name(), region, group);
            }
            return -1;
        }
        MutableComponent cacheMiss = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.pending", (String)"No cache entry existing for '%s'. Looking up %s at Mojang...", (Object[])new Object[]{playerName, "name"});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), cacheMiss);
        CompletableFuture.runAsync(() -> MojangApiHelper.getGameProfileInfo(playerName, gameProfile -> {
            if (gameProfile != null) {
                MutableComponent lookupSuccess = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.api.success", (String)"Successfully retrieved game profile info for '%s' from Mojang", (Object[])new Object[]{playerName});
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), lookupSuccess);
                CommandUtil.addPlayer(ctx, gameProfile.id(), gameProfile.name(), region, group);
            } else {
                MutableComponent lookupFailed = Component.translatableWithFallback((String)"cli.msg.info.player.lookup.api.failed", (String)"Unable to retrieve game profile info for '%s' from Mojang", (Object[])new Object[]{playerName});
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), lookupFailed);
            }
        }));
        return 0;
    }

    public static int addPlayers(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, IProtectedRegion region, String group) {
        players.forEach(player -> CommandUtil.addPlayer(ctx, (Player)player, region, group));
        return 0;
    }

    public static int addPlayer(CommandContext<CommandSourceStack> ctx, Player player, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        return CommandUtil.addPlayer(ctx, player.getUUID(), player.getScoreboardName(), region, group);
    }

    private static int addPlayer(CommandContext<CommandSourceStack> ctx, UUID uuid, String name, IProtectedRegion region, String group) {
        MutableComponent regionInfoLink = ChatLinkBuilder.buildRegionInfoLink(region);
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.ADD, CommandConstants.REMOVE);
        if (!region.hasPlayer(uuid, group)) {
            region.addPlayer(uuid, name, group);
            RegionManager.get().save();
            MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.player.added", (String)"Added player '%s' as '%s' to %s", (Object[])new Object[]{name, group, regionInfoLink});
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.player.present", (String)"Player '%s' (group '%s') already present in %s", (Object[])new Object[]{name, group, regionInfoLink});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        return 1;
    }

    public static int addTeam(CommandContext<CommandSourceStack> ctx, Team team, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        MutableComponent regionInfoLink = ChatLinkBuilder.buildRegionInfoLink(region);
        MutableComponent teamHoverInfo = ChatComponentBuilder.buildTeamHoverComponent(team);
        if (!region.hasTeam(team.getName(), group)) {
            region.addTeam(team.getName(), group);
            RegionManager.get().save();
            MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.ADD, CommandConstants.REMOVE);
            MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.team.added", (String)"Added team '%s' as '%s' to region %s", (Object[])new Object[]{teamHoverInfo, group, regionInfoLink});
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.info.region.group.team.present", (String)"Team '%s' (group '%s') already present in %s", (Object[])new Object[]{teamHoverInfo, group, regionInfoLink});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        return 1;
    }

    public static int removeFlags(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, Set<RegionFlag> flags) {
        flags.forEach(flag -> CommandUtil.removeRegionFlag(ctx, region, flag));
        return 0;
    }

    public static int removeRegionFlag(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, RegionFlag flag) {
        if (region.containsFlag(flag)) {
            IFlag iFlag = region.getFlag(flag.name);
            FlagEvent.RemoveFlagEvent removeFlagEvent = new FlagEvent.RemoveFlagEvent((CommandSourceStack)ctx.getSource(), region, iFlag);
            Services.EVENT.post(removeFlagEvent);
            region.removeFlag(flag.name);
            RegionManager.get().save();
            MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.flag.removed", (String)"Removed flag '%s' from %s", (Object[])new Object[]{flag.name, ChatLinkBuilder.buildRegionInfoLink(region)});
            MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.REMOVE, CommandConstants.ADD);
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.flag.not-present", (String)"Flag '%s' is not present in %s", (Object[])new Object[]{flag.name, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        return 1;
    }

    public static int copyRegionFlags(CommandContext<CommandSourceStack> ctx, IProtectedRegion srcRegion, IProtectedRegion targetRegion) {
        if (srcRegion.getFlags().isEmpty()) {
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.flag.empty", (String)"No flags defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(srcRegion)}));
            return 1;
        }
        Set flagsToCopy = srcRegion.getFlags().flags().stream().filter(flag -> !targetRegion.containsFlag(flag.getName())).collect(Collectors.toSet());
        srcRegion.getFlags().flags().forEach(targetRegion::addFlag);
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.copy.region.flags", (String)"Copied %s flag(s) from region %s to %s", (Object[])new Object[]{flagsToCopy.size(), ChatLinkBuilder.buildRegionInfoLink(srcRegion), ChatLinkBuilder.buildRegionInfoLink(targetRegion)}));
        return 0;
    }

    public static int copyRegionState(CommandContext<CommandSourceStack> ctx, IProtectedRegion srcRegion, IProtectedRegion targetRegion) {
        targetRegion.setIsActive(srcRegion.isActive());
        targetRegion.setIsMuted(srcRegion.isMuted());
        if (srcRegion instanceof IMarkableRegion) {
            IMarkableRegion regionSource = (IMarkableRegion)srcRegion;
            if (targetRegion instanceof IMarkableRegion) {
                IMarkableRegion regionTarget = (IMarkableRegion)targetRegion;
                regionTarget.setPriority(regionSource.getPriority());
            }
        }
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.copy.region.state", (String)"Copied state from region %s to %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(srcRegion), ChatLinkBuilder.buildRegionInfoLink(targetRegion)}));
        return 0;
    }

    public static int copyRegionPlayers(CommandContext<CommandSourceStack> ctx, IProtectedRegion srcRegion, IProtectedRegion targetRegion, String group) {
        if (!srcRegion.getGroup(group).getPlayers().isEmpty()) {
            Set playerEntriesToCopy = srcRegion.getGroup(group).getPlayers().entrySet().stream().filter(entry -> !targetRegion.getGroup(group).getPlayers().containsKey(entry.getKey())).collect(Collectors.toSet());
            srcRegion.getGroup(group).getPlayers().forEach((uuid, name) -> targetRegion.getGroup(group).addPlayer((UUID)uuid, (String)name));
            RegionManager.get().save();
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.copy.region.players", (String)"Copied %s player(s) of group '%s' from %s to %s", (Object[])new Object[]{playerEntriesToCopy.size(), group, ChatLinkBuilder.buildRegionInfoLink(srcRegion), ChatLinkBuilder.buildRegionInfoLink(targetRegion)}));
            return 0;
        }
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.group.player.empty", (String)"No players defined as '%s' in %s", (Object[])new Object[]{group, ChatLinkBuilder.buildRegionInfoLink(srcRegion)}));
        return 1;
    }

    public static int copyRegionPlayers(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IProtectedRegion srcRegion) {
        return CommandUtil.copyRegionPlayers(ctx, region, srcRegion, CommandConstants.MEMBER.toString()) + CommandUtil.copyRegionPlayers(ctx, region, srcRegion, CommandConstants.OWNER.toString());
    }

    public static int clearFlags(CommandContext<CommandSourceStack> ctx, IProtectedRegion region) {
        int amount = region.getFlags().size();
        if (amount == 0) {
            MutableComponent feedbackMsg = Component.translatableWithFallback((String)"cli.msg.info.region.flag.empty", (String)"No flags defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), feedbackMsg);
            return 1;
        }
        List<IFlag> flags = region.getFlags().flags();
        region.getFlags().clear();
        MutableComponent feedbackMsg = Component.translatableWithFallback((String)"cli.msg.info.region.flag.cleared", (String)"Removed %s flag(s) from %s", (Object[])new Object[]{amount, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), feedbackMsg);
        RegionManager.get().save();
        return 0;
    }

    public static int clearPlayers(CommandContext<CommandSourceStack> ctx, IProtectedRegion region) {
        return CommandUtil.clearPlayers(ctx, region, "members") + CommandUtil.clearPlayers(ctx, region, "owners");
    }

    public static int clearPlayers(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, String groupName) {
        int amount = region.getGroup(groupName).getPlayers().size();
        if (amount == 0) {
            MutableComponent feedbackMsg = Component.translatableWithFallback((String)"cli.msg.info.region.players.empty", (String)"No players (group '%s') present in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), groupName});
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), feedbackMsg);
            return 1;
        }
        region.getGroup(groupName).clearPlayers();
        MutableComponent feedbackMsg = Component.translatableWithFallback((String)"cli.msg.info.region.players.cleared", (String)"Cleared %s players of group '%s' for %s\",", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), amount, groupName});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), feedbackMsg);
        RegionManager.get().save();
        return 0;
    }

    public static int clearTeams(CommandContext<CommandSourceStack> ctx, IProtectedRegion region) {
        return CommandUtil.clearPlayers(ctx, region, "members") + CommandUtil.clearPlayers(ctx, region, "owners");
    }

    public static int clearTeams(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, String groupName) {
        int amount = region.getGroup(groupName).getTeams().size();
        if (amount == 0) {
            MutableComponent feedbackMsg = Component.translatableWithFallback((String)"cli.msg.info.region.teams.empty", (String)"No teams (group '%s') present in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), groupName});
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), feedbackMsg);
            return 1;
        }
        region.getGroup(groupName).clearTeams();
        MutableComponent feedbackMsg = Component.translatableWithFallback((String)"cli.msg.info.region.teams.cleared", (String)"Cleared %s teams of group '%s' for %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), amount, groupName});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), feedbackMsg);
        RegionManager.get().save();
        return 0;
    }

    public static int clearGroups(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, String groupName) {
        return CommandUtil.clearTeams(ctx, region, groupName) + CommandUtil.clearPlayers(ctx, region, groupName);
    }

    public static int addAllFlags(CommandContext<CommandSourceStack> ctx, IProtectedRegion region) {
        return CommandUtil.addFlags(ctx, region, RegionFlag.getFlags());
    }

    public static int addFlag(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, RegionFlag flag) {
        return CommandUtil.addFlag(ctx, region, flag, FlagState.DENIED);
    }

    public static int addFlag(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, RegionFlag flag, FlagState state) {
        return CommandUtil.addRegionFlag(ctx, region, flag, state);
    }

    public static int addFlags(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, Set<RegionFlag> flags) {
        flags.forEach(flag -> CommandUtil.addRegionFlag(ctx, region, flag));
        return 0;
    }

    public static int addRegionFlag(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, RegionFlag flag, FlagState state) {
        if (region.getRegionType() == RegionType.LOCAL && flag == RegionFlag.ENTER_DIM) {
            MutableComponent msg = Component.literal((String)"Flag 'enter-dim' is currently not supported for local regions.");
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
            return 1;
        }
        if (!region.containsFlag(flag)) {
            BooleanFlag iFlag = switch (flag.type) {
                case FlagType.BOOLEAN_FLAG -> new BooleanFlag(flag, state, false);
                default -> throw new IllegalArgumentException("Unexpected value = " + ((Object)((Object)flag)).getClass().getName());
            };
            FlagEvent.AddFlagEvent addFlagEvent = new FlagEvent.AddFlagEvent((CommandSourceStack)ctx.getSource(), region, iFlag);
            Services.EVENT.post(addFlagEvent);
            region.addFlag(iFlag);
            RegionManager.get().save();
            MutableComponent flagLink = ChatLinkBuilder.buildFlagInfoLink(region, iFlag);
            MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.flag.added", (String)"Added flag '%s' to %s", (Object[])new Object[]{flagLink, ChatLinkBuilder.buildRegionInfoLink(region)});
            MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.ADD, CommandConstants.REMOVE);
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        MutableComponent msg = Component.translatableWithFallback((String)"cli.msg.flag.present", (String)"Flag '%s' is already present in %s", (Object[])new Object[]{flag.name, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        return 1;
    }

    public static int addRegionFlag(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, RegionFlag flag) {
        return CommandUtil.addRegionFlag(ctx, region, flag, FlagState.DENIED);
    }
}

