/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.data.region;

import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.GlobalRegionData;
import de.z0rdak.yawp.data.region.LevelListData;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionDataManager {
    public static final Logger LOGGER = LogManager.getLogger((String)("yawp".toUpperCase(Locale.ROOT) + "-DataManager"));
    private static MinecraftServer serverInstance;
    private static LevelListData savedLevelData;
    private static GlobalRegionData globalRegionData;
    private static final Map<ResourceLocation, LevelRegionData> dimRegionStorage;

    public static LevelListData getSavedLevelData() {
        return savedLevelData;
    }

    public static Set<ResourceLocation> getLevels() {
        return new HashSet<ResourceLocation>(savedLevelData.getLevels());
    }

    public static boolean hasLevel(ResourceLocation level) {
        return savedLevelData.hasDimEntry(level);
    }

    public static Set<String> getLevelNames() {
        return RegionDataManager.getLevels().stream().map(ResourceLocation::toString).collect(Collectors.toSet());
    }

    public static GlobalRegionData getGlobalRegionData() {
        return globalRegionData;
    }

    public static GlobalRegion getGlobalRegion() {
        return RegionDataManager.getGlobalRegionData().getGlobal();
    }

    private RegionDataManager() {
    }

    public static void save() {
        RegionDataManager.save(true);
    }

    public static void save(boolean force) {
        if (force) {
            RegionDataManager.saveDimList(serverInstance);
            RegionDataManager.saveGlobalData(serverInstance);
            RegionDataManager.saveTrackedLevels(serverInstance);
        } else {
            savedLevelData.setDirty();
            globalRegionData.setDirty();
            dimRegionStorage.forEach((key, value) -> value.setDirty());
        }
    }

    public static LevelListData getSavedDims() {
        ServerLevel overworld;
        if (savedLevelData == null && serverInstance != null && !(overworld = serverInstance.overworld()).isClientSide()) {
            DimensionDataStorage storage = overworld.getDataStorage();
            savedLevelData = (LevelListData)storage.computeIfAbsent(LevelListData.TYPE);
        }
        return savedLevelData;
    }

    public static void onServerStarting(MinecraftServer server) {
        LOGGER.info(Component.translatableWithFallback((String)"data.region.init", (String)"Initializing RegionDataManager...").getString());
        serverInstance = server;
        RegionDataManager.checkYawpDir(server);
    }

    private static void saveTrackedLevels(MinecraftServer server) {
        server.getAllLevels().forEach(level -> {
            ResourceLocation levelRl = level.dimension().location();
            if (savedLevelData.hasDimEntry(levelRl)) {
                RegionDataManager.saveLevelData(server, (Level)level);
            }
        });
    }

    public static void save(MinecraftServer server, boolean flush, boolean force) {
        LOGGER.info(Component.translatableWithFallback((String)"data.region.levels.save.forced", (String)"Requested save. Saving region data for all levels").getString());
        if (serverInstance == null) {
            serverInstance = server;
        }
        RegionDataManager.save(force);
    }

    private static void saveDimList(MinecraftServer server) {
        DimensionDataStorage dataStorage = server.overworld().getDataStorage();
        dataStorage.set(LevelListData.TYPE, (SavedData)savedLevelData);
    }

    private static void saveGlobalData(MinecraftServer server) {
        DimensionDataStorage dataStorage = server.overworld().getDataStorage();
        dataStorage.set(GlobalRegionData.TYPE, (SavedData)globalRegionData);
    }

    private static void saveLevelData(MinecraftServer server, Level level) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        ResourceLocation levelRl = level.dimension().location();
        LevelRegionData levelRegionData = dimRegionStorage.get(levelRl);
        LOGGER.info(Component.translatableWithFallback((String)"data.region.level.save", (String)"Saving region data for level '%s'", (Object[])new Object[]{levelRl.toString()}).getString());
        storage.set(LevelRegionData.buildSavedDataType(levelRl), (SavedData)levelRegionData);
        levelRegionData.setDirty();
    }

    private static LevelRegionData loadLevelData(MinecraftServer server, Level level) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        ResourceLocation dimLoc = level.dimension().location();
        return (LevelRegionData)storage.get(LevelRegionData.buildSavedDataType(dimLoc));
    }

    public static void saveOnStop(MinecraftServer server) {
        if (serverInstance == null) {
            serverInstance = server;
        }
        LOGGER.info(Component.translatableWithFallback((String)"data.region.levels.save.stopped", (String)"Stopping server. Saving region data for all levels").getString());
        RegionDataManager.save(true);
    }

    public static void saveOnUnload(MinecraftServer server, ServerLevel level) {
        if (savedLevelData.hasDimEntry(level.dimension().location())) {
            LOGGER.info(Component.translatableWithFallback((String)"data.region.level.save.unload", (String)"Unloading level '%s'. Saving region data", (Object[])new Object[]{level.dimension().location().toString()}).getString());
            RegionDataManager.saveLevelData(server, (Level)level);
        }
    }

    public static void loadLevelListData(MinecraftServer server) {
        try {
            DimensionDataStorage dataStorage;
            if (serverInstance == null) {
                serverInstance = server;
            }
            if ((savedLevelData = (LevelListData)(dataStorage = server.overworld().getDataStorage()).get(LevelListData.TYPE)) == null) {
                LOGGER.info(Component.translatableWithFallback((String)"data.region.levels.load.missing", (String)"Missing level list for region data (ignore on first startup). Initializing...").getString());
                savedLevelData = new LevelListData();
                RegionDataManager.saveDimList(server);
            }
            LOGGER.info(Component.translatableWithFallback((String)"data.region.levels.load.success", (String)"Found region data for %s dimension(s)", (Object[])new Object[]{savedLevelData.getLevels().size()}).getString());
            globalRegionData = (GlobalRegionData)dataStorage.get(GlobalRegionData.TYPE);
            if (globalRegionData == null) {
                LOGGER.info(Component.translatableWithFallback((String)"data.region.global.missing", (String)"Missing global region data (ignore on first startup). Initializing...").getString());
                globalRegionData = new GlobalRegionData();
                RegionDataManager.saveGlobalData(server);
            }
        }
        catch (NullPointerException npe) {
            LOGGER.error(Component.translatableWithFallback((String)"data.region.level.local.load.failed", (String)"Loading level region list failed!").getString(), (Throwable)npe);
        }
    }

    public static void worldLoad(MinecraftServer server, ServerLevel level) {
        try {
            ResourceLocation levelRl;
            if (serverInstance == null) {
                serverInstance = server;
            }
            if (savedLevelData.hasDimEntry(levelRl = level.dimension().location())) {
                LevelRegionData levelRegionData = RegionDataManager.loadLevelData(server, (Level)level);
                if (levelRegionData == null) {
                    levelRegionData = new LevelRegionData(levelRl);
                    LOGGER.info(Component.translatableWithFallback((String)"data.region.level.local.missing", (String)"Initializing region data for '%s'", (Object[])new Object[]{levelRl.toString()}).getString());
                    dimRegionStorage.put(levelRl, levelRegionData);
                    RegionDataManager.saveLevelData(server, (Level)level);
                } else {
                    LOGGER.info(Component.translatableWithFallback((String)"data.region.level.local.load.success", (String)"Loaded %s region(s) for '%s'", (Object[])new Object[]{levelRegionData.regionCount(), levelRl.toString()}).getString());
                    dimRegionStorage.put(levelRl, levelRegionData);
                    savedLevelData.addDimEntry(levelRl);
                }
                LOGGER.info(Component.translatableWithFallback((String)"data.region.level.local.load.restore", (String)"Restoring region hierarchy for '%s'.", (Object[])new Object[]{levelRl.toString()}).getString());
                DimensionalRegion dimensionalRegion = levelRegionData.getDim();
                RegionManager.get().getGlobalRegion().addChild(dimensionalRegion);
                RegionDataManager.restoreHierarchy(levelRegionData, dimensionalRegion);
                levelRegionData.getLocals().forEach((regionName, region) -> RegionDataManager.restoreHierarchy(dimRegionStorage.get(levelRl), region));
            }
        }
        catch (NullPointerException npe) {
            LOGGER.error(Component.translatableWithFallback((String)"data.region.level.local.load.failed", (String)"Loading regions failed!").getString(), (Throwable)npe);
        }
    }

    private static void restoreHierarchy(LevelRegionData levelRegionData, IProtectedRegion region) {
        ArrayList<String> childNames = new ArrayList<String>(region.getChildrenNames());
        childNames.forEach(childName -> {
            if (!levelRegionData.hasLocal((String)childName)) {
                LOGGER.warn(Component.translatableWithFallback((String)"data.region.level.local.load.restore.failed", (String)"No region with name '%s' found in save data of '%s'! Your region data is most likely corrupt.", (Object[])new Object[]{childName, levelRegionData.getId().toString()}).getString());
            } else {
                IMarkableRegion child = levelRegionData.getLocal((String)childName);
                if (child != null) {
                    levelRegionData.getDim().removeChild(child);
                    region.addChild(child);
                }
            }
        });
    }

    private static void checkYawpDir(MinecraftServer server) {
        Path worldRootPath = server.getWorldPath(LevelResource.ROOT).normalize();
        Path dataDirPath = worldRootPath.resolve("data/yawp");
        if (Files.notExists(dataDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dataDirPath, new FileAttribute[0]);
                LOGGER.info(Component.translatableWithFallback((String)"data.region.env.init", (String)"Created region data directory '%s'", (Object[])new Object[]{dataDirPath.toString()}).getString());
            }
            catch (IOException e) {
                LOGGER.error(Component.translatableWithFallback((String)"data.region.env.error", (String)"Failed to create directory for region data: '%s'").getString(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void initLevelDataOnLogin(Entity entity, Level level) {
        if (HandlerUtil.isServerSide(level) && entity instanceof Player) {
            RegionDataManager.initLevelData(level.dimension().location());
        }
    }

    public static void initLevelDataOnChangeWorld(Player player, Level srcLvl, Level dstLvl) {
        if (HandlerUtil.isServerSide(srcLvl)) {
            RegionDataManager.initLevelData(dstLvl.dimension().location());
        }
    }

    private static LevelRegionData initLevelData(ResourceLocation rl) {
        if (!savedLevelData.hasDimEntry(rl)) {
            LevelRegionData levelRegionData = new LevelRegionData(rl);
            DimensionalRegion dimensionalRegion = levelRegionData.getDim();
            Set<String> defaultDimFlags = Services.REGION_CONFIG.getDefaultDimFlags();
            defaultDimFlags.stream().map(RegionFlag::fromId).forEach(flag -> dimensionalRegion.addFlag(new BooleanFlag((RegionFlag)((Object)flag))));
            dimensionalRegion.setIsActive(Services.REGION_CONFIG.shouldActivateNewDimRegion());
            RegionManager.get().getGlobalRegion().addChild(dimensionalRegion);
            dimRegionStorage.put(rl, levelRegionData);
            savedLevelData.addDimEntry(rl);
            LOGGER.info(Component.translatableWithFallback((String)"data.region.level.init", (String)"Initializing region data for level '%s'", (Object[])new Object[]{rl.toString()}).getString());
            RegionDataManager.save(false);
            return levelRegionData;
        }
        return dimRegionStorage.get(rl);
    }

    public static Optional<LevelRegionData> getLevelRegionData(ResourceLocation rl) {
        if (!savedLevelData.hasDimEntry(rl)) {
            return Optional.empty();
        }
        return Optional.of(dimRegionStorage.get(rl));
    }

    public static Optional<LevelRegionData> getLevelRegionData(ResourceKey<Level> dim) {
        return RegionDataManager.getLevelRegionData(dim.location());
    }

    public static LevelRegionData getOrCreate(ResourceLocation rl) {
        if (!savedLevelData.hasDimEntry(rl)) {
            return RegionDataManager.initLevelData(rl);
        }
        return dimRegionStorage.get(rl);
    }

    public static LevelRegionData getOrCreate(Level level) {
        return RegionDataManager.getOrCreate(level.dimension().location());
    }

    public static Collection<IMarkableRegion> getLocalsFor(ResourceKey<Level> dim) {
        return RegionDataManager.getOrCreate(dim.location()).getLocalList();
    }

    public static LevelRegionData getOrCreate(ResourceKey<Level> dim) {
        return RegionDataManager.getOrCreate(dim.location());
    }

    public static void resetLevelData(ResourceLocation rl) {
        dimRegionStorage.remove(rl);
    }

    public static void resetLevelData(ResourceKey<Level> dim) {
        RegionDataManager.resetLevelData(dim.location());
    }

    static {
        savedLevelData = new LevelListData();
        globalRegionData = new GlobalRegionData();
        dimRegionStorage = new HashMap<ResourceLocation, LevelRegionData>();
    }
}

