/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler.flags;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.handler.flags.NeoForgeHandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TriState;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="yawp")
public final class PlayerFlagHandler {
    private PlayerFlagHandler() {
    }

    @SubscribeEvent
    public static void onElytraFlying(PlayerTickEvent.Post event) {
        if (HandlerUtil.isServerSide((Entity)event.getEntity())) {
            Player player = event.getEntity();
            ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)player);
            if (player.isFallFlying()) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(player.blockPosition(), RegionFlag.NO_FLIGHT, dim, player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> player.stopFallFlying());
            }
        }
    }

    @SubscribeEvent
    public static void onAttackPlayer(AttackEntityEvent event) {
        if (NeoForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            Player attacker = event.getEntity();
            ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)attacker);
            FlagCheckEvent checkEvent = new FlagCheckEvent(target.blockPosition(), RegionFlag.MELEE_PLAYERS, dim, attacker);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onLooseArrow(ArrowLooseEvent event) {
        if (!HandlerUtil.isServerSide(event.getLevel())) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof Player) {
            Player shooter = player;
            FlagCheckEvent checkEvent = new FlagCheckEvent(shooter.blockPosition(), RegionFlag.FIRE_BOW, HandlerUtil.getDimKey(event.getLevel()), shooter);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                event.setCharge(0);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onProjectileHitPlayer(ProjectileImpactEvent event) {
        EntityHitResult entityHitRes;
        Entity hitEntity;
        HitResult hitResult;
        boolean wasHit;
        boolean isTypeOf;
        Projectile projectile = event.getProjectile();
        if (!HandlerUtil.isServerSide((Entity)projectile)) {
            return;
        }
        Entity shooter = projectile.getOwner();
        boolean bl = isTypeOf = projectile instanceof FireworkRocketEntity || projectile instanceof AbstractArrow || projectile instanceof Snowball || projectile instanceof ThrownEgg || projectile instanceof ThrownEnderpearl;
        if (!isTypeOf) {
            return;
        }
        boolean wasShotByPlayer = shooter instanceof Player;
        boolean bl2 = wasHit = event.getRayTraceResult().getType() == HitResult.Type.ENTITY;
        if (wasShotByPlayer && wasHit && (hitResult = event.getRayTraceResult()) instanceof EntityHitResult && (hitEntity = (entityHitRes = (EntityHitResult)hitResult).getEntity()) instanceof Player) {
            Player hitPlayer = (Player)hitEntity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(hitPlayer.blockPosition(), RegionFlag.NO_PVP, HandlerUtil.getDimKey((Entity)hitPlayer), (Player)shooter);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (NeoForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        Entity eventEntity = event.getTarget();
        ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)event.getEntity());
        BlockPos entityPos = eventEntity.blockPosition();
        FlagCheckEvent checkEvent = null;
        if (HandlerUtil.isAnimal(eventEntity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_ANIMALS, dim, player))) {
            return;
        }
        if (HandlerUtil.isMonster(eventEntity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_MONSTERS, dim, player))) {
            return;
        }
        if (event.getTarget() instanceof Villager && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_VILLAGERS, dim, player))) {
            return;
        }
        if (event.getTarget() instanceof WanderingTrader && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_WANDERING_TRADER, dim, player))) {
            return;
        }
        if (checkEvent != null) {
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPickupItem(ItemEntityPickupEvent.Pre event) {
        if (event.getPlayer() != null && HandlerUtil.isServerSide((Entity)event.getPlayer())) {
            return;
        }
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPlayer().blockPosition(), RegionFlag.ITEM_PICKUP, HandlerUtil.getDimKey((Entity)event.getPlayer()), event.getPlayer());
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanPickup(TriState.FALSE);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onBreedingAttempt(BabyEntitySpawnEvent event) {
        Player player = event.getCausedByPlayer();
        if (player == null) {
            return;
        }
        if (!player.level().isClientSide()) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getParentB().blockPosition(), RegionFlag.ANIMAL_BREEDING, HandlerUtil.getDimKey((Entity)player), event.getCausedByPlayer());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onAnimalTameAttempt(AnimalTameEvent event) {
        Player player = event.getTamer();
        if (player == null) {
            return;
        }
        if (!player.level().isClientSide()) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getAnimal().blockPosition(), RegionFlag.ANIMAL_TAMING, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLevelChange(PlayerXpEvent.LevelChange event) {
        if (NeoForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().blockPosition(), RegionFlag.LEVEL_FREEZE, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPlayerXPChange(PlayerXpEvent.XpChange event) {
        if (NeoForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().blockPosition(), RegionFlag.XP_FREEZE, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            event.setAmount(0);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPlayerXpPickup(PlayerXpEvent.PickupXp event) {
        if (NeoForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().blockPosition(), RegionFlag.XP_PICKUP, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            event.getOrb().remove(Entity.RemovalReason.DISCARDED);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPvpAction(LivingIncomingDamageEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            if (event.getSource() == null || event.getEntity() == null) {
                return;
            }
            Entity dmgSourceEntity = event.getSource().getDirectEntity();
            LivingEntity hurtEntity = event.getEntity();
            if (hurtEntity instanceof Player) {
                Player playerTarget = (Player)hurtEntity;
                if (dmgSourceEntity instanceof Player) {
                    Player playerSource = (Player)dmgSourceEntity;
                    FlagCheckEvent checkEvent = new FlagCheckEvent(playerTarget.blockPosition(), RegionFlag.NO_PVP, HandlerUtil.getDimKey((Entity)playerSource), playerSource);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        event.setAmount(0.0f);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingIncomingDamageEvent event) {
        LivingEntity hurtEntity;
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event) && (hurtEntity = event.getEntity()) instanceof Player) {
            Player playerTarget = (Player)hurtEntity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(playerTarget.blockPosition(), RegionFlag.INVINCIBLE, HandlerUtil.getDimKey((Entity)playerTarget), playerTarget);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.process(checkEvent).onAllow(res -> {
                event.setCanceled(true);
                event.setAmount(0.0f);
            });
        }
    }

    @SubscribeEvent
    public static void onReceiveDmg(LivingIncomingDamageEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            if (event.getSource() == null || event.getEntity() == null) {
                return;
            }
            Entity dmgSourceEntity = event.getSource().getDirectEntity();
            if (dmgSourceEntity instanceof Player) {
                Player dmgSource = (Player)dmgSourceEntity;
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    Player dmgTarget = (Player)livingEntity;
                    FlagCheckEvent checkEvent = new FlagCheckEvent(dmgTarget.blockPosition(), RegionFlag.MELEE_PLAYERS, HandlerUtil.getDimKey((Entity)dmgSource), dmgSource);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        event.setAmount(0.0f);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity;
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event) && (livingEntity = event.getEntity()) instanceof Player) {
            Player dmgTarget = (Player)livingEntity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(dmgTarget.blockPosition(), RegionFlag.NO_KNOCKBACK, HandlerUtil.getDimKey((Entity)dmgTarget), dmgTarget);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.process(checkEvent).onAllow(res -> {
                event.setCanceled(true);
                event.setStrength(0.0f);
            });
            checkEvent = new FlagCheckEvent(dmgTarget.blockPosition(), RegionFlag.INVINCIBLE, HandlerUtil.getDimKey((Entity)dmgTarget), dmgTarget);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.process(checkEvent).onAllow(res -> {
                event.setCanceled(true);
                event.setStrength(0.0f);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((BlockEvent)event)) {
            if (event.getPlayer() == null) {
                return;
            }
            Player player = event.getPlayer();
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.BREAK_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                HandlerUtil.updateBlockState((Level)event.getLevel(), event.getPos());
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((BlockEvent)event)) {
            Entity entity;
            if (event.getEntity() == null || !((entity = event.getEntity()) instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.PLACE_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                HandlerUtil.updateBlockState((Level)event.getLevel(), event.getPos());
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityBreak(AttackEntityEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            if (event.getTarget() == null || event.getEntity() == null) {
                return;
            }
            Entity target = event.getTarget();
            Player player = event.getEntity();
            Set<String> entityTags = Services.FLAG_CONFIG.getCoveredBlockEntityTags();
            boolean isCoveredByTag = entityTags.stream().anyMatch(entityTag -> {
                ResourceLocation tagRl = ResourceLocation.parse((String)entityTag);
                return target.getTags().contains(tagRl.getPath());
            });
            Set<String> entities = Services.FLAG_CONFIG.getCoveredBlockEntities();
            boolean isBlockEntityCovered = entities.stream().anyMatch(entity -> {
                ResourceLocation entityRl = ResourceLocation.parse((String)entity);
                ResourceLocation targetRl = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType());
                return targetRl != null && targetRl.equals((Object)entityRl);
            });
            if (isBlockEntityCovered || isCoveredByTag) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().blockPosition(), RegionFlag.BREAK_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onExplosionStarted(ExplosionEvent.Start event) {
        if (HandlerUtil.isServerSide(event.getLevel())) {
            if (event.getExplosion() == null) {
                return;
            }
            ServerExplosion explosion = event.getExplosion();
            BlockPos explosionPos = new BlockPos((int)explosion.center().x, (int)explosion.center().y, (int)explosion.center().z);
            ResourceKey dim = event.getLevel().dimension();
            if (explosion.getIndirectSourceEntity() == null) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.IGNITE_EXPLOSIVES, (ResourceKey<Level>)dim);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> event.setCanceled(true));
            } else {
                LivingEntity livingEntity = explosion.getIndirectSourceEntity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    FlagCheckEvent checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.IGNITE_EXPLOSIVES, (ResourceKey<Level>)dim, player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
                if (explosion.getIndirectSourceEntity() instanceof Monster) {
                    checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.MOB_GRIEFING, (ResourceKey<Level>)dim);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> event.setCanceled(true));
                } else {
                    checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.IGNITE_EXPLOSIVES, (ResourceKey<Level>)dim);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> event.setCanceled(true));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBonemealUse(BonemealEvent event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getPlayer())) {
            return;
        }
        Player player = event.getPlayer();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_BONEMEAL, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPlayerUseEnderPearl(EntityTeleportEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event) && event instanceof EntityTeleportEvent.EnderPearl) {
            EntityTeleportEvent.EnderPearl enderPearlEvent = (EntityTeleportEvent.EnderPearl)event;
            if (enderPearlEvent.getPlayer() == null) {
                return;
            }
            BlockPos target = new BlockPos((int)event.getTarget().x, (int)event.getTarget().y, (int)event.getTarget().z);
            ServerPlayer player = enderPearlEvent.getPlayer();
            FlagCheckEvent checkEvent = new FlagCheckEvent(target, RegionFlag.USE_ENDERPEARL_TO_REGION, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
            if (flagState == FlagState.DENIED) {
                return;
            }
            target = new BlockPos((int)event.getTarget().x, (int)event.getTarget().y, (int)event.getTarget().z);
            checkEvent = new FlagCheckEvent(target, RegionFlag.USE_ENDERPEARL_FROM_REGION, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
            player.getInventory().setChanged();
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        UseOnContext useOnContext = new UseOnContext(player, event.getHand(), event.getHitVec());
        BlockPos targetPos = useOnContext.getClickedPos();
        BlockPos placeBlockTarget = targetPos.relative(useOnContext.getClickedFace().getOpposite());
        BlockEntity targetEntity = event.getLevel().getBlockEntity(event.getPos());
        InteractionHand usedHand = useOnContext.getHand();
        boolean hasEmptyHand = PlayerFlagHandler.hasEmptyHand(player, usedHand);
        ItemStack itemInHand = useOnContext.getItemInHand();
        boolean isSneakingWithEmptyHand = player.isShiftKeyDown() && hasEmptyHand;
        boolean isBlockEntity = targetEntity instanceof BlockEntity;
        boolean isLockableTileEntity = targetEntity instanceof BaseContainerBlockEntity;
        boolean isEnderChest = targetEntity instanceof EnderChestBlockEntity;
        boolean isContainer = targetEntity instanceof LecternBlockEntity || isLockableTileEntity;
        BlockHitResult pos = event.getHitVec();
        if (isSneakingWithEmptyHand || !player.isShiftKeyDown()) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos.getBlockPos(), RegionFlag.USE_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
                event.getLevel().updateNeighborsAt(pos.getBlockPos(), event.getLevel().getBlockState(pos.getBlockPos()).getBlock());
            });
            if (isEnderChest) {
                checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.ENDER_CHEST_ACCESS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
            if (isContainer) {
                checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.CONTAINER_ACCESS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
        }
        if (!hasEmptyHand) {
            FlagCheckEvent checkEvent;
            ResourceLocation itemRl = BuiltInRegistries.ITEM.getKey((Object)itemInHand.getItem());
            Set<String> entities = Services.FLAG_CONFIG.getCoveredBlockEntities();
            Set<String> entityTags = Services.FLAG_CONFIG.getCoveredBlockEntityTags();
            boolean isCoveredByTag = entityTags.stream().anyMatch(tag -> {
                ResourceLocation tagRl = ResourceLocation.parse((String)tag);
                return itemInHand.getTags().anyMatch(itemTagKey -> itemTagKey.location().equals((Object)tagRl));
            });
            boolean isBlockCovered = entities.stream().anyMatch(entity -> {
                ResourceLocation entityRl = ResourceLocation.parse((String)entity);
                return itemRl != null && itemRl.equals((Object)entityRl);
            });
            Consumer<FlagCheckResult> onDenyAction = denyResult -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(denyResult);
                player.getInventory().setChanged();
            };
            if (isBlockCovered || isCoveredByTag) {
                checkEvent = new FlagCheckEvent(placeBlockTarget, RegionFlag.PLACE_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDenyAction);
            }
            if (Services.EVENT.post(checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((Entity)player), player))) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDenyAction);
        }
    }

    @SubscribeEvent
    public static void onAccessEntityContainer(PlayerInteractEvent.EntityInteract event) {
        boolean hasInventory;
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        boolean bl = hasInventory = event.getTarget() instanceof Container || event.getTarget() instanceof MenuProvider;
        if (hasInventory) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().blockPosition(), RegionFlag.CONTAINER_ACCESS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.EntityInteractSpecific event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().blockPosition(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
        if (!PlayerFlagHandler.hasEmptyHand(player, event.getHand())) {
            checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    private static boolean hasEmptyHands(Player player) {
        return player.getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(Items.AIR) && player.getItemInHand(InteractionHand.OFF_HAND).getItem().equals(Items.AIR);
    }

    private static boolean hasEmptyHand(Player player, InteractionHand hand) {
        return player.getItemInHand(hand).getItem().equals(Items.AIR);
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().blockPosition(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
        if (!PlayerFlagHandler.hasEmptyHand(player, event.getHand())) {
            checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.RightClickItem event) {
        FlagCheckEvent checkEvent;
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        if (!PlayerFlagHandler.hasEmptyHand(player, event.getHand())) {
            checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
        if (Services.EVENT.post(checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((Entity)player), player))) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onSteppedOnActivator(BlockEvent.NeighborNotifyEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((BlockEvent)event)) {
            Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
            BlockPos pos = event.getPos();
            if (block instanceof BasePressurePlateBlock) {
                AABB areaAbovePressurePlate = new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1));
                List players = event.getLevel().getEntities((EntityTypeTest)EntityType.PLAYER, areaAbovePressurePlate, player -> true);
                FlagState[] cumulativeState = new FlagState[]{FlagState.UNDEFINED};
                HashMap<Player, FlagCheckEvent> playerCheckEventMap = new HashMap<Player, FlagCheckEvent>();
                for (Player player2 : players) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(player2.blockPosition(), RegionFlag.USE_BLOCKS, HandlerUtil.getDimKey((Entity)player2), player2);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    playerCheckEventMap.put(player2, checkEvent);
                }
                for (Map.Entry entry : playerCheckEventMap.entrySet()) {
                    FlagState state = FlagEvaluator.processCheck((FlagCheckEvent)entry.getValue(), null, MessageSender::sendFlagMsg);
                    if (state != FlagState.DENIED) continue;
                    cumulativeState[0] = state;
                }
                if (cumulativeState[0] == FlagState.DENIED) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSendChat(ServerChatEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ServerPlayer player = event.getPlayer();
        FlagCheckEvent checkEvent = new FlagCheckEvent(player.blockPosition(), RegionFlag.SEND_MESSAGE, HandlerUtil.getDimKey((Entity)player), (Player)player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onCommandSend(CommandEvent event) {
        try {
            ServerPlayer player = ((CommandSourceStack)event.getParseResults().getContext().getSource()).getPlayerOrException();
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.blockPosition(), RegionFlag.EXECUTE_COMMAND, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerAttemptSleep(CanPlayerSleepEvent event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        ServerPlayer player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.SLEEP, HandlerUtil.getDimKey((Entity)player), (Player)player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setProblem(Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onSetSpawn(PlayerSetSpawnEvent event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        BlockPos newSpawn = event.getNewSpawn();
        Player player = event.getEntity();
        if (newSpawn != null) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(newSpawn, RegionFlag.SET_SPAWN, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerDropItem(ItemTossEvent event) {
        if (!event.getPlayer().level().isClientSide()) {
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().blockPosition(), RegionFlag.ITEM_DROP, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                player.addItem(event.getEntity().getItem());
                player.getInventory().setChanged();
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityMountAttempt(EntityMountEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            Entity entityBeingMounted = event.getEntityBeingMounted();
            Entity entity = event.getEntityMounting();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                FlagCheckEvent checkEvent = new FlagCheckEvent(entityBeingMounted.blockPosition(), RegionFlag.ANIMAL_MOUNTING, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
                if (event.isDismounting()) {
                    checkEvent = new FlagCheckEvent(entityBeingMounted.blockPosition(), RegionFlag.ANIMAL_UNMOUNTING, HandlerUtil.getDimKey((Entity)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }
}

