/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onUseAxeOnBlock(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (HandlerUtil.isServerSide(context.getLevel()) && player != null) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.TOOL_SECONDARY_USE, HandlerUtil.getDimKey(context.getLevel()), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                cir.setReturnValue((Object)InteractionResult.PASS);
            });
            checkEvent = new FlagCheckEvent(pos, RegionFlag.AXE_STRIP, HandlerUtil.getDimKey(context.getLevel()), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                cir.setReturnValue((Object)InteractionResult.PASS);
            });
        }
    }
}

