/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public final class AreaUtil {
    private AreaUtil() {
    }

    public static double distance(BlockPos a, BlockPos b) {
        return Math.sqrt(Math.pow(b.getX() - a.getX(), 2.0) + Math.pow(b.getY() - a.getY(), 2.0) + Math.pow(b.getZ() - a.getZ(), 2.0));
    }

    public static int distanceManhattan(BlockPos a, BlockPos b) {
        return Math.abs(b.getX() - a.getX()) + Math.abs(b.getY() - a.getY()) + Math.abs(b.getZ() - a.getZ());
    }

    public static double length(BlockPos a) {
        return Math.sqrt(Math.pow(a.getX(), 2.0) + Math.pow(a.getY(), 2.0) + Math.pow(a.getZ(), 2.0));
    }

    public static String blockPosStr(BlockPos pos) {
        return new StringJoiner(", ", "[", "]").add(String.valueOf(pos.getX())).add(String.valueOf(pos.getY())).add(String.valueOf(pos.getZ())).toString();
    }

    public static BlockPos getLowerPos(BlockPos pos1, BlockPos pos2) {
        return pos1.getZ() < pos2.getZ() ? pos1 : pos2;
    }

    public static BlockPos getHigherPos(BlockPos pos1, BlockPos pos2) {
        return pos1.getZ() > pos2.getZ() ? pos1 : pos2;
    }

    public static Set<BlockPos> getBoundingBoxFrame(BoundingBox box) {
        BlockPos[] corners = new BlockPos[]{new BlockPos(box.minX(), box.minY(), box.minZ()), new BlockPos(box.minX(), box.minY(), box.maxZ()), new BlockPos(box.minX(), box.maxY(), box.minZ()), new BlockPos(box.minX(), box.maxY(), box.maxZ()), new BlockPos(box.maxX(), box.minY(), box.minZ()), new BlockPos(box.maxX(), box.minY(), box.maxZ()), new BlockPos(box.maxX(), box.maxY(), box.minZ()), new BlockPos(box.maxX(), box.maxY(), box.maxZ())};
        int[][] edgePairs = new int[][]{{0, 1}, {0, 2}, {0, 4}, {1, 3}, {1, 5}, {2, 3}, {2, 6}, {3, 7}, {4, 5}, {4, 6}, {5, 7}, {6, 7}};
        HashSet<BlockPos> frame = new HashSet<BlockPos>();
        for (int[] pair : edgePairs) {
            frame.addAll(AreaUtil.getEdge(corners[pair[0]], corners[pair[1]]));
        }
        return frame;
    }

    public static Set<BlockPos> getEdge(BlockPos a, BlockPos b) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        int dx = Integer.compare(b.getX(), a.getX());
        int dy = Integer.compare(b.getY(), a.getY());
        int dz = Integer.compare(b.getZ(), a.getZ());
        BlockPos current = a;
        result.add(current);
        while (!current.equals((Object)b)) {
            current = current.offset(dx, dy, dz);
            result.add(current);
        }
        return result;
    }

    public static Set<BlockPos> blocksBetweenOnAxis(BlockPos p1, BlockPos p2, Direction.Axis axis) {
        BoundingBox blockLine = BoundingBox.fromCorners((Vec3i)p1, (Vec3i)p2);
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        switch (axis) {
            case X: {
                for (int x = blockLine.minX(); x <= blockLine.maxX(); ++x) {
                    blocks.add(new BlockPos(x, p1.getY(), p1.getZ()));
                }
                break;
            }
            case Y: {
                for (int y = blockLine.minY(); y <= blockLine.maxY(); ++y) {
                    blocks.add(new BlockPos(p1.getX(), y, p1.getZ()));
                }
                break;
            }
            case Z: {
                for (int z = blockLine.minZ(); z <= blockLine.maxZ(); ++z) {
                    blocks.add(new BlockPos(p1.getX(), p1.getY(), z));
                }
                break;
            }
        }
        return blocks;
    }

    public static Set<BlockPos> blocksIn(BoundingBox cube) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = cube.minX(); x <= cube.maxX(); ++x) {
            for (int y = cube.minY(); y <= cube.maxY(); ++y) {
                for (int z = cube.minZ(); z <= cube.maxZ(); ++z) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static Set<BlockPos> blocksIn(BoundingBox cube, Predicate<BlockPos> inclusion) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = cube.minX(); x <= cube.maxX(); ++x) {
            for (int y = cube.minY(); y <= cube.maxY(); ++y) {
                for (int z = cube.minZ(); z <= cube.maxZ(); ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!inclusion.test(blockPos)) continue;
                    blocks.add(blockPos);
                }
            }
        }
        return blocks;
    }

    public static int blocksOnAxis(BoundingBox box, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return box.getXSpan();
            }
            case Y: {
                return box.getYSpan();
            }
            case Z: {
                return box.getZSpan();
            }
        }
        throw new IllegalArgumentException();
    }

    public static BoundingBox getSlice(BlockPos center, int halfSize, int offset, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                BlockPos p1 = center.offset(halfSize, halfSize, offset);
                BlockPos p2 = center.offset(-halfSize, -halfSize, offset);
                yield BoundingBox.fromCorners((Vec3i)p1, (Vec3i)p2);
            }
            case Direction.Axis.Y -> {
                BlockPos p1 = center.offset(halfSize, offset, halfSize);
                BlockPos p2 = center.offset(-halfSize, offset, -halfSize);
                yield BoundingBox.fromCorners((Vec3i)p1, (Vec3i)p2);
            }
            case Direction.Axis.Z -> {
                BlockPos p1 = center.offset(offset, halfSize, halfSize);
                BlockPos p2 = center.offset(offset, -halfSize, -halfSize);
                yield BoundingBox.fromCorners((Vec3i)p1, (Vec3i)p2);
            }
        };
    }

    public static Set<BlockPos> getSliceBlocks(BlockPos center, int halfSize, int offset, Direction.Axis axis, Predicate<BlockPos> include) {
        BoundingBox slice = AreaUtil.getSlice(center, halfSize, offset, axis);
        return AreaUtil.blocksIn(slice, include);
    }
}

