/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.util.LocalRegions;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class StickUtil {
    private static final String MARKED_BLOCK_INDICATOR = "X";
    private static final String UNMARKED_BLOCK_INDICATOR = "#";
    private static final String TP_POS_INDICATOR = "TP";
    private static final ChatFormatting MARKED_BLOCK_COLOR = ChatFormatting.GREEN;
    private static final ChatFormatting UNMARKED_BLOCK_COLOR = ChatFormatting.RED;
    private static final ChatFormatting UNMARKED_POS_COLOR = ChatFormatting.AQUA;

    private StickUtil() {
    }

    public static void initStickTag(ItemStack stick, ResourceKey<Level> dim, boolean reset) {
        CompoundTag customDataTag;
        CustomData customData = (CustomData)stick.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            stick.set(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        }
        if ((customData = (CustomData)stick.get(DataComponents.CUSTOM_DATA)) != null && (!(customDataTag = customData.copyTag()).contains("stick") || reset)) {
            CompoundTag compoundNBT = new MarkerStick(dim).serializeNBT();
            customDataTag.put("stick", (Tag)compoundNBT);
            stick.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customDataTag));
        }
    }

    public static void initMarkerNbt(ItemStack stack, ResourceKey<Level> dim) {
        stack.setCount(1);
        StickUtil.initStickTag(stack, dim, false);
        StickUtil.updateStickMetadata(stack);
    }

    public static void resetMarkerNbt(ItemStack stack, ResourceKey<Level> dim) {
        StickUtil.initStickTag(stack, dim, true);
        StickUtil.updateStickMetadata(stack);
    }

    private static void updateStickMetadata(ItemStack stack) {
        StickUtil.updateStickName(stack);
        stack.set(DataComponents.LORE, (Object)StickUtil.buildToolTip());
        stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
    }

    public static boolean isMarker(ItemStack stack) {
        if (StickUtil.hasCustomDataTag(stack)) {
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            CompoundTag compoundTag = customData.copyTag();
            return compoundTag.contains("stick") && customData.copyTag().get("stick") != null;
        }
        return false;
    }

    @Nullable
    public static CompoundTag getStickNBT(ItemStack stick) {
        if (((CustomData)stick.get(DataComponents.CUSTOM_DATA)).copyTag().contains("stick")) {
            return (CompoundTag)((CustomData)stick.get(DataComponents.CUSTOM_DATA)).copyTag().get("stick");
        }
        return null;
    }

    @Nullable
    public static IMarkableArea getMarkedArea(ItemStack stick) {
        CompoundTag stickNBT;
        if (StickUtil.isMarker(stick) && (stickNBT = StickUtil.getStickNBT(stick)) != null) {
            MarkerStick marker = new MarkerStick(stickNBT);
            if (!marker.isValidArea()) {
                return null;
            }
            return LocalRegions.areaFrom(marker);
        }
        return null;
    }

    public static void updateStickName(ItemStack stick) {
        CompoundTag stickNBT = StickUtil.getStickNBT(stick);
        if (stickNBT != null) {
            MarkerStick marker = new MarkerStick(stickNBT);
            MutableComponent markerIndicators = StickUtil.buildRegionMarkerIndicators(marker);
            MutableComponent markerHoverName = StickUtil.buildStickName(marker).append(" ").append((Component)markerIndicators);
            stick.set(DataComponents.CUSTOM_NAME, (Object)markerHoverName);
        }
    }

    private static MutableComponent buildStickName(MarkerStick marker) {
        MutableComponent stickName = Component.literal((String)marker.getStickType().stickName).withStyle(ChatFormatting.GOLD);
        MutableComponent areaType = Component.literal((String)" (").append(marker.getAreaType().areaType).append(")");
        return stickName.append((Component)areaType);
    }

    private static MutableComponent buildMarkerIndicator(boolean isMarked) {
        String indicator = isMarked ? MARKED_BLOCK_INDICATOR : UNMARKED_BLOCK_INDICATOR;
        ChatFormatting color = isMarked ? MARKED_BLOCK_COLOR : UNMARKED_BLOCK_COLOR;
        MutableComponent indicatorComp = Component.literal((String)indicator).withStyle(color);
        MutableComponent closedResetComp = Component.literal((String)"]").withStyle(ChatFormatting.RESET);
        return Component.literal((String)"[").append((Component)indicatorComp).append((Component)closedResetComp);
    }

    private static MutableComponent buildRegionMarkerIndicators(MarkerStick marker) {
        int i;
        MutableComponent regionMarkerIndicators = Component.literal((String)"");
        int maxBlocks = marker.getAreaType().maxBlocks;
        int amountUnmarked = maxBlocks - marker.getMarkedBlocks().size();
        for (i = 0; i < marker.getMarkedBlocks().size(); ++i) {
            regionMarkerIndicators.append((Component)StickUtil.buildMarkerIndicator(true));
        }
        for (i = 0; i < amountUnmarked; ++i) {
            regionMarkerIndicators.append((Component)StickUtil.buildMarkerIndicator(false));
        }
        return regionMarkerIndicators;
    }

    public static boolean hasCustomDataTag(ItemStack itemStack) {
        return itemStack.get(DataComponents.CUSTOM_DATA) != null;
    }

    public static void setMarkerNbt(ItemStack itemStack, CompoundTag markerTag) {
        if (StickUtil.hasCustomDataTag(itemStack)) {
            CompoundTag compoundTag = ((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag();
            compoundTag.put("stick", (Tag)markerTag);
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
        }
    }

    private static ItemLore buildToolTip() {
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        lore.add(Component.translatableWithFallback((String)"help.tooltip.stick.marker.simple.1", (String)"Used to mark a new region."));
        lore.add(Component.translatableWithFallback((String)"help.tooltip.stick.marker.simple.2", (String)"Keep the Region Marker in your hand while creating a region!"));
        lore.add(Component.literal((String)String.valueOf(ChatFormatting.ITALIC)).append((Component)Component.translatableWithFallback((String)"help.tooltip.stick.marker.simple.3", (String)"Mark a (Cuboid) region by right-clicking the diagonal opposite corner blocks.")));
        lore.add(Component.literal((String)String.valueOf(ChatFormatting.ITALIC)).append((Component)Component.translatableWithFallback((String)"help.tooltip.stick.marker.simple.4", (String)"Set a region teleport position by shift-right-clicking a block.")));
        return new ItemLore(lore);
    }
}

