/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;

public class DisplaySettingsMessage
implements MultiLineMessage<BlockDisplayProperties> {
    private final IMarkableRegion region;
    private final List<Component> infoLines;

    public DisplaySettingsMessage(IMarkableRegion region) {
        this.region = region;
        this.infoLines = new ArrayList<Component>();
    }

    @Override
    public List<Component> getLines() {
        this.infoLines.clear();
        MutableComponent header = ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.of", (String)"== %s of %s ==", (Object[])new Object[]{ChatLinkBuilder.buildDisplaySettingsLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
        MutableComponent blockSubject = Component.translatableWithFallback((String)"cli.msg.info.region.display.block", (String)"Block");
        MutableComponent glowSubject = Component.translatableWithFallback((String)"cli.msg.info.region.display.glow", (String)"Glow");
        MutableComponent lightLevelSubject = Component.translatableWithFallback((String)"cli.msg.info.region.display.light-level", (String)"Light-Level");
        MutableComponent blockComponent = ChatComponentBuilder.buildInfoComponent(blockSubject, DisplaySettingsMessage.buildDisplayBlockInfo(this.region), DisplaySettingsMessage.buildSetDisplayBlockLink(this.region));
        MutableComponent glowActions = Messages.substitutable("%s %s", DisplaySettingsMessage.buildSetDisplayGlowOnLink(this.region), DisplaySettingsMessage.buildSetDisplayGlowOffLink(this.region));
        MutableComponent glowComponent = ChatComponentBuilder.buildInfoComponent(glowSubject, DisplaySettingsMessage.buildDisplayGlowInfo(this.region), glowActions);
        MutableComponent lightLevelComponent = ChatComponentBuilder.buildInfoComponent(lightLevelSubject, DisplaySettingsMessage.buildDisplayLightLevelInfo(this.region), DisplaySettingsMessage.buildSetDisplayLightLevelLink(this.region));
        this.infoLines.add((Component)header);
        this.infoLines.add((Component)blockComponent);
        this.infoLines.add((Component)glowComponent);
        this.infoLines.add((Component)lightLevelComponent);
        return this.infoLines;
    }

    @Override
    public BlockDisplayProperties getContent() {
        return this.region.getArea().getDisplay();
    }

    public static MutableComponent buildDisplayBlockInfo(IMarkableRegion region) {
        MutableComponent blockInfoHover = Component.literal((String)region.getArea().getDisplay().blockRl().toString());
        Optional block = BuiltInRegistries.BLOCK.get(region.getArea().getDisplay().blockRl());
        if (block.isPresent()) {
            MutableComponent blockInfoText = ((Block)((Holder.Reference)block.get()).value()).getName();
            return ChatComponentBuilder.buildTextWithWhiteBracketsAndHover(blockInfoText, blockInfoHover, ChatFormatting.BLUE);
        }
        throw new IllegalStateException("BlockRl '" + region.getArea().getDisplay().blockRl().toString() + "' in region " + region.getName() + " is invalid.");
    }

    public static MutableComponent buildSetDisplayBlockLink(IMarkableRegion region) {
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.display.block.link.text", (String)"set");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.display.block.link.hover", (String)"Set display block for area of %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayBlockCommand(region), ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildDisplayGlowInfo(IMarkableRegion region) {
        boolean hasGlow = region.getArea().getDisplay().hasGlow();
        MutableComponent text = hasGlow ? Component.translatableWithFallback((String)"cli.msg.info.region.display.glow-on.text", (String)"enabled") : Component.translatableWithFallback((String)"cli.msg.info.region.display.glow-off.text", (String)"disabled");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.display.glow.hover", (String)"Glow effect for area display is %s", (Object[])new Object[]{hasGlow ? "enabled" : "disabled"});
        return ChatComponentBuilder.buildTextWithHoverMsg(text, hover, hasGlow ? ChatFormatting.GREEN : ChatFormatting.RED);
    }

    public static MutableComponent buildDisplayLightLevelInfo(IMarkableRegion region) {
        MutableComponent text = Component.literal((String)String.valueOf(region.getArea().getDisplay().lightLevel()));
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.display.light-level.hover", (String)"Light level for area display is %s", (Object[])new Object[]{region.getArea().getDisplay().lightLevel()});
        return ChatComponentBuilder.buildTextWithHoverMsg(text, hover, ChatFormatting.RESET);
    }

    public static MutableComponent buildSetDisplayGlowOnLink(IMarkableRegion region) {
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.display.glow-on.link.text", (String)"on");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.display.glow-on.link.hover", (String)"Enable glow effect for block display");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayGlowCommand(region, true), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildSetDisplayGlowOffLink(IMarkableRegion region) {
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.display.glow-off.link.text", (String)"off");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.display.glow-off.link.hover", (String)"Disable glow effect for block display");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayGlowCommand(region, false), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildSetDisplayLightLevelLink(IMarkableRegion region) {
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.display.light-level.link.text", (String)"set");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.display.light-level.link.hover", (String)"Set light level for area display");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayLightLevelCommand(region), ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }
}

