/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp;

import com.mojang.brigadier.CommandDispatcher;
import de.z0rdak.yawp.YAWPCommon;
import de.z0rdak.yawp.YAWPModInitializer;
import de.z0rdak.yawp.api.events.flag.ForgeFlagEvent;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.commands.CommandRegistry;
import de.z0rdak.yawp.config.ConfigRegistry;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.data.PlayerManager;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.YawpEventHandler;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="yawp")
public class YetAnotherWorldProtector
implements YAWPModInitializer {
    public YetAnotherWorldProtector() {
        YAWPCommon.init();
        this.registerConfig();
        this.setupRegionDataLifecycleHooks();
        this.registerCommands();
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (s, b) -> true));
        MinecraftForge.EVENT_BUS.register(YetAnotherWorldProtector.class);
    }

    @SubscribeEvent
    public static void onAddFlag(ForgeFlagEvent.AddFlagEvent event) {
        if (event.getFlag().getName().contains("spawning") && Services.FLAG_CONFIG.removeEntitiesEnabled()) {
            YawpEventHandler.removeInvolvedEntities(event.getSrc(), event.getRegion(), RegionFlag.fromId(event.getFlag().getName()));
        }
    }

    @Override
    public void registerCommands() {
        MinecraftForge.EVENT_BUS.addListener(this::registerCommandsForge);
    }

    private void registerCommandsForge(RegisterCommandsEvent event) {
        CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @Override
    public void setupRegionDataLifecycleHooks() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, startEvent -> RegionDataManager.onServerStarting(startEvent.getServer()));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, startEvent -> PlayerManager.onServerStart(startEvent.getServer()));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, startEvent -> VisualizationManager.initServerInstance(startEvent.getServer()));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, event -> {
            LevelAccessor patt3786$temp = event.getLevel();
            if (patt3786$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt3786$temp;
                if (serverLevel.m_46472_().equals((Object)ServerLevel.f_46428_)) {
                    RegionDataManager.loadLevelListData(serverLevel.m_7654_());
                }
                RegionDataManager.worldLoad(serverLevel.m_7654_(), serverLevel);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, event -> {
            Level patt4359$temp = event.getEntity().m_20193_();
            if (patt4359$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt4359$temp;
                RegionDataManager.initLevelDataOnLogin((Entity)event.getEntity(), (Level)serverLevel);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, saveEvent -> {
            LevelAccessor patt4703$temp = saveEvent.getLevel();
            if (patt4703$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt4703$temp;
                RegionDataManager.save(serverLevel.m_7654_(), false, false);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, event -> {
            Entity patt5044$temp = event.getEntity();
            if (patt5044$temp instanceof Player) {
                Player player = (Player)patt5044$temp;
                if (event.getEntity().m_20194_() != null) {
                    ServerLevel targetLevel = event.getEntity().m_20194_().m_129880_(event.getDimension());
                    RegionDataManager.initLevelDataOnChangeWorld(player, player.m_9236_(), (Level)targetLevel);
                }
            }
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, stoppingEvent -> RegionDataManager.saveOnStop(stoppingEvent.getServer()));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, unloadEvent -> {
            LevelAccessor patt5730$temp = unloadEvent.getLevel();
            if (patt5730$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt5730$temp;
                RegionDataManager.saveOnUnload(serverLevel.m_7654_(), serverLevel);
            }
        });
    }

    @Override
    public void registerConfig() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerConfigForge);
    }

    public void registerConfigForge(FMLCommonSetupEvent event) {
        ConfigRegistry.register();
    }
}

