/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api;

import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagContext;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class FlagEvaluator {
    public static FlagState processCheck(@NotNull FlagCheckEvent checkEvent, @Nullable Consumer<FlagCheckResult> onAllow, @Nullable Consumer<FlagCheckResult> onDeny) {
        FlagCheckResult result = FlagEvaluator.evaluate(checkEvent);
        FlagState state = (result = Services.EVENT.post(result)).getFlagState();
        if (state == FlagState.ALLOWED && onAllow != null) {
            onAllow.accept(result);
        }
        if (state == FlagState.DENIED && onDeny != null) {
            onDeny.accept(result);
        }
        return state;
    }

    public static FlagState processCheckF(@NotNull FlagCheckEvent checkEvent, @Nullable Function<FlagCheckResult, FlagState> handleResult) {
        FlagCheckResult result = FlagEvaluator.evaluate(checkEvent);
        result = Services.EVENT.post(result);
        if (handleResult != null) {
            return handleResult.apply(result);
        }
        return result.getFlagState();
    }

    public static FlagState processCheck(@NotNull FlagCheckEvent checkEvent, @Nullable Consumer<FlagCheckResult> onDeny) {
        return FlagEvaluator.processCheck(checkEvent, null, onDeny);
    }

    public static FlagState processCheck(@NotNull FlagCheckEvent checkEvent) {
        return FlagEvaluator.processCheck(checkEvent, null, null);
    }

    public static FlagCheckResult evaluate(FlagCheckEvent checkEvent) {
        IProtectedRegion targetRegion = FlagEvaluator.findResponsibleRegion(checkEvent.getTarget(), checkEvent.getDimension());
        if (targetRegion == null) {
            return FlagCheckResult.Undefined(checkEvent);
        }
        RegionFlag regionFlag = checkEvent.getRegionFlag();
        FlagContext flagContext = new FlagContext(targetRegion, regionFlag, targetRegion.getFlag(regionFlag.name), checkEvent.getPlayer());
        FlagContext resultingContext = FlagEvaluator.resolveFlag(targetRegion, flagContext);
        return new FlagCheckResult(checkEvent, resultingContext.resultingState(), resultingContext.region(), resultingContext.flag());
    }

    public static FlagContext resolveFlag(IProtectedRegion region, FlagContext flagContext) {
        if (FlagEvaluator.isRootRegion(region)) {
            return flagContext;
        }
        FlagContext parentFlagContext = FlagContext.parentOf(region, flagContext.regionFlag(), flagContext.player());
        FlagContext merged = flagContext.inheritContext(parentFlagContext);
        return FlagEvaluator.resolveFlag(region.getParent(), merged);
    }

    public static boolean isRootRegion(@NotNull IProtectedRegion region) {
        return region.equals(region.getParent()) && region.getRegionType() == RegionType.GLOBAL;
    }

    @Nullable
    public static IProtectedRegion findResponsibleRegion(@NotNull BlockPos pos, @NotNull ResourceKey<Level> dim) {
        IMarkableRegion localRegion = FlagEvaluator.getInvolvedRegionFor(pos, dim);
        if (localRegion == null) {
            DimensionalRegion dimRegion = RegionDataManager.getOrCreate(dim).getDim();
            if (dimRegion.isActive()) {
                return dimRegion;
            }
            GlobalRegion globalRegion = RegionManager.get().getGlobalRegion();
            return globalRegion.isActive() ? globalRegion : null;
        }
        return localRegion;
    }

    private static List<IMarkableRegion> getInvolvedRegionsFor(BlockPos position, ResourceKey<Level> dim) {
        return RegionDataManager.getLocalsFor(dim).stream().filter(IProtectedRegion::isActive).filter(region -> region.contains(position)).collect(Collectors.toList());
    }

    @Nullable
    private static IMarkableRegion getInvolvedRegionFor(BlockPos position, ResourceKey<Level> dim) {
        List<IMarkableRegion> regionsForPos = FlagEvaluator.getInvolvedRegionsFor(position, dim);
        if (regionsForPos.isEmpty()) {
            return null;
        }
        return Collections.max(regionsForPos, Comparator.comparing(IMarkableRegion::getPriority));
    }

    public static void checkMobGrief(Entity entity, CallbackInfo ci) {
        FlagEvaluator.checkMobGrief(entity.m_9236_(), entity.m_20097_(), ci);
    }

    public static void checkMobGrief(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        FlagEvaluator.checkMobGrief(entity.m_9236_(), entity.m_20097_(), cir);
    }

    public static void checkMobGrief(Level world, BlockPos pos, CallbackInfo ci) {
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.MOB_GRIEFING, (ResourceKey<Level>)world.m_46472_());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }

    public static void checkMobGrief(Level world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.MOB_GRIEFING, (ResourceKey<Level>)world.m_46472_());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue((Object)false));
        }
    }
}

