/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.commands;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public final class Commands {
    private Commands() {
    }

    public static String buildCommandStr(String ... cmdTokens) {
        String baseCmd = "/yawp";
        String cmdStr = String.join((CharSequence)" ", cmdTokens);
        return baseCmd + " " + cmdStr;
    }

    public static String buildRegionBaseCmd(IProtectedRegion region) {
        switch (region.getRegionType()) {
            case GLOBAL: {
                return Commands.buildCommandStr(CommandConstants.GLOBAL.toString());
            }
            case DIMENSION: {
                return Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().m_135782_().toString());
            }
            case LOCAL: {
                return Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName());
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)region.getRegionType()));
    }

    public static String buildFlagBaseCmd(IProtectedRegion region, String flag) {
        switch (region.getRegionType()) {
            case GLOBAL: {
                return Commands.buildCommandStr(CommandConstants.FLAG.toString(), CommandConstants.GLOBAL.toString(), flag);
            }
            case DIMENSION: {
                return Commands.buildCommandStr(CommandConstants.FLAG.toString(), CommandConstants.DIM.toString(), region.getDim().m_135782_().toString(), flag);
            }
            case LOCAL: {
                return Commands.buildCommandStr(CommandConstants.FLAG.toString(), CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), flag);
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)region.getRegionType()));
    }

    public static String buildFlagBaseCmd(IProtectedRegion region, RegionFlag flag) {
        return Commands.buildFlagBaseCmd(region, flag.name);
    }

    public static String buildFlagBaseCmd(IProtectedRegion region, IFlag flag) {
        return Commands.buildFlagBaseCmd(region, flag.getName());
    }

    public static String buildRegionCmd(IProtectedRegion region, String subCmd) {
        String baseCmd = Commands.buildRegionBaseCmd(region);
        return Commands.appendSubCommand(baseCmd, subCmd);
    }

    public static String buildFlagCmd(IProtectedRegion region, String flag, String subCmd) {
        String baseCmd = Commands.buildFlagBaseCmd(region, flag);
        return Commands.appendSubCommand(baseCmd, subCmd);
    }

    public static String buildFlagInfoCmd(IProtectedRegion region, String flag) {
        return Commands.buildFlagCmd(region, flag, CommandConstants.INFO.toString());
    }

    public static String buildFlagSuggestStateCmd(IProtectedRegion region, String flag) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.STATE.toString(), "");
        return Commands.buildFlagCmd(region, flag, subCmd);
    }

    public static String buildFlagSetStateCmd(IProtectedRegion region, String flag, FlagState state) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.STATE.toString(), state.name);
        return Commands.buildFlagCmd(region, flag, subCmd);
    }

    public static String buildFlagOverrideToggleCmd(IProtectedRegion region, String flag) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.OVERRIDE.toString());
        return Commands.buildFlagCmd(region, flag, subCmd);
    }

    public static String buildFlagMsgCmd(IProtectedRegion region, String flag, String msgSubCmd) {
        String msgCmd = Commands.buildFlagCmd(region, flag, CommandConstants.MSG.toString());
        return Commands.appendSubCommand(msgCmd, msgSubCmd);
    }

    public static String buildFlagMsgSetCmd(IProtectedRegion region, String flag, String msg) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.SET.toString(), msg);
        return Commands.buildFlagMsgCmd(region, flag, subCmd);
    }

    public static String buildFlagMsgClearCmd(IProtectedRegion region, String flag) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.CLEAR.toString());
        return Commands.buildFlagMsgCmd(region, flag, subCmd);
    }

    public static String buildFlagMsgMuteToggleCmd(IProtectedRegion region, String flag) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.MUTE.toString());
        return Commands.buildFlagMsgCmd(region, flag, subCmd);
    }

    public static String buildRegionInfoCmd(IProtectedRegion region) {
        return Commands.buildRegionCmd(region, CommandConstants.INFO.toString());
    }

    public static String buildDisplayCommand(IMarkableRegion region) {
        return Commands.buildRegionCmd(region, CommandConstants.DISPLAY.toString());
    }

    public static String buildShowCommand(IMarkableRegion region) {
        return Commands.buildRegionCmd(region, CommandConstants.SHOW.toString());
    }

    public static String buildShowSubCommand(IMarkableRegion region, String subCmd) {
        String baseCmd = Commands.buildShowCommand(region);
        return Commands.appendSubCommand(baseCmd, subCmd);
    }

    public static String buildHideCommand(IMarkableRegion region) {
        return Commands.buildRegionCmd(region, CommandConstants.HIDE.toString());
    }

    public static String buildHideSubCommand(IMarkableRegion region, String subCmd) {
        String baseCmd = Commands.buildHideCommand(region);
        return Commands.appendSubCommand(baseCmd, subCmd);
    }

    public static String buildDisplaySubCommand(IMarkableRegion region, String subCmd) {
        String baseCmd = Commands.buildDisplayCommand(region);
        return Commands.appendSubCommand(baseCmd, subCmd);
    }

    public static String buildSetDisplayBlockCommand(IMarkableRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.BLOCK.toString(), "");
        return Commands.buildDisplaySubCommand(region, subCmd);
    }

    public static String buildSetDisplayBlockCommand(IMarkableRegion region, ResourceLocation block) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.BLOCK.toString(), block.toString());
        return Commands.buildDisplaySubCommand(region, subCmd);
    }

    public static String buildSetDisplayGlowCommand(IMarkableRegion region, boolean on) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.GLOW.toString(), Boolean.toString(on));
        return Commands.buildDisplaySubCommand(region, subCmd);
    }

    public static String buildSetDisplayLightLevelCommand(IMarkableRegion region, int lightLevel) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.LIGHT_LEVEL.toString(), String.valueOf(lightLevel));
        return Commands.buildDisplaySubCommand(region, subCmd);
    }

    public static String buildSetDisplayLightLevelCommand(IMarkableRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.LIGHT_LEVEL.toString(), "");
        return Commands.buildDisplaySubCommand(region, subCmd);
    }

    public static String buildVisualizationHideCommand(IMarkableRegion region, DisplayType displayType) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.LOCAL.toString(), displayType.name);
        return Commands.buildHideSubCommand(region, subCmd);
    }

    public static String buildVisualizationShowCommand(IMarkableRegion region, DisplayType displayType) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.LOCAL.toString(), displayType.name);
        return Commands.buildShowSubCommand(region, subCmd);
    }

    public static String buildAdvancedVisualizationShowCommand(IMarkableRegion region, DisplayType displayType, ResourceLocation block, boolean glow, int lightLevel) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.LOCAL.toString(), displayType.name, block.toString(), String.valueOf(glow), String.valueOf(lightLevel));
        return Commands.buildShowSubCommand(region, subCmd);
    }

    public static String buildVisualizationHideHierarchyCommand(IMarkableRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.HIERARCHY.toString());
        return Commands.buildHideSubCommand(region, subCmd);
    }

    public static String buildVisualizationShowHierarchyCommand(IMarkableRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.HIERARCHY.toString());
        return Commands.buildShowSubCommand(region, subCmd);
    }

    public static String buildVisualizationHideIntersectingCommand(IMarkableRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.INTERSECTING.toString());
        return Commands.buildHideSubCommand(region, subCmd);
    }

    public static String buildVisualizationShowIntersectingCommand(IMarkableRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.INTERSECTING.toString());
        return Commands.buildShowSubCommand(region, subCmd);
    }

    public static String buildRegionStateCmd(IProtectedRegion region) {
        return Commands.buildRegionCmd(region, CommandConstants.STATE.toString());
    }

    public static String buildRegionStateEnableToggleCmd(IProtectedRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.STATE.toString(), CommandConstants.ENABLE.toString());
        return Commands.buildRegionCmd(region, subCmd);
    }

    public static String buildRegionStateAlertToggleCmd(IProtectedRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.STATE.toString(), CommandConstants.ALERT.toString());
        return Commands.buildRegionCmd(region, subCmd);
    }

    private static String buildListCommand(IProtectedRegion region, String listSubCmd) {
        String subCmd = Commands.buildRegionCmd(region, CommandConstants.LIST.toString());
        return Commands.appendSubCommand(subCmd, listSubCmd);
    }

    public static String buildRemoveGroupMemberCommand(IProtectedRegion region, GroupType type, String groupName, String member) {
        String remove = Commands.buildSubCmdStr(type.name, groupName, member);
        return Commands.buildRemoveCommand(region, remove);
    }

    public static String buildRemoveOfflinePlayerCommand(IProtectedRegion region, String groupName, GroupType type, String player) {
        String remove = Commands.buildSubCmdStr(type.name, groupName, CommandConstants.BY_NAME.toString(), player);
        return Commands.buildRemoveCommand(region, remove);
    }

    public static String buildAddGroupMemberCommand(IProtectedRegion region, GroupType type, String groupName, String member) {
        String addCmd = Commands.buildSubCmdStr(type.name, groupName, member);
        return Commands.buildAddCommand(region, addCmd);
    }

    private static String buildAddCommand(IProtectedRegion region, String listSubCmd) {
        String subCmd = Commands.buildRegionCmd(region, CommandConstants.ADD.toString());
        return Commands.appendSubCommand(subCmd, listSubCmd);
    }

    private static String buildRemoveCommand(IProtectedRegion region, String listSubCmd) {
        String subCmd = Commands.buildRegionCmd(region, CommandConstants.REMOVE.toString());
        return Commands.appendSubCommand(subCmd, listSubCmd);
    }

    public static String buildSubCmdStr(String ... cmdTokens) {
        return String.join((CharSequence)" ", cmdTokens);
    }

    public static String appendSubCommand(String cmd, String ... subCommands) {
        return String.join((CharSequence)" ", cmd, String.join((CharSequence)" ", subCommands));
    }

    public static String buildListFlagsCommand(IProtectedRegion region) {
        return Commands.buildListCommand(region, CommandConstants.FLAG.toString());
    }

    public static String buildListRegionFlagsCommand(IProtectedRegion region) {
        return Commands.buildListCommand(region, CommandConstants.REGION_FLAG.toString());
    }

    public static String buildAddFlagCommand(IProtectedRegion region, String flag) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.FLAG.toString(), flag);
        return Commands.buildAddCommand(region, subCmd);
    }

    public static String buildListTeleportAnchorCommand(IProtectedRegion region) {
        return Commands.buildListCommand(region, CommandConstants.TP_ANCHOR.toString());
    }

    public static String buildTeleportAnchorCommand(IProtectedRegion region) {
        return Commands.buildRegionCmd(region, CommandConstants.TP_ANCHOR.toString());
    }

    public static String buildTeleportAnchorSubCommand(IMarkableRegion region, String subCmd) {
        String baseCmd = Commands.buildTeleportAnchorCommand(region);
        return Commands.appendSubCommand(baseCmd, subCmd);
    }

    public static String buildTeleportTpAnchorCommand(IMarkableRegion region, String name) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.TELEPORT.toString(), name);
        return Commands.buildTeleportAnchorSubCommand(region, subCmd);
    }

    public static String buildShowTpAnchorCommand(IMarkableRegion region, String name) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.SHOW.toString(), name);
        return Commands.buildTeleportAnchorSubCommand(region, subCmd);
    }

    public static String buildHideTpAnchorCommand(IMarkableRegion region, String name) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.HIDE.toString(), name);
        return Commands.buildTeleportAnchorSubCommand(region, subCmd);
    }

    public static String buildSuggestRenameTpAnchorCommand(IMarkableRegion region, String name) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.RENAME.toString(), name, "");
        return Commands.buildTeleportAnchorSubCommand(region, subCmd);
    }

    public static String buildRenameTpAnchorCommand(IMarkableRegion region, String name, String newName) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.RENAME.toString(), name, newName);
        return Commands.buildTeleportAnchorSubCommand(region, subCmd);
    }

    public static String buildSuggestUpdateTpAnchorCommand(IMarkableRegion region, String name) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.SET.toString(), name, "");
        return Commands.buildTeleportAnchorSubCommand(region, subCmd);
    }

    public static String buildUpdateTpAnchorCommand(IMarkableRegion region, String name, BlockPos pos) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.SET.toString(), name, ChatComponentBuilder.commandBlockPosStr(pos));
        return Commands.buildTeleportAnchorSubCommand(region, subCmd);
    }

    public static String buildAddTeleportAnchorCommand(IMarkableRegion region, String name, BlockPos pos) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.TP_ANCHOR.toString(), name, ChatComponentBuilder.commandBlockPosStr(pos));
        return Commands.buildAddCommand(region, subCmd);
    }

    public static String buildSuggestAddTeleportAnchorCommand(IMarkableRegion region) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.TP_ANCHOR.toString(), "");
        return Commands.buildAddCommand(region, subCmd);
    }

    public static String buildRemoveTeleportAnchorCommand(IMarkableRegion region, String name) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.TP_ANCHOR.toString(), name);
        return Commands.buildRemoveCommand(region, subCmd);
    }

    public static String buildListLocalRegionCommand(ResourceLocation levelRl) {
        return Commands.buildCommandStr(CommandConstants.DIM.toString(), levelRl.toString(), CommandConstants.LIST.toString(), CommandConstants.LOCAL.toString());
    }

    public static String buildListGroupMemberCommand(IProtectedRegion region, String group, GroupType groupType) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.GROUP.toString(), group, groupType.name);
        return Commands.buildListCommand(region, subCmd);
    }

    public static String buildListGroupCommand(IProtectedRegion region, String group) {
        String subCmd = Commands.buildSubCmdStr(CommandConstants.GROUP.toString(), group);
        return Commands.buildListCommand(region, subCmd);
    }

    public static String buildListChildRegionCommand(IProtectedRegion region) {
        return Commands.buildListCommand(region, CommandConstants.CHILDREN.toString());
    }
}

