/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import de.z0rdak.yawp.api.visualization.RegionVisualization;
import de.z0rdak.yawp.api.visualization.TpAnchorVisualization;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.api.visualization.VisualizationUtil;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.area.TextDisplayProperties;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class RegionVisualizationManager {
    private final IMarkableRegion region;
    private final RegionVisualization hull;
    private final RegionVisualization frame;
    private final RegionVisualization minimalOutline;
    private final RegionVisualization marked;
    private final Map<String, TpAnchorVisualization> tpAnchorVisualizations;

    public RegionVisualizationManager(IMarkableRegion region) {
        this.region = region;
        BlockDisplayProperties blockDisplayProperties = region.getArea().getDisplay();
        this.hull = new RegionVisualization(blockDisplayProperties);
        this.frame = new RegionVisualization(blockDisplayProperties);
        this.minimalOutline = new RegionVisualization(blockDisplayProperties);
        this.marked = new RegionVisualization(blockDisplayProperties);
        this.tpAnchorVisualizations = new HashMap<String, TpAnchorVisualization>();
        region.getTpAnchors().getAnchors().forEach(anchor -> {
            TextDisplayProperties textDisplayProperties = new TextDisplayProperties(anchor.getName());
            TpAnchorVisualization tpAnchorVisualization = new TpAnchorVisualization((TeleportAnchor)anchor, blockDisplayProperties, textDisplayProperties);
            this.tpAnchorVisualizations.put(anchor.getName(), tpAnchorVisualization);
        });
    }

    public void showTpAnchor(TeleportAnchor tpAnchor, ServerLevel level, BlockDisplayProperties displayProperties, TextDisplayProperties textDisplayProperties) {
        if (!this.tpAnchorVisualizations.containsKey(tpAnchor.getName())) {
            TpAnchorVisualization tpAnchorVisualization = new TpAnchorVisualization(tpAnchor, displayProperties, textDisplayProperties);
            this.tpAnchorVisualizations.put(tpAnchor.getName(), tpAnchorVisualization);
        }
        TpAnchorVisualization tpVis = this.tpAnchorVisualizations.get(tpAnchor.getName());
        Optional<Entity> maybeEntity = VisualizationUtil.createBlockDisplayEntity(level, this.region.getName(), tpAnchor.getPos(), displayProperties);
        if (maybeEntity.isPresent()) {
            Entity entity = maybeEntity.get();
            entity.m_20049_(VisualizationManager.REGION_BLOCK_DISPLAY_TAG.toString());
            tpVis.trackTpAnchorBlockDisplay(entity);
            level.m_7967_(entity);
        }
    }

    public void showTpAnchor(TeleportAnchor tpAnchor, ServerLevel level) {
        BlockDisplayProperties blockPorps = new BlockDisplayProperties(ResourceLocation.m_214293_((String)"minecraft", (String)"cyan_stained_glass_pane"), true, 15);
        TextDisplayProperties textProps = new TextDisplayProperties(tpAnchor.getName());
        this.showTpAnchor(tpAnchor, level, blockPorps, textProps);
    }

    public void hideTpAnchor(TeleportAnchor tpAnchor, ServerLevel level) {
        if (this.tpAnchorVisualizations.containsKey(tpAnchor.getName())) {
            TpAnchorVisualization tpVis = this.tpAnchorVisualizations.get(tpAnchor.getName());
            tpVis.discardTpAnchorDisplay();
        }
    }

    public void updateTpAnchor(TeleportAnchor anchor) {
        if (this.tpAnchorVisualizations.containsKey(anchor.getName())) {
            TpAnchorVisualization tpVis = this.tpAnchorVisualizations.get(anchor.getName());
            tpVis.updateBlockPosition(anchor);
        }
    }

    public Set<BlockPos> blocksForDisplayType(DisplayType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DisplayType.FRAME -> this.region.getArea().getFrame();
            case DisplayType.HULL -> this.region.getArea().getHull();
            case DisplayType.MINIMAL -> this.region.getArea().getMinimalOutline();
            case DisplayType.MARKED -> this.region.getArea().markedBlocks();
        };
    }

    public void show(DisplayType displayType, BlockDisplayProperties displayProperties, ServerLevel level) {
        Set<BlockPos> blocks = this.blocksForDisplayType(displayType);
        blocks.stream().filter(pos -> {
            boolean bl;
            block7: {
                block6: {
                    switch (displayType) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case FRAME: {
                            if (!this.frame.doesTrackEntityAt((BlockPos)pos)) break;
                            break block6;
                        }
                        case HULL: {
                            if (!this.hull.doesTrackEntityAt((BlockPos)pos)) break;
                            break block6;
                        }
                        case MINIMAL: {
                            if (!this.minimalOutline.doesTrackEntityAt((BlockPos)pos)) break;
                            break block6;
                        }
                        case MARKED: {
                            if (this.marked.doesTrackEntityAt((BlockPos)pos)) break block6;
                        }
                    }
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            return bl;
        }).forEach(pos -> {
            Optional<Entity> maybeEntity = VisualizationUtil.createBlockDisplayEntity(level, this.region.getName(), pos, displayProperties);
            if (maybeEntity.isPresent()) {
                Entity entity = maybeEntity.get();
                entity.m_20049_(VisualizationManager.REGION_BLOCK_DISPLAY_TAG.toString());
                switch (displayType) {
                    case FRAME: {
                        this.frame.trackBlockDisplay((BlockPos)pos, entity);
                        break;
                    }
                    case HULL: {
                        this.hull.trackBlockDisplay((BlockPos)pos, entity);
                        break;
                    }
                    case MINIMAL: {
                        this.minimalOutline.trackBlockDisplay((BlockPos)pos, entity);
                        break;
                    }
                    case MARKED: {
                        this.marked.trackBlockDisplay((BlockPos)pos, entity);
                    }
                }
                level.m_7967_(entity);
            }
        });
    }

    public void show(DisplayType displayType, ServerLevel level) {
        this.show(displayType, this.region.getArea().getDisplay(), level);
    }

    public void hide(DisplayType displayType) {
        switch (displayType) {
            case FRAME: {
                this.frame.discardEntities();
                break;
            }
            case HULL: {
                this.hull.discardEntities();
                break;
            }
            case MINIMAL: {
                this.minimalOutline.discardEntities();
                break;
            }
            case MARKED: {
                this.marked.discardEntities();
            }
        }
    }

    public void updateDisplay(IMarkableArea area, ServerLevel level) {
        this.region.setArea(area);
        if (this.frame.hasEntitiesTracked()) {
            this.frame.discardEntities();
            this.show(DisplayType.FRAME, this.frame.getProperties(), level);
        }
        if (this.hull.hasEntitiesTracked()) {
            this.hull.discardEntities();
            this.show(DisplayType.HULL, this.hull.getProperties(), level);
        }
        if (this.minimalOutline.hasEntitiesTracked()) {
            this.minimalOutline.discardEntities();
            this.show(DisplayType.MINIMAL, this.minimalOutline.getProperties(), level);
        }
        if (this.marked.hasEntitiesTracked()) {
            this.marked.discardEntities();
            this.show(DisplayType.MARKED, this.marked.getProperties(), level);
        }
    }

    public void updateDisplay(BlockDisplayProperties displayProperties, DisplayType displayType) {
        this.frame.updateDisplay(displayProperties, false);
        this.hull.updateDisplay(displayProperties, false);
        this.minimalOutline.updateDisplay(displayProperties, false);
        this.marked.updateDisplay(displayProperties, false);
        switch (displayType) {
            case FRAME: {
                this.frame.updateDisplay(displayProperties, true);
                break;
            }
            case HULL: {
                this.hull.updateDisplay(displayProperties, true);
                break;
            }
            case MINIMAL: {
                this.minimalOutline.updateDisplay(displayProperties, true);
                break;
            }
            case MARKED: {
                this.marked.updateDisplay(displayProperties, true);
            }
        }
    }

    public void updateDisplay(BlockDisplayProperties displayProperties, boolean refresh) {
        this.frame.updateDisplay(displayProperties, refresh);
        this.hull.updateDisplay(displayProperties, refresh);
        this.minimalOutline.updateDisplay(displayProperties, refresh);
        this.marked.updateDisplay(displayProperties, refresh);
    }
}

