/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.TextDisplayProperties;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public final class VisualizationUtil {
    private VisualizationUtil() {
    }

    public static void updateDisplayBlock(Entity blockDisplayEntity, ResourceLocation blockRl) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.m_6184_();
        CompoundTag blockState = entityTag.m_128469_("block_state");
        blockState.m_128359_("Name", blockRl.toString());
        entityTag.m_128365_("block_state", (Tag)blockState);
        try {
            entityDataAccessor.m_7603_(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayGlow(Entity blockDisplayEntity, boolean glow) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.m_6184_();
        entityTag.m_128379_("Glowing", glow);
        try {
            entityDataAccessor.m_7603_(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayLightLevel(Entity blockDisplayEntity, int lightLevel) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.m_6184_();
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.m_128405_("sky", lightLevel);
        brightnessTag.m_128405_("block", lightLevel);
        entityTag.m_128365_("brightness", (Tag)brightnessTag);
        try {
            entityDataAccessor.m_7603_(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayProperties(Entity blockDisplayEntity, BlockDisplayProperties properties) {
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.m_6184_();
        CompoundTag blockState = entityTag.m_128469_("block_state");
        blockState.m_128359_("Name", properties.blockRl().toString());
        entityTag.m_128365_("block_state", (Tag)blockState);
        entityTag.m_128379_("Glowing", properties.hasGlow());
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.m_128405_("sky", properties.lightLevel());
        brightnessTag.m_128405_("block", properties.lightLevel());
        entityTag.m_128365_("brightness", (Tag)brightnessTag);
        try {
            entityDataAccessor.m_7603_(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static Entity createBlockDisplayRecursive(ServerLevel level, BlockPos pos, CompoundTag displayTag) {
        return EntityType.m_20645_((CompoundTag)displayTag, (Level)level, p_396566_ -> {
            p_396566_.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), p_396566_.m_146908_(), p_396566_.m_146909_());
            return p_396566_;
        });
    }

    public static Optional<Entity> createDisplayEntity(ServerLevel level, BlockPos pos, CompoundTag displayTag) {
        Optional entity = EntityType.m_20642_((CompoundTag)displayTag, (Level)level);
        entity.ifPresent(e -> e.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), e.f_19859_, e.f_19860_));
        return entity;
    }

    public static Optional<Entity> createTextDisplayEntity(ServerLevel level, String regionName, BlockPos pos, TextDisplayProperties displayProperties) {
        CompoundTag entityTag = VisualizationUtil.buildTeleportAnchorTextDisplayTag(regionName, displayProperties);
        Optional maybeEntity = EntityType.m_20642_((CompoundTag)entityTag, (Level)level);
        maybeEntity.ifPresent(e -> e.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), e.f_19859_, e.f_19860_));
        return maybeEntity;
    }

    public static Optional<Entity> createBlockDisplayEntity(ServerLevel level, String regionName, BlockPos pos, BlockDisplayProperties displayProperties) {
        CompoundTag entityTag = VisualizationUtil.buildBlockDisplayTag(regionName, displayProperties);
        Optional maybeEntity = EntityType.m_20642_((CompoundTag)entityTag, (Level)level);
        maybeEntity.ifPresent(e -> e.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), e.f_19859_, e.f_19860_));
        return maybeEntity;
    }

    public static CompoundTag buildTeleportAnchorTextDisplayTag(String regionName, TextDisplayProperties properties) {
        CompoundTag textDisplayTag = new CompoundTag();
        ResourceLocation blockDisplayRl = ResourceLocation.m_214293_((String)"minecraft", (String)"text_display");
        textDisplayTag.m_128359_("id", blockDisplayRl.toString());
        CompoundTag data = new CompoundTag();
        data.m_128359_("yawp_display", "text");
        data.m_128359_("region", regionName);
        data.m_128359_("tpAnchor", properties.getText());
        textDisplayTag.m_128365_("data", (Tag)data);
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.m_128405_("sky", 15);
        brightnessTag.m_128405_("block", 15);
        textDisplayTag.m_128365_("brightness", (Tag)brightnessTag);
        textDisplayTag.m_128359_("billboard", "center");
        MutableComponent text = Component.m_237113_((String)properties.toString());
        textDisplayTag.m_128359_("text", text.toString());
        textDisplayTag.m_128359_("alignment", "center");
        textDisplayTag.m_128405_("background", 0x1A000000);
        return textDisplayTag;
    }

    public static CompoundTag buildBlockDisplayTag(String regionName, BlockDisplayProperties properties) {
        CompoundTag blockDisplayTag = new CompoundTag();
        ResourceLocation blockDisplayRl = ResourceLocation.m_214293_((String)"minecraft", (String)"block_display");
        blockDisplayTag.m_128359_("id", blockDisplayRl.m_135815_());
        blockDisplayTag.m_128379_("Glowing", properties.hasGlow());
        CompoundTag data = new CompoundTag();
        data.m_128359_("yawp_display", "block");
        data.m_128359_("region", regionName);
        blockDisplayTag.m_128365_("data", (Tag)data);
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.m_128405_("sky", properties.lightLevel());
        brightnessTag.m_128405_("block", properties.lightLevel());
        blockDisplayTag.m_128365_("brightness", (Tag)brightnessTag);
        CompoundTag blockstateTag = new CompoundTag();
        blockstateTag.m_128359_("Name", properties.blockRl().toString());
        blockDisplayTag.m_128365_("block_state", (Tag)blockstateTag);
        return blockDisplayTag;
    }
}

