/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;

public enum CommandSourceType {
    PLAYER("player"),
    SERVER("server"),
    COMMAND_BLOCK("command-block"),
    NON_PLAYER("non-player"),
    UNKNOWN("unknown");

    public final String source;

    private CommandSourceType(String source) {
        this.source = source;
    }

    public static CommandSourceType of(CommandSourceStack cmdSrc) throws IllegalArgumentException {
        if (cmdSrc == null) {
            throw new IllegalArgumentException("Command source can't be null!");
        }
        try {
            Entity cmdSrcEntity = cmdSrc.m_81374_();
            if (!(cmdSrcEntity instanceof Player)) {
                if (cmdSrcEntity instanceof MinecartCommandBlock) {
                    return COMMAND_BLOCK;
                }
                return NON_PLAYER;
            }
            return PLAYER;
        }
        catch (CommandSyntaxException e) {
            if (cmdSrc.m_81368_().equals("Server")) {
                return SERVER;
            }
            return COMMAND_BLOCK;
        }
    }

    public String toString() {
        return this.source;
    }
}

