/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.commands.CommandUtil;
import de.z0rdak.yawp.commands.DimensionCommands;
import de.z0rdak.yawp.commands.RegionCommands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.region.ContainingOwnedRegionArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.RegionsInDimensionPagination;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

class ShortcutCommands {
    private ShortcutCommands() {
    }

    static LiteralArgumentBuilder<CommandSourceStack> buildInfoLocal() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.INFO).then(Commands.m_82129_((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (Level)((CommandSourceStack)ctx.getSource()).m_81372_())).executes(ctx -> CommandUtil.promptRegionInfo((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionIn((CommandContext<CommandSourceStack>)ctx, (Level)((CommandSourceStack)ctx.getSource()).m_81372_()))));
    }

    static LiteralArgumentBuilder<CommandSourceStack> buildDeleteLocal() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.DELETE).then(Commands.m_82129_((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (Level)((CommandSourceStack)ctx.getSource()).m_81372_())).executes(ctx -> DimensionCommands.deleteRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionIn((CommandContext<CommandSourceStack>)ctx, (Level)((CommandSourceStack)ctx.getSource()).m_81372_()))));
    }

    static LiteralArgumentBuilder<CommandSourceStack> buildCreateLocal() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.CREATE).then(((RequiredArgumentBuilder)Commands.m_82129_((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(Collections.singletonList(DimensionCommands.getRandomExample()), (SuggestionsBuilder)builder)).then(Commands.m_82127_((String)AreaType.CUBOID.areaType).then(Commands.m_82129_((String)CommandConstants.POS1.toString(), (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)CommandConstants.POS2.toString(), (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> DimensionCommands.createCuboidRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.m_174395_((CommandContext)ctx, (String)CommandConstants.POS1.toString()), BlockPosArgument.m_174395_((CommandContext)ctx, (String)CommandConstants.POS2.toString()), null))).then(Commands.m_82129_((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder)).executes(ctx -> DimensionCommands.createCuboidRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.m_174395_((CommandContext)ctx, (String)CommandConstants.POS1.toString()), BlockPosArgument.m_174395_((CommandContext)ctx, (String)CommandConstants.POS2.toString()), ArgumentUtil.getContainingOwnedRegionArgument((CommandContext<CommandSourceStack>)ctx)))))))).then(Commands.m_82127_((String)AreaType.SPHERE.areaType).then(Commands.m_82129_((String)CommandConstants.CENTER_POS.toString(), (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> DimensionCommands.createSphereRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.m_174395_((CommandContext)ctx, (String)CommandConstants.CENTER_POS.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()), null))).then(Commands.m_82129_((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder)).executes(ctx -> DimensionCommands.createSphereRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.m_174395_((CommandContext)ctx, (String)CommandConstants.CENTER_POS.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()), ArgumentUtil.getContainingOwnedRegionArgument((CommandContext<CommandSourceStack>)ctx))))))));
    }

    static LiteralArgumentBuilder<CommandSourceStack> buildHide() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.HIDE).then(ArgumentUtil.literal(CommandConstants.LOCAL).then(((RequiredArgumentBuilder)Commands.m_82129_((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (Level)((CommandSourceStack)ctx.getSource()).m_81372_())).executes(ctx -> RegionCommands.hideRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionIn((CommandContext<CommandSourceStack>)ctx, (Level)((CommandSourceStack)ctx.getSource()).m_81372_()), DisplayType.FRAME))).then(Commands.m_82129_((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.hideRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionIn((CommandContext<CommandSourceStack>)ctx, (Level)((CommandSourceStack)ctx.getSource()).m_81372_()), ArgumentUtil.getDisplayTypeArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ShortcutCommands.buildHideAll())).then(ShortcutCommands.buildHideNear());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildHideAll() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ALL).executes(ShortcutCommands::hideRegions)).then(Commands.m_82129_((String)CommandConstants.UNTRACKED.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ShortcutCommands.hideRegions((CommandContext<CommandSourceStack>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)CommandConstants.UNTRACKED.toString()))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildHideNear() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.NEAR).executes(ctx -> ShortcutCommands.hideRegionsAroundPlayer((CommandContext<CommandSourceStack>)ctx, 192))).then(Commands.m_82129_((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0, (int)800)).executes(ctx -> ShortcutCommands.hideRegionsAroundPlayer((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildShowNear() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.NEAR).executes(ctx -> ShortcutCommands.showRegionsAroundPlayer((CommandContext<CommandSourceStack>)ctx, DisplayType.FRAME, 192))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0, (int)800)).executes(ctx -> ShortcutCommands.showRegionsAroundPlayer((CommandContext<CommandSourceStack>)ctx, DisplayType.FRAME, IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString())))).then(Commands.m_82129_((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> ShortcutCommands.showRegionsAroundPlayer((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getDisplayTypeArgument((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString())))));
    }

    static LiteralArgumentBuilder<CommandSourceStack> buildShow() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.SHOW).then(ArgumentUtil.literal(CommandConstants.LOCAL).then(((RequiredArgumentBuilder)Commands.m_82129_((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (Level)((CommandSourceStack)ctx.getSource()).m_81372_())).executes(ctx -> RegionCommands.showRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionIn((CommandContext<CommandSourceStack>)ctx, (Level)((CommandSourceStack)ctx.getSource()).m_81372_()), DisplayType.FRAME))).then(Commands.m_82129_((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.showRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionIn((CommandContext<CommandSourceStack>)ctx, (Level)((CommandSourceStack)ctx.getSource()).m_81372_()), ArgumentUtil.getDisplayTypeArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ShortcutCommands.buildShowNear());
    }

    private static int promptRegionsAroundPlayer(CommandContext<CommandSourceStack> ctx, int blockRadius) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        Optional<IDimensionRegionApi> maybeDimRegionApi = RegionManager.get().getDimRegionApi((ResourceKey<Level>)level.m_46472_());
        if (maybeDimRegionApi.isPresent()) {
            IDimensionRegionApi dimRegionApi = maybeDimRegionApi.get();
            List<IProtectedRegion> regionsAround = dimRegionApi.getRegionsAround(player.m_20183_(), blockRadius).stream().map(r -> r).collect(Collectors.toList());
            try {
                int paginationSize = Services.REGION_CONFIG.getPaginationSize();
                RegionsInDimensionPagination childRegionPagination = new RegionsInDimensionPagination(dimRegionApi.getCache(), regionsAround, 0, paginationSize);
                MultiLineMessage.send((CommandSourceStack)ctx.getSource(), childRegionPagination);
            }
            catch (InvalidPageNumberException e) {
                MessageSender.sendError((CommandSourceStack)ctx.getSource(), e.getError());
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private static int showRegionsAroundPlayer(CommandContext<CommandSourceStack> ctx, DisplayType displayType, int blockRadius) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        VisualizationManager.showRegionsAround((Player)player, blockRadius, displayType);
        Level level = player.m_20193_();
        BlockPos playerPos = player.m_20183_();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((ResourceKey<Level>)level.m_46472_());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> list = dimApi.getRegionsAround(playerPos, blockRadius);
        }
        return 0;
    }

    private static int hideRegions(CommandContext<CommandSourceStack> ctx) {
        return ShortcutCommands.hideRegions(ctx, false);
    }

    private static int hideRegions(CommandContext<CommandSourceStack> ctx, boolean untracked) {
        VisualizationManager.hideAllRegions((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), untracked);
        return 0;
    }

    private static int hideRegionsAroundPlayer(CommandContext<CommandSourceStack> ctx, int blockRadius) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        VisualizationManager.hideRegionsAround((Player)player, blockRadius);
        return 0;
    }
}

