/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;

public final class BlockDisplayProperties {
    public static final boolean DEFAULT_GLOW = true;
    public static final int DEFAULT_LIGHT_LEVEL = 15;
    public static final List<ResourceLocation> DEFAULT_BLOCKS = new ArrayList<ResourceLocation>();
    public static MapCodec<BlockDisplayProperties> CODEC;
    private ResourceLocation blockRl;
    private boolean hasGlow;
    private int lightLevel;

    public static ResourceLocation randomFromDefault() {
        int randomNum = new Random().nextInt(0, 16);
        return DEFAULT_BLOCKS.get(randomNum);
    }

    public static BlockDisplayProperties createRndDefault() {
        return new BlockDisplayProperties(BlockDisplayProperties.randomFromDefault(), true, 15);
    }

    public BlockDisplayProperties(ResourceLocation blockRl, boolean hasGlow, int lightLevel) {
        this.blockRl = blockRl;
        this.hasGlow = hasGlow;
        this.lightLevel = lightLevel;
    }

    public ResourceLocation blockRl() {
        return this.blockRl;
    }

    public boolean hasGlow() {
        return this.hasGlow;
    }

    public int lightLevel() {
        return this.lightLevel;
    }

    public void setBlockRl(ResourceLocation blockRl) {
        this.blockRl = blockRl;
    }

    public void setHasGlow(boolean hasGlow) {
        this.hasGlow = hasGlow;
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
    }

    static {
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "white_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "orange_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "magenta_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "light_blue_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "yellow_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "lime_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "pink_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "gray_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "light_gray_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "cyan_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "purple_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "blue_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "brown_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "green_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "red_stained_glass"));
        DEFAULT_BLOCKS.add(new ResourceLocation("minecraft", "black_stained_glass"));
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("block").orElse((Object)BlockDisplayProperties.randomFromDefault()).forGetter(BlockDisplayProperties::blockRl), (App)Codec.BOOL.fieldOf("hasGlow").orElse((Object)true).forGetter(BlockDisplayProperties::hasGlow), (App)Codec.INT.fieldOf("lightLevel").orElse((Object)15).forGetter(BlockDisplayProperties::lightLevel)).apply((Applicative)instance, BlockDisplayProperties::new));
    }
}

